/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.mob.tools.MobLog;
import com.mob.tools.gui.BitmapProcessor;
import com.mob.tools.utils.BitmapHelper;
import com.mob.tools.utils.UIHandler;
import java.util.Random;

public class AsyncImageView
extends ImageView
implements BitmapProcessor.BitmapCallback,
Handler.Callback {
    private static final int MSG_IMG_GOT = 1;
    private static final Random RND = new Random();
    private float[] rect;
    private boolean scaleToCrop;
    private String url;
    private int defaultRes;
    private Bitmap defaultBm;
    private Path path;
    private boolean lastReqIsOk;

    public AsyncImageView(Context context) {
        super(context);
        this.init(context);
    }

    public AsyncImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AsyncImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        if (this.isInEditMode()) {
            this.setBackgroundColor(-16777216);
            return;
        }
        BitmapProcessor.prepare(context);
    }

    public void setRound(float radius) {
        this.setRound(radius, radius, radius, radius);
    }

    public void setRound(float leftTop, float rightTop, float rightBottom, float leftBottom) {
        this.rect = new float[]{leftTop, leftTop, rightTop, rightTop, rightBottom, rightBottom, leftBottom, leftBottom};
    }

    public void setScaleToCropCenter(boolean scaleToCrop) {
        this.scaleToCrop = scaleToCrop;
    }

    public void execute(String url, int defaultRes) {
        if (this.lastReqIsOk && url != null && url.equals(this.url)) {
            return;
        }
        this.lastReqIsOk = false;
        this.url = url;
        this.defaultRes = defaultRes;
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.setImageResource(defaultRes);
            return;
        }
        Bitmap bm = BitmapProcessor.getBitmapFromCache(url);
        if (bm != null && !bm.isRecycled()) {
            this.setBitmap(bm);
            return;
        }
        if (defaultRes > 0) {
            this.setImageResource(defaultRes);
        }
        BitmapProcessor.process(url, this);
    }

    public void execute(String url, Bitmap defaultBm) {
        if (this.lastReqIsOk && url != null && url.equals(this.url)) {
            return;
        }
        this.lastReqIsOk = false;
        this.url = url;
        this.defaultBm = defaultBm;
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.setImageBitmap(defaultBm);
            return;
        }
        Bitmap bm = BitmapProcessor.getBitmapFromCache(url);
        if (bm != null && !bm.isRecycled()) {
            this.setBitmap(bm);
            return;
        }
        if (defaultBm != null && !defaultBm.isRecycled()) {
            this.setImageBitmap(defaultBm);
        }
        BitmapProcessor.process(url, this);
    }

    public void setBitmap(Bitmap bm) {
        if (this.scaleToCrop) {
            bm = this.goCrop(bm);
        }
        this.setImageBitmap(bm);
    }

    @Override
    public void onImageGot(String url, Bitmap bm) {
        Bitmap shownImage = null;
        if (url != null && url.trim().length() > 0 && url.equals(this.url)) {
            shownImage = bm;
        }
        if (shownImage != null && this.scaleToCrop) {
            shownImage = this.goCrop(shownImage);
        }
        Message msg = new Message();
        msg.what = 1;
        msg.obj = new Object[]{url, shownImage};
        int delay = RND.nextInt(300);
        UIHandler.sendMessageDelayed(msg, delay, this);
        UIHandler.sendMessage(msg, this);
    }

    private Bitmap goCrop(Bitmap bm) {
        float width = bm.getWidth();
        float height = bm.getHeight();
        if (width == 0.0f || height == 0.0f) {
            return bm;
        }
        int[] size = this.getSize();
        if (size[0] == 0 || size[1] == 0) {
            return bm;
        }
        float respHeight = (float)size[1] * width / (float)size[0];
        if (respHeight == height) {
            return bm;
        }
        int[] rect = new int[4];
        if (respHeight < height) {
            rect[1] = (int)((height - respHeight) / 2.0f);
            rect[3] = rect[1];
        } else {
            float respWidth = (float)size[0] * height / (float)size[1];
            rect[0] = (int)((width - respWidth) / 2.0f);
            rect[2] = rect[0];
        }
        try {
            bm = BitmapHelper.cropBitmap(bm, rect[0], rect[1], rect[2], rect[3]);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return bm;
    }

    private int[] getSize() {
        ViewGroup.LayoutParams lp;
        int width = this.getWidth();
        int height = this.getHeight();
        if ((width == 0 || height == 0) && (lp = this.getLayoutParams()) != null) {
            width = lp.width;
            height = lp.height;
        }
        if (width == 0 || height == 0) {
            this.measure(0, 0);
            width = this.getMeasuredWidth();
            height = this.getMeasuredHeight();
        }
        return new int[]{width, height};
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 1) {
            Object url = ((Object[])msg.obj)[0];
            Object bm = ((Object[])msg.obj)[1];
            if (bm != null && url != null && url.equals(this.url)) {
                this.setImageBitmap((Bitmap)bm);
                this.lastReqIsOk = true;
            } else if (this.defaultBm != null && !this.defaultBm.isRecycled()) {
                this.setImageBitmap(this.defaultBm);
            } else {
                this.setImageResource(this.defaultRes);
            }
        }
        return false;
    }

    protected void onDraw(Canvas canvas) {
        if (this.rect != null) {
            if (this.path == null) {
                int width = this.getWidth();
                int height = this.getHeight();
                this.path = new Path();
                RectF bound = new RectF(0.0f, 0.0f, (float)width, (float)height);
                this.path.addRoundRect(bound, this.rect, Path.Direction.CW);
            }
            canvas.clipPath(this.path);
        }
        super.onDraw(canvas);
    }
}

