/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

import android.content.Context;
import android.view.View;
import android.widget.AbsListView;
import android.widget.GridView;
import android.widget.ListAdapter;
import com.mob.tools.gui.OnListStopScrollListener;
import com.mob.tools.gui.PullToRequestBaseAdapter;
import com.mob.tools.gui.PullToRequestBaseListAdapter;
import com.mob.tools.gui.PullToRequestView;
import com.mob.tools.gui.Scrollable;
import com.mob.tools.gui.ScrollableGridView;

public abstract class PullToRequestGridAdapter
extends PullToRequestBaseListAdapter {
    private ScrollableGridView gridView = this.onNewGridView(this.getContext());
    private PullToRequestBaseAdapter adapter;
    private boolean fling;
    private OnListStopScrollListener osListener;
    private boolean pullUpReady;

    public PullToRequestGridAdapter(PullToRequestView view) {
        super(view);
        this.gridView.setOnScrollListener(new AbsListView.OnScrollListener(){
            private int firstVisibleItem;
            private int visibleItemCount;

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                PullToRequestGridAdapter.this.fling = scrollState == 2;
                if (scrollState == 0) {
                    if (PullToRequestGridAdapter.this.osListener != null) {
                        PullToRequestGridAdapter.this.osListener.onListStopScrolling(this.firstVisibleItem, this.visibleItemCount);
                    } else if (PullToRequestGridAdapter.this.adapter != null) {
                        PullToRequestGridAdapter.this.adapter.notifyDataSetChanged();
                    }
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                this.firstVisibleItem = firstVisibleItem;
                this.visibleItemCount = visibleItemCount;
                View v = view.getChildAt(visibleItemCount - 1);
                PullToRequestGridAdapter.this.pullUpReady = firstVisibleItem + visibleItemCount == totalItemCount && v != null && v.getBottom() <= view.getBottom();
                PullToRequestGridAdapter.this.onScroll(PullToRequestGridAdapter.this.gridView, firstVisibleItem, visibleItemCount, totalItemCount);
            }
        });
        this.adapter = new PullToRequestBaseAdapter(this);
        this.gridView.setAdapter((ListAdapter)this.adapter);
    }

    protected ScrollableGridView onNewGridView(Context context) {
        return new ScrollableGridView(context);
    }

    @Override
    public Scrollable getBodyView() {
        return this.gridView;
    }

    @Override
    public boolean isPullDownReady() {
        return this.gridView.isReadyToPull();
    }

    @Override
    public boolean isPullUpReady() {
        return this.pullUpReady;
    }

    public GridView getGridView() {
        return this.gridView;
    }

    @Override
    public boolean isFling() {
        return this.fling;
    }

    @Override
    public void onScroll(Scrollable scrollable, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
    }

    @Override
    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.adapter.notifyDataSetChanged();
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        this.gridView.setHorizontalSpacing(horizontalSpacing);
    }

    public void setVerticalSpacing(int verticalSpacing) {
        this.gridView.setVerticalSpacing(verticalSpacing);
    }

    public void setNumColumns(int numColumns) {
        this.gridView.setNumColumns(numColumns);
    }

    public void setColumnWidth(int columnWidth) {
        this.gridView.setColumnWidth(columnWidth);
    }

    public void setStretchMode(int stretchMode) {
        this.gridView.setStretchMode(stretchMode);
    }
}

