/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.log;

import android.content.Context;
import com.mob.tools.log.LogCollector;
import com.mob.tools.log.LogPrinter;
import com.mob.tools.log.MobUncaughtExceptionHandler;
import com.mob.tools.log.NativeErrorHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.util.HashMap;

public abstract class NLog {
    private static LogPrinter printer;
    private static HashMap<String, NLog> loggers;

    public NLog() {
        loggers.put(this.getSDKTag(), this);
        if (loggers.size() == 1) {
            loggers.put("__FIRST__", this);
        }
    }

    public static void setContext(Context context) {
        if (context != null) {
            printer.setContext(context);
            NativeErrorHandler.prepare(context);
        }
    }

    public static void setCollector(String sdkTag, LogCollector collector) {
        printer.setCollector(sdkTag, collector);
    }

    protected static final NLog getInstanceForSDK(final String sdkTag, boolean createNew) {
        NLog instance = loggers.get(sdkTag);
        if (instance == null) {
            instance = loggers.get("__FIRST__");
        }
        if (instance == null && createNew) {
            instance = new NLog(){

                @Override
                protected String getSDKTag() {
                    return sdkTag;
                }
            };
        }
        return instance;
    }

    protected abstract String getSDKTag();

    public final int v(Throwable t) {
        return printer.println(this.getSDKTag(), 2, 0, this.getStackTraceString(t));
    }

    public final int v(Object format, Object ... args) {
        String s = format.toString();
        String message = args.length > 0 ? String.format(s, args) : s;
        return printer.println(this.getSDKTag(), 2, 0, message);
    }

    public final int v(Throwable throwable, Object format, Object ... args) {
        String s = format.toString();
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + this.getStackTraceString(throwable);
        return printer.println(this.getSDKTag(), 2, 0, message);
    }

    public final int d(Throwable t) {
        return printer.println(this.getSDKTag(), 3, 0, this.getStackTraceString(t));
    }

    public final int d(Object format, Object ... args) {
        String s = format.toString();
        String message = args.length > 0 ? String.format(s, args) : s;
        return printer.println(this.getSDKTag(), 3, 0, message);
    }

    public final int d(Throwable throwable, Object format, Object ... args) {
        String s = format.toString();
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + this.getStackTraceString(throwable);
        return printer.println(this.getSDKTag(), 3, 0, message);
    }

    public final int i(Throwable t) {
        return printer.println(this.getSDKTag(), 4, 0, this.getStackTraceString(t));
    }

    public final int i(Object format, Object ... args) {
        String s = format.toString();
        String message = args.length > 0 ? String.format(s, args) : s;
        return printer.println(this.getSDKTag(), 4, 0, message);
    }

    public final int i(Throwable throwable, Object format, Object ... args) {
        String s = format.toString();
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + this.getStackTraceString(throwable);
        return printer.println(this.getSDKTag(), 4, 0, message);
    }

    public final int w(Throwable t) {
        return printer.println(this.getSDKTag(), 5, 0, this.getStackTraceString(t));
    }

    public final int w(Object format, Object ... args) {
        String s = format.toString();
        String message = args.length > 0 ? String.format(s, args) : s;
        return printer.println(this.getSDKTag(), 5, 0, message);
    }

    public final int w(Throwable throwable, Object format, Object ... args) {
        String s = format.toString();
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + this.getStackTraceString(throwable);
        return printer.println(this.getSDKTag(), 5, 0, message);
    }

    public final int e(Throwable t) {
        return printer.println(this.getSDKTag(), 6, 0, this.getStackTraceString(t));
    }

    public final int e(Object format, Object ... args) {
        String s = format.toString();
        String message = args.length > 0 ? String.format(s, args) : s;
        return printer.println(this.getSDKTag(), 6, 0, message);
    }

    public final int e(Throwable throwable, Object format, Object ... args) {
        String s = format.toString();
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + this.getStackTraceString(throwable);
        return printer.println(this.getSDKTag(), 6, 0, message);
    }

    public final int crash(Throwable t) {
        return printer.println(this.getSDKTag(), 6, 1, this.getStackTraceString(t));
    }

    public final void nativeCrashLog(String log) {
        printer.nativeCrashLog(this.getSDKTag(), log);
    }

    private final String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        return sw.toString();
    }

    static {
        loggers = new HashMap();
        printer = new LogPrinter();
        MobUncaughtExceptionHandler.register();
    }
}

