/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.log;

import android.content.Context;
import com.mob.tools.MobLog;
import com.mob.tools.utils.ResHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;

public class NativeErrorHandler {
    private static final int MAX_LOG_SIZE = 100;
    private static final boolean ENABLE;

    public static boolean prepare(Context context) {
        if (ENABLE) {
            String path = NativeErrorHandler.getCachePath(context);
            NativeErrorHandler.uploadCreashLog(path);
            NativeErrorHandler.nativePrepare(path);
        }
        return ENABLE;
    }

    private static String getCachePath(Context context) {
        File file = new File(ResHelper.getCacheRoot(context), "NativeCrashLogs");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    private static native void nativePrepare(String var0);

    private static void uploadCreashLog(String path) {
        try {
            ArrayList<NativeCrashInfo> index = NativeErrorHandler.parseIndex(path);
            for (NativeCrashInfo info : index) {
                String logList = NativeErrorHandler.parseLog(path, info);
                MobLog.getInstance().nativeCrashLog(logList);
            }
            ResHelper.deleteFileAndFolder(new File(path));
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
    }

    private static ArrayList<NativeCrashInfo> parseIndex(String path) throws Throwable {
        File indexFile = new File(path, ".ncl");
        if (!indexFile.exists()) {
            return new ArrayList<NativeCrashInfo>();
        }
        FileInputStream fis = new FileInputStream(indexFile);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader br = new BufferedReader(isr);
        ArrayList<NativeCrashInfo> infos = new ArrayList<NativeCrashInfo>();
        String line = br.readLine();
        while (line != null) {
            String[] i = line.split(",");
            if (i.length < 2) continue;
            NativeCrashInfo info = new NativeCrashInfo();
            info.time = ResHelper.parseLong(i[0]);
            info.signal = ResHelper.parseInt(i[1]);
            infos.add(info);
            line = br.readLine();
        }
        br.close();
        return infos;
    }

    private static String parseLog(String path, NativeCrashInfo info) throws Throwable {
        File logFile = new File(path, "." + info.time);
        if (!logFile.exists()) {
            return "";
        }
        FileInputStream fis = new FileInputStream(logFile);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader br = new BufferedReader(isr);
        LinkedList<String> logs = new LinkedList<String>();
        String line = br.readLine();
        while (line != null) {
            logs.add(line);
            if (logs.size() > 100) {
                logs.remove(0);
            }
            line = br.readLine();
        }
        br.close();
        StringBuffer sb = new StringBuffer();
        for (String log : logs) {
            sb.append(log).append('\n');
        }
        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    static {
        boolean loaded = false;
        try {
            System.loadLibrary("neh");
            loaded = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ENABLE = loaded;
    }

    private static class NativeCrashInfo {
        public long time;
        public int signal;

        private NativeCrashInfo() {
        }
    }
}

