/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.text.TextUtils;
import android.util.Base64;
import com.mob.tools.MobLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public class LocalDB {
    private File dbFile;
    private HashMap<String, Object> map;

    public void open(String filePath) {
        try {
            if (TextUtils.isEmpty((CharSequence)filePath)) {
                return;
            }
            this.dbFile = new File(filePath);
            if (!this.dbFile.exists()) {
                return;
            }
            FileInputStream fis = new FileInputStream(this.dbFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.map = (HashMap)ois.readObject();
            ois.close();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit() {
        if (this.map == null) {
            return;
        }
        if (this.dbFile == null) {
            return;
        }
        try {
            if (!this.dbFile.getParentFile().exists()) {
                this.dbFile.getParentFile().mkdirs();
            }
            HashMap<String, Object> hashMap = this.map;
            synchronized (hashMap) {
                FileOutputStream fos = new FileOutputStream(this.dbFile);
                if (fos.getChannel().tryLock() != null) {
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    oos.writeObject(this.map);
                    oos.flush();
                    oos.close();
                } else {
                    fos.close();
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
    }

    private void put(String key, Object value) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(key, value);
    }

    private Object get(String key) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(key);
    }

    public void putString(String key, String value) {
        this.put(key, value);
        this.commit();
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return String.valueOf(value);
    }

    public void putBoolean(String key, Boolean value) {
        this.put(key, value);
        this.commit();
    }

    public boolean getBoolean(String key) {
        Object value = this.get(key);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public void putLong(String key, Long value) {
        this.put(key, value);
        this.commit();
    }

    public long getLong(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return 0L;
    }

    public void putInt(String key, Integer value) {
        this.put(key, value);
        this.commit();
    }

    public int getInt(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    public void putFloat(String key, Float value) {
        this.put(key, value);
        this.commit();
    }

    public float getFloat(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Integer) {
            return ((Float)value).floatValue();
        }
        return 0.0f;
    }

    public void remove(String key) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.remove(key);
        this.commit();
    }

    public void putObject(String key, Object value) {
        try {
            if (value == null) {
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            oos.flush();
            oos.close();
            byte[] data = baos.toByteArray();
            String base64 = Base64.encodeToString((byte[])data, (int)2);
            this.putString(key, base64);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
    }

    public Object getObject(String key) {
        try {
            String base64 = this.getString(key);
            if (TextUtils.isEmpty((CharSequence)base64)) {
                return null;
            }
            byte[] data = Base64.decode((String)base64, (int)2);
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object value = ois.readObject();
            ois.close();
            return value;
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return null;
        }
    }
}

