/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.unity3d;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import cn.sharesdk.framework.Platform;
import cn.sharesdk.framework.PlatformActionListener;
import cn.sharesdk.framework.ShareSDK;
import cn.sharesdk.onekeyshare.OnekeyShare;
import cn.sharesdk.onekeyshare.ShareContentCustomizeCallback;
import cn.sharesdk.unity3d.Unity3dPlatformActionListener;
import com.mob.tools.utils.Hashon;
import com.mob.tools.utils.UIHandler;
import com.unity3d.player.UnityPlayer;
import java.util.HashMap;
import java.util.Map;

public class ShareSDKUtils
implements Handler.Callback {
    private static boolean DEBUG = true;
    private static boolean disableSSO = false;
    private static final int MSG_INITSDK = 1;
    private static final int MSG_AUTHORIZE = 2;
    private static final int MSG_SHOW_USER = 3;
    private static final int MSG_SHARE = 4;
    private static final int MSG_ONEKEY_SAHRE = 5;
    private static final int MSG_GET_FRIENDLIST = 6;
    private static final int MSG_FOLLOW_FRIEND = 7;
    private static Context context;
    private static String u3dGameObject;
    private static String u3dCallback;

    public ShareSDKUtils(String gameObject, String callback) {
        if (DEBUG) {
            System.out.println("ShareSDKUtils.prepare");
        }
        if (context == null) {
            context = UnityPlayer.currentActivity.getApplicationContext();
        }
        if (!TextUtils.isEmpty((CharSequence)gameObject)) {
            u3dGameObject = gameObject;
        }
        if (!TextUtils.isEmpty((CharSequence)callback)) {
            u3dCallback = callback;
        }
    }

    public void initSDK(String appKey) {
        if (DEBUG) {
            System.out.println("initSDK appkey ==>>" + appKey);
        }
        if (!TextUtils.isEmpty((CharSequence)appKey)) {
            ShareSDK.initSDK((Context)context, (String)appKey);
        } else {
            ShareSDK.initSDK((Context)context);
        }
    }

    public void setPlatformConfig(String configs) {
        if (DEBUG) {
            System.out.println("initSDK configs ==>>" + configs);
        }
        if (!TextUtils.isEmpty((CharSequence)configs)) {
            Message msg = new Message();
            msg.what = 1;
            msg.obj = configs;
            UIHandler.sendMessageDelayed((Message)msg, (long)1000L, (Handler.Callback)this);
        }
    }

    public void authorize(int reqID, int platform) {
        if (DEBUG) {
            System.out.println("ShareSDKUtils.authorize");
        }
        Message msg = new Message();
        msg.what = 2;
        msg.arg1 = platform;
        msg.arg2 = reqID;
        UIHandler.sendMessage((Message)msg, (Handler.Callback)this);
    }

    public void removeAccount(int platform) {
        if (DEBUG) {
            System.out.println("ShareSDKUtils.removeAccount");
        }
        String name = ShareSDK.platformIdToName((int)platform);
        Platform plat = ShareSDK.getPlatform((Context)context, (String)name);
        plat.removeAccount(true);
    }

    public boolean isAuthValid(int platform) {
        if (DEBUG) {
            System.out.println("ShareSDKUtils.isAuthValid");
        }
        String name = ShareSDK.platformIdToName((int)platform);
        Platform plat = ShareSDK.getPlatform((Context)context, (String)name);
        return plat.isAuthValid();
    }

    public boolean isClientValid(int platform) {
        if (DEBUG) {
            System.out.println("ShareSDKUtils.isClientValid");
        }
        String name = ShareSDK.platformIdToName((int)platform);
        Platform plat = ShareSDK.getPlatform((Context)context, (String)name);
        return plat.isClientValid();
    }

    public void showUser(int reqID, int platform) {
        if (DEBUG) {
            System.out.println("ShareSDKUtils.showUser");
        }
        Message msg = new Message();
        msg.what = 3;
        msg.arg1 = platform;
        msg.arg2 = reqID;
        UIHandler.sendMessage((Message)msg, (Handler.Callback)this);
    }

    public void shareContent(int reqID, int platform, String content) {
        if (DEBUG) {
            System.out.println("ShareSDKUtils.share");
        }
        Message msg = new Message();
        msg.what = 4;
        msg.arg1 = platform;
        msg.obj = content;
        msg.arg2 = reqID;
        UIHandler.sendMessage((Message)msg, (Handler.Callback)this);
    }

    public void onekeyShare(int reqID, int platform, String content) {
        if (DEBUG) {
            System.out.println("ShareSDKUtils.OnekeyShare");
        }
        Message msg = new Message();
        msg.what = 5;
        msg.arg1 = platform;
        msg.obj = content;
        msg.arg2 = reqID;
        UIHandler.sendMessage((Message)msg, (Handler.Callback)this);
    }

    public void getFriendList(int reqID, int platform, int count, int page) {
        if (DEBUG) {
            System.out.println("ShareSDKUtils.getFriendList");
        }
        Message msg = new Message();
        msg.what = 6;
        msg.arg1 = platform;
        msg.arg2 = reqID;
        Bundle data = new Bundle();
        data.putInt("page", page);
        data.putInt("count", count);
        msg.setData(data);
        UIHandler.sendMessage((Message)msg, (Handler.Callback)this);
    }

    public void followFriend(int reqID, int platform, String account) {
        if (DEBUG) {
            System.out.println("ShareSDKUtils.followFriend");
        }
        Message msg = new Message();
        msg.what = 7;
        msg.arg1 = platform;
        msg.obj = account;
        msg.arg2 = reqID;
        UIHandler.sendMessage((Message)msg, (Handler.Callback)this);
    }

    public String getAuthInfo(int platform) {
        if (DEBUG) {
            System.out.println("ShareSDKUtils.getAuthInfo");
        }
        String name = ShareSDK.platformIdToName((int)platform);
        Platform plat = ShareSDK.getPlatform((Context)context, (String)name);
        Hashon hashon = new Hashon();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (plat.isValid()) {
            map.put("expiresIn", plat.getDb().getExpiresIn());
            map.put("expiresTime", plat.getDb().getExpiresTime());
            map.put("token", plat.getDb().getToken());
            map.put("tokenSecret", plat.getDb().getTokenSecret());
            map.put("userGender", plat.getDb().getUserGender());
            map.put("userID", plat.getDb().getUserId());
            map.put("openID", plat.getDb().get("openid"));
            map.put("unionID", plat.getDb().get("unionid"));
            map.put("userName", plat.getDb().getUserName());
            map.put("userIcon", plat.getDb().getUserIcon());
        }
        return hashon.fromHashMap(map);
    }

    public void disableSSOWhenAuthorize(boolean open) {
        disableSSO = open;
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                if (DEBUG) {
                    System.out.println("ShareSDKUtils.setPlatformConfig");
                }
                String configs = (String)msg.obj;
                Hashon hashon = new Hashon();
                HashMap devInfo = hashon.fromJson(configs);
                for (Map.Entry entry : devInfo.entrySet()) {
                    String p = ShareSDK.platformIdToName((int)Integer.parseInt((String)entry.getKey()));
                    if (p == null) continue;
                    if (DEBUG) {
                        System.out.println(String.valueOf(p) + " ==>>" + new Hashon().fromHashMap((HashMap)entry.getValue()));
                    }
                    ShareSDK.setPlatformDevInfo((String)p, (HashMap)((HashMap)entry.getValue()));
                }
                break;
            }
            case 2: {
                int platform = msg.arg1;
                Unity3dPlatformActionListener paListener = new Unity3dPlatformActionListener(u3dGameObject, u3dCallback);
                paListener.setReqID(msg.arg2);
                String name = ShareSDK.platformIdToName((int)platform);
                Platform plat = ShareSDK.getPlatform((Context)context, (String)name);
                plat.setPlatformActionListener((PlatformActionListener)paListener);
                plat.SSOSetting(disableSSO);
                plat.authorize();
                break;
            }
            case 3: {
                int platform = msg.arg1;
                Unity3dPlatformActionListener paListener = new Unity3dPlatformActionListener(u3dGameObject, u3dCallback);
                paListener.setReqID(msg.arg2);
                String name = ShareSDK.platformIdToName((int)platform);
                Platform plat = ShareSDK.getPlatform((Context)context, (String)name);
                plat.setPlatformActionListener((PlatformActionListener)paListener);
                plat.SSOSetting(disableSSO);
                plat.showUser(null);
                break;
            }
            case 4: {
                int platformID = msg.arg1;
                Unity3dPlatformActionListener paListener = new Unity3dPlatformActionListener(u3dGameObject, u3dCallback);
                paListener.setReqID(msg.arg2);
                String content = (String)msg.obj;
                String pName = ShareSDK.platformIdToName((int)platformID);
                Platform plat = ShareSDK.getPlatform((Context)context, (String)pName);
                plat.setPlatformActionListener((PlatformActionListener)paListener);
                plat.SSOSetting(disableSSO);
                try {
                    String pID;
                    HashMap customizeSP;
                    Hashon hashon = new Hashon();
                    if (DEBUG) {
                        System.out.println("share content ==>>" + content);
                    }
                    HashMap data = hashon.fromJson(content);
                    Platform.ShareParams sp = new Platform.ShareParams(data);
                    if (data.containsKey("customizeShareParams") && (customizeSP = (HashMap)data.get("customizeShareParams")).size() > 0 && customizeSP.containsKey(pID = String.valueOf(platformID))) {
                        String cSP = (String)customizeSP.get(pID);
                        if (DEBUG) {
                            System.out.println("share content ==>>" + cSP);
                        }
                        data = hashon.fromJson(cSP);
                        for (String key : data.keySet()) {
                            sp.set(key, data.get(key));
                        }
                    }
                    plat.share(sp);
                }
                catch (Throwable t) {
                    paListener.onError(plat, 9, t);
                }
                break;
            }
            case 5: {
                HashMap customizeSP;
                int platform = msg.arg1;
                Unity3dPlatformActionListener paListener = new Unity3dPlatformActionListener(u3dGameObject, u3dCallback);
                paListener.setReqID(msg.arg2);
                String content = (String)msg.obj;
                Hashon hashon = new Hashon();
                if (DEBUG) {
                    System.out.println("onekeyshare  ==>>" + content);
                }
                HashMap map = hashon.fromJson(content);
                OnekeyShare oks = new OnekeyShare();
                if (platform > 0) {
                    String name = ShareSDK.platformIdToName((int)platform);
                    if (DEBUG) {
                        System.out.println("ShareSDKUtils Onekeyshare shareView platform name ==>> " + name);
                    }
                    if (!TextUtils.isEmpty((CharSequence)name)) {
                        oks.setPlatform(name);
                        oks.setSilent(false);
                    }
                }
                if (map.containsKey("text")) {
                    oks.setText((String)map.get("text"));
                }
                if (map.containsKey("imagePath")) {
                    oks.setImagePath((String)map.get("imagePath"));
                }
                if (map.containsKey("imageUrl")) {
                    oks.setImageUrl((String)map.get("imageUrl"));
                }
                if (map.containsKey("title")) {
                    oks.setTitle((String)map.get("title"));
                }
                if (map.containsKey("comment")) {
                    oks.setComment((String)map.get("comment"));
                }
                if (map.containsKey("url")) {
                    oks.setUrl((String)map.get("url"));
                    oks.setTitleUrl((String)map.get("url"));
                }
                if (map.containsKey("site")) {
                    oks.setSite((String)map.get("site"));
                }
                if (map.containsKey("siteUrl")) {
                    oks.setSiteUrl((String)map.get("siteUrl"));
                }
                if (map.containsKey("musicUrl")) {
                    oks.setSiteUrl((String)map.get("musicUrl"));
                }
                if (map.containsKey("shareType") && "6".equals(String.valueOf(map.get("shareType"))) && map.containsKey("url")) {
                    oks.setVideoUrl((String)map.get("url"));
                }
                if (map.containsKey("customizeShareParams") && (customizeSP = (HashMap)map.get("customizeShareParams")).size() > 0) {
                    oks.setShareContentCustomizeCallback(new ShareContentCustomizeCallback(){

                        public void onShare(Platform platform, Platform.ShareParams paramsToShare) {
                            String platformID = String.valueOf(ShareSDK.platformNameToId((String)platform.getName()));
                            if (customizeSP.containsKey(platformID)) {
                                Hashon hashon = new Hashon();
                                String content = (String)customizeSP.get(platformID);
                                if (DEBUG) {
                                    System.out.println("share content ==>>" + content);
                                }
                                HashMap data = hashon.fromJson(content);
                                for (String key : data.keySet()) {
                                    paramsToShare.set(key, data.get(key));
                                }
                            }
                        }
                    });
                }
                if (disableSSO) {
                    oks.disableSSOWhenAuthorize();
                }
                oks.setCallback((PlatformActionListener)paListener);
                oks.show(context);
                break;
            }
            case 6: {
                int platform = msg.arg1;
                Unity3dPlatformActionListener paListener = new Unity3dPlatformActionListener(u3dGameObject, u3dCallback);
                paListener.setReqID(msg.arg2);
                int page = msg.getData().getInt("page");
                int count = msg.getData().getInt("count");
                String name = ShareSDK.platformIdToName((int)platform);
                Platform plat = ShareSDK.getPlatform((Context)context, (String)name);
                plat.setPlatformActionListener((PlatformActionListener)paListener);
                plat.SSOSetting(disableSSO);
                plat.listFriend(count, page, null);
                break;
            }
            case 7: {
                int platform = msg.arg1;
                Unity3dPlatformActionListener paListener = new Unity3dPlatformActionListener(u3dGameObject, u3dCallback);
                paListener.setReqID(msg.arg2);
                String account = (String)msg.obj;
                String name = ShareSDK.platformIdToName((int)platform);
                Platform plat = ShareSDK.getPlatform((Context)context, (String)name);
                plat.setPlatformActionListener((PlatformActionListener)paListener);
                plat.SSOSetting(disableSSO);
                plat.followFriend(account);
            }
        }
        return false;
    }
}

