/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.unity3d;

import cn.sharesdk.framework.Platform;
import cn.sharesdk.framework.PlatformActionListener;
import cn.sharesdk.framework.ShareSDK;
import com.mob.tools.utils.Hashon;
import com.unity3d.player.UnityPlayer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class Unity3dPlatformActionListener
implements PlatformActionListener {
    private int reqID;
    private String u3dCallback;
    private String u3dGameObject;

    public Unity3dPlatformActionListener(String u3dGameObject, String u3dCallback) {
        this.u3dGameObject = u3dGameObject;
        this.u3dCallback = u3dCallback;
    }

    public void setReqID(int reqID) {
        this.reqID = reqID;
    }

    public void onError(Platform platform, int action, Throwable t) {
        String resp = this.javaActionResToCS(platform, action, t);
        UnityPlayer.UnitySendMessage((String)this.u3dGameObject, (String)this.u3dCallback, (String)resp);
    }

    public void onComplete(Platform platform, int action, HashMap<String, Object> res) {
        String resp = this.javaActionResToCS(platform, action, res);
        UnityPlayer.UnitySendMessage((String)this.u3dGameObject, (String)this.u3dCallback, (String)resp);
    }

    public void onCancel(Platform platform, int action) {
        String resp = this.javaActionResToCS(platform, action);
        UnityPlayer.UnitySendMessage((String)this.u3dGameObject, (String)this.u3dCallback, (String)resp);
    }

    private String javaActionResToCS(Platform platform, int action, Throwable t) {
        int platformId = ShareSDK.platformNameToId((String)platform.getName());
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("reqID", Integer.valueOf(this.reqID));
        map.put("platform", Integer.valueOf(platformId));
        map.put("action", Integer.valueOf(action));
        map.put("status", Integer.valueOf(2));
        map.put("res", this.throwableToMap(t));
        Hashon hashon = new Hashon();
        return hashon.fromHashMap(map);
    }

    private String javaActionResToCS(Platform platform, int action, HashMap<String, Object> res) {
        int platformId = ShareSDK.platformNameToId((String)platform.getName());
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("reqID", Integer.valueOf(this.reqID));
        map.put("platform", Integer.valueOf(platformId));
        map.put("action", Integer.valueOf(action));
        map.put("status", Integer.valueOf(1));
        map.put("res", res);
        Hashon hashon = new Hashon();
        return hashon.fromHashMap(map);
    }

    private String javaActionResToCS(Platform platform, int action) {
        int platformId = ShareSDK.platformNameToId((String)platform.getName());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("reqID", this.reqID);
        map.put("platform", platformId);
        map.put("action", action);
        map.put("status", 3);
        Hashon hashon = new Hashon();
        return hashon.fromHashMap(map);
    }

    private HashMap<String, Object> throwableToMap(Throwable t) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("msg", t.getMessage());
        ArrayList traces = new ArrayList();
        StackTraceElement[] stackTraceElementArray = t.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement trace = stackTraceElementArray[n2];
            HashMap<String, Object> element = new HashMap<String, Object>();
            element.put("cls", trace.getClassName());
            element.put("method", trace.getMethodName());
            element.put("file", trace.getFileName());
            element.put("line", trace.getLineNumber());
            traces.add(element);
            ++n2;
        }
        map.put("stack", traces);
        Throwable cause = t.getCause();
        if (cause != null) {
            map.put("cause", this.throwableToMap(cause));
        }
        return map;
    }
}

