/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.onekeyshare.themes.classic;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import cn.sharesdk.framework.Platform;
import cn.sharesdk.framework.PlatformActionListener;
import cn.sharesdk.onekeyshare.themes.classic.FriendListItem;
import cn.sharesdk.onekeyshare.themes.classic.FriendListPage;
import cn.sharesdk.onekeyshare.themes.classic.PRTHeader;
import com.mob.tools.gui.PullToRequestListAdapter;
import com.mob.tools.gui.PullToRequestView;
import com.mob.tools.utils.UIHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class FriendAdapter
extends PullToRequestListAdapter
implements PlatformActionListener {
    private FriendListPage activity;
    private boolean hasNext;
    private Platform platform;
    private final int pageCount = 15;
    private int curPage;
    private ArrayList<Following> follows;
    private HashMap<String, Boolean> map;
    private PRTHeader llHeader;
    private float ratio;

    public FriendAdapter(FriendListPage activity, PullToRequestView view) {
        super(view);
        this.activity = activity;
        this.curPage = -1;
        this.hasNext = true;
        this.map = new HashMap();
        this.follows = new ArrayList();
        this.getListView().setDivider((Drawable)new ColorDrawable(-1381654));
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
        this.getListView().setDividerHeight((int)(ratio < 1.0f ? 1.0f : ratio));
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.getListView().setOnItemClickListener(listener);
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
        platform.setPlatformActionListener((PlatformActionListener)this);
    }

    private void next() {
        if (this.hasNext) {
            this.platform.listFriend(15, this.curPage + 1, null);
        }
    }

    public void onComplete(Platform plat, int action, HashMap<String, Object> res) {
        final FollowersResult followersResult = this.parseFollowers(this.platform.getName(), res, this.map);
        if (followersResult == null) {
            UIHandler.sendEmptyMessage((int)0, (Handler.Callback)new Handler.Callback(){

                public boolean handleMessage(Message msg) {
                    FriendAdapter.this.notifyDataSetChanged();
                    return false;
                }
            });
            return;
        }
        this.hasNext = followersResult.hasNextPage;
        if (followersResult.list != null && followersResult.list.size() > 0) {
            ++this.curPage;
            Message msg = new Message();
            msg.what = 1;
            msg.obj = followersResult.list;
            UIHandler.sendMessage((Message)msg, (Handler.Callback)new Handler.Callback(){

                public boolean handleMessage(Message msg) {
                    if (FriendAdapter.this.curPage <= 0) {
                        FriendAdapter.this.follows.clear();
                    }
                    FriendAdapter.this.follows.addAll(followersResult.list);
                    FriendAdapter.this.notifyDataSetChanged();
                    return false;
                }
            });
        }
    }

    private FollowersResult parseFollowers(String platform, HashMap<String, Object> res, HashMap<String, Boolean> uidMap) {
        ArrayList users;
        if (res == null || res.size() <= 0) {
            return null;
        }
        boolean hasNext = false;
        ArrayList<Following> data = new ArrayList<Following>();
        if ("SinaWeibo".equals(platform)) {
            users = (ArrayList)res.get("users");
            for (HashMap user : users) {
                String uid = String.valueOf(user.get("id"));
                if (uidMap.containsKey(uid)) continue;
                Following following = new Following();
                following.uid = uid;
                following.screenName = String.valueOf(user.get("name"));
                following.description = String.valueOf(user.get("description"));
                following.icon = String.valueOf(user.get("profile_image_url"));
                following.atName = following.screenName;
                uidMap.put(following.uid, true);
                data.add(following);
            }
            hasNext = (Integer)res.get("total_number") > uidMap.size();
        } else if ("TencentWeibo".equals(platform)) {
            hasNext = (Integer)res.get("hasnext") == 0;
            ArrayList infos = (ArrayList)res.get("info");
            for (HashMap info : infos) {
                String uid = String.valueOf(info.get("name"));
                if (uidMap.containsKey(uid)) continue;
                Following following = new Following();
                following.screenName = String.valueOf(info.get("nick"));
                following.uid = uid;
                following.atName = uid;
                ArrayList tweets = (ArrayList)info.get("tweet");
                Iterator iterator = tweets.iterator();
                if (iterator.hasNext()) {
                    HashMap tweet = (HashMap)iterator.next();
                    following.description = String.valueOf(tweet.get("text"));
                }
                following.icon = String.valueOf(String.valueOf(info.get("head"))) + "/100";
                uidMap.put(following.uid, true);
                data.add(following);
            }
        } else if ("Facebook".equals(platform)) {
            ArrayList datas = (ArrayList)res.get("data");
            for (HashMap d : datas) {
                String uid = String.valueOf(d.get("id"));
                if (uidMap.containsKey(uid)) continue;
                Following following = new Following();
                following.uid = uid;
                following.atName = "[" + uid + "]";
                following.screenName = String.valueOf(d.get("name"));
                HashMap picture = (HashMap)d.get("picture");
                if (picture != null) {
                    HashMap pData = (HashMap)picture.get("data");
                    following.icon = String.valueOf(pData.get("url"));
                }
                uidMap.put(following.uid, true);
                data.add(following);
            }
            HashMap paging = (HashMap)res.get("paging");
            hasNext = paging.containsKey("next");
        } else if ("Twitter".equals(platform)) {
            users = (ArrayList)res.get("users");
            for (HashMap user : users) {
                String uid = String.valueOf(user.get("screen_name"));
                if (uidMap.containsKey(uid)) continue;
                Following following = new Following();
                following.uid = uid;
                following.atName = uid;
                following.screenName = String.valueOf(user.get("name"));
                following.description = String.valueOf(user.get("description"));
                following.icon = String.valueOf(user.get("profile_image_url"));
                uidMap.put(following.uid, true);
                data.add(following);
            }
        }
        FollowersResult ret = new FollowersResult();
        ret.list = data;
        ret.hasNextPage = hasNext;
        return ret;
    }

    public void onError(Platform plat, int action, Throwable t) {
        t.printStackTrace();
    }

    public void onCancel(Platform plat, int action) {
        UIHandler.sendEmptyMessage((int)0, (Handler.Callback)new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                FriendAdapter.this.activity.finish();
                return false;
            }
        });
    }

    public Following getItem(int position) {
        return this.follows.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getCount() {
        return this.follows == null ? 0 : this.follows.size();
    }

    public View getHeaderView() {
        if (this.llHeader == null) {
            this.llHeader = new PRTHeader(this.getContext());
        }
        return this.llHeader;
    }

    public void onPullDown(int percent) {
        this.llHeader.onPullDown(percent);
    }

    public void onRefresh() {
        this.llHeader.onRequest();
        this.curPage = -1;
        this.hasNext = true;
        this.map.clear();
        this.next();
    }

    public void onReversed() {
        this.llHeader.reverse();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        FriendListItem llItem;
        if (convertView == null) {
            llItem = new FriendListItem(parent.getContext(), this.ratio);
            convertView = llItem;
        }
        llItem = (FriendListItem)((Object)convertView);
        llItem.update(this.getItem(position), this.isFling());
        if (position == this.getCount() - 1) {
            this.next();
        }
        return convertView;
    }

    public View getFooterView() {
        LinearLayout footerView = new LinearLayout(this.getContext());
        footerView.setMinimumHeight(10);
        return footerView;
    }

    private static class FollowersResult {
        public ArrayList<Following> list;
        public boolean hasNextPage = false;

        private FollowersResult() {
        }
    }

    public static class Following {
        public boolean checked;
        public String screenName;
        public String description;
        public String uid;
        public String icon;
        public String atName;
    }
}

