/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.onekeyshare.themes.classic;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.sharesdk.framework.Platform;
import cn.sharesdk.onekeyshare.OnekeySharePage;
import cn.sharesdk.onekeyshare.OnekeyShareThemeImpl;
import cn.sharesdk.onekeyshare.themes.classic.FriendAdapter;
import com.mob.tools.gui.PullToRequestAdatper;
import com.mob.tools.gui.PullToRequestView;
import com.mob.tools.utils.R;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class FriendListPage
extends OnekeySharePage
implements View.OnClickListener,
AdapterView.OnItemClickListener {
    private static final int DESIGN_LEFT_PADDING = 40;
    private Platform platform;
    private LinearLayout llPage;
    private RelativeLayout rlTitle;
    private TextView tvCancel;
    private TextView tvConfirm;
    private FriendAdapter adapter;
    private int lastPosition = -1;
    private int checkNum = 0;

    public FriendListPage(OnekeyShareThemeImpl impl) {
        super(impl);
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public void onCreate() {
        this.activity.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(-789517));
        this.llPage = new LinearLayout((Context)this.activity);
        this.llPage.setOrientation(1);
        this.activity.setContentView((View)this.llPage);
        this.rlTitle = new RelativeLayout((Context)this.activity);
        float ratio = this.getRatio();
        int titleHeight = (int)((float)this.getDesignTitleHeight() * ratio);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, titleHeight);
        this.llPage.addView((View)this.rlTitle, (ViewGroup.LayoutParams)lp);
        this.initTitle(this.rlTitle, ratio);
        View line = new View((Context)this.activity);
        LinearLayout.LayoutParams lpline = new LinearLayout.LayoutParams(-1, (int)(ratio < 1.0f ? 1.0f : ratio));
        line.setBackgroundColor(-2434599);
        this.llPage.addView(line, (ViewGroup.LayoutParams)lpline);
        FrameLayout flPage = new FrameLayout(this.getContext());
        LinearLayout.LayoutParams lpFl = new LinearLayout.LayoutParams(-1, -2);
        lpFl.weight = 1.0f;
        flPage.setLayoutParams((ViewGroup.LayoutParams)lpFl);
        this.llPage.addView((View)flPage);
        PullToRequestView followList = new PullToRequestView(this.getContext());
        FrameLayout.LayoutParams lpLv = new FrameLayout.LayoutParams(-1, -1);
        followList.setLayoutParams((ViewGroup.LayoutParams)lpLv);
        flPage.addView((View)followList);
        this.adapter = new FriendAdapter(this, followList);
        this.adapter.setPlatform(this.platform);
        this.adapter.setRatio(ratio);
        this.adapter.setOnItemClickListener(this);
        followList.setAdapter((PullToRequestAdatper)this.adapter);
        followList.performPullingDown(true);
    }

    protected abstract float getRatio();

    protected abstract int getDesignTitleHeight();

    private void initTitle(RelativeLayout rlTitle, float ratio) {
        this.tvCancel = new TextView((Context)this.activity);
        this.tvCancel.setTextColor(-12895429);
        this.tvCancel.setTextSize(2, 18.0f);
        this.tvCancel.setGravity(17);
        int resId = R.getStringRes((Context)this.activity, (String)"ssdk_oks_cancel");
        if (resId > 0) {
            this.tvCancel.setText(resId);
        }
        int padding = (int)(40.0f * ratio);
        this.tvCancel.setPadding(padding, 0, padding, 0);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -1);
        rlTitle.addView((View)this.tvCancel, (ViewGroup.LayoutParams)lp);
        this.tvCancel.setOnClickListener((View.OnClickListener)this);
        TextView tvTitle = new TextView((Context)this.activity);
        tvTitle.setTextColor(-12895429);
        tvTitle.setTextSize(2, 22.0f);
        tvTitle.setGravity(17);
        resId = R.getStringRes((Context)this.activity, (String)"ssdk_oks_contacts");
        if (resId > 0) {
            tvTitle.setText(resId);
        }
        lp = new RelativeLayout.LayoutParams(-2, -1);
        lp.addRule(13);
        rlTitle.addView((View)tvTitle, (ViewGroup.LayoutParams)lp);
        this.tvConfirm = new TextView((Context)this.activity);
        this.tvConfirm.setTextColor(-37615);
        this.tvConfirm.setTextSize(2, 18.0f);
        this.tvConfirm.setGravity(17);
        resId = R.getStringRes((Context)this.activity, (String)"ssdk_oks_confirm");
        if (resId > 0) {
            this.tvConfirm.setText(resId);
        }
        this.tvConfirm.setPadding(padding, 0, padding, 0);
        lp = new RelativeLayout.LayoutParams(-2, -1);
        lp.addRule(11);
        rlTitle.addView((View)this.tvConfirm, (ViewGroup.LayoutParams)lp);
        this.tvConfirm.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        if (v.equals(this.tvCancel)) {
            this.finish();
        } else {
            ArrayList<String> selected = new ArrayList<String>();
            int i = 0;
            int size = this.adapter.getCount();
            while (i < size) {
                if (this.adapter.getItem((int)i).checked) {
                    selected.add(this.adapter.getItem((int)i).atName);
                }
                ++i;
            }
            HashMap<String, ArrayList<String>> res = new HashMap<String, ArrayList<String>>();
            res.put("selected", selected);
            res.put("platform", (ArrayList<String>)this.platform);
            this.setResult(res);
            this.finish();
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        if ("FacebookMessenger".equals(this.platform.getName())) {
            if (this.lastPosition >= 0) {
                FriendAdapter.Following lastFollwing = this.adapter.getItem(this.lastPosition);
                lastFollwing.checked = false;
            }
            this.lastPosition = position;
        }
        FriendAdapter.Following following = this.adapter.getItem(position);
        boolean bl = following.checked = !following.checked;
        this.checkNum = following.checked ? ++this.checkNum : --this.checkNum;
        this.updateConfirmView();
        this.adapter.notifyDataSetChanged();
    }

    private void updateConfirmView() {
        int resId = R.getStringRes((Context)this.activity, (String)"ssdk_oks_confirm");
        String confirm = "Confirm";
        if (resId > 0) {
            confirm = this.getContext().getResources().getString(resId);
        }
        if (this.checkNum == 0) {
            this.tvConfirm.setText((CharSequence)confirm);
        } else if (this.checkNum > 0) {
            this.tvConfirm.setText((CharSequence)(String.valueOf(confirm) + "(" + this.checkNum + ")"));
        }
    }
}

