/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.onekeyshare.themes.classic.port;

import android.content.Context;
import cn.sharesdk.onekeyshare.themes.classic.PlatformPage;
import cn.sharesdk.onekeyshare.themes.classic.PlatformPageAdapter;
import com.mob.tools.utils.R;
import java.util.ArrayList;

public class PlatformPageAdapterPort
extends PlatformPageAdapter {
    private static final int DESIGN_SCREEN_WIDTH_P = 720;
    private static final int DESIGN_SEP_LINE_WIDTH = 1;
    private static final int DESIGN_LOGO_HEIGHT = 76;
    private static final int DESIGN_PADDING_TOP = 20;
    private static final int PAGE_SIZE_P = 12;
    private static final int LINE_SIZE_P = 4;

    public PlatformPageAdapterPort(PlatformPage page, ArrayList<Object> cells) {
        super(page, cells);
    }

    @Override
    protected void calculateSize(Context context, ArrayList<Object> plats) {
        int screenWidth = R.getScreenWidth((Context)context);
        this.lineSize = 4;
        float ratio = (float)screenWidth / 720.0f;
        this.sepLineWidth = (int)(1.0f * ratio);
        this.sepLineWidth = this.sepLineWidth < 1 ? 1 : this.sepLineWidth;
        this.logoHeight = (int)(76.0f * ratio);
        this.paddingTop = (int)(20.0f * ratio);
        this.bottomHeight = (int)(52.0f * ratio);
        this.cellHeight = (screenWidth - this.sepLineWidth * 3) / 4;
        this.panelHeight = plats.size() <= this.lineSize ? this.cellHeight + this.sepLineWidth : (plats.size() <= 12 - this.lineSize ? (this.cellHeight + this.sepLineWidth) * 2 : (this.cellHeight + this.sepLineWidth) * 3);
    }

    @Override
    protected void collectCells(ArrayList<Object> plats) {
        int count = plats.size();
        if (count < 12) {
            int lineCount = count / this.lineSize;
            if (count % this.lineSize != 0) {
                ++lineCount;
            }
            this.cells = new Object[1][lineCount * this.lineSize];
        } else {
            int pageCount = count / 12;
            if (count % 12 != 0) {
                ++pageCount;
            }
            this.cells = new Object[pageCount][12];
        }
        int i = 0;
        while (i < count) {
            int p = i / 12;
            this.cells[p][i - 12 * p] = plats.get(i);
            ++i;
        }
    }
}

