/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.onekeyshare.themes.classic;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import cn.sharesdk.onekeyshare.themes.classic.RotateImageView;
import com.mob.tools.utils.R;

public class PRTHeader
extends LinearLayout {
    private static final int DESIGN_SCREEN_WIDTH = 720;
    private static final int DESIGN_AVATAR_WIDTH = 64;
    private static final int DESIGN_AVATAR_PADDING = 24;
    private TextView tvHeader;
    private RotateImageView ivArrow;
    private ProgressBar pbRefreshing;

    public PRTHeader(Context context) {
        super(context);
        int avataPadding;
        int[] size = R.getScreenSize((Context)context);
        float screenWidth = size[0] < size[1] ? size[0] : size[1];
        float ratio = screenWidth / 720.0f;
        this.setOrientation(1);
        LinearLayout llInner = new LinearLayout(context);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
        lp.gravity = 1;
        this.addView((View)llInner, (ViewGroup.LayoutParams)lp);
        this.ivArrow = new RotateImageView(context);
        int resId = R.getBitmapRes((Context)context, (String)"ssdk_oks_ptr_ptr");
        if (resId > 0) {
            this.ivArrow.setImageResource(resId);
        }
        int avatarWidth = (int)(ratio * 64.0f);
        lp = new LinearLayout.LayoutParams(avatarWidth, avatarWidth);
        lp.gravity = 16;
        lp.topMargin = lp.bottomMargin = (avataPadding = (int)(ratio * 24.0f));
        llInner.addView((View)this.ivArrow, (ViewGroup.LayoutParams)lp);
        this.pbRefreshing = new ProgressBar(context);
        resId = R.getBitmapRes((Context)context, (String)"ssdk_oks_classic_progressbar");
        Drawable pbdrawable = context.getResources().getDrawable(resId);
        this.pbRefreshing.setIndeterminateDrawable(pbdrawable);
        llInner.addView((View)this.pbRefreshing, (ViewGroup.LayoutParams)lp);
        this.pbRefreshing.setVisibility(8);
        this.tvHeader = new TextView(this.getContext());
        this.tvHeader.setTextSize(2, 18.0f);
        this.tvHeader.setPadding(avataPadding, 0, avataPadding, 0);
        this.tvHeader.setTextColor(-16139513);
        lp = new LinearLayout.LayoutParams(-2, -2);
        lp.gravity = 16;
        llInner.addView((View)this.tvHeader, (ViewGroup.LayoutParams)lp);
    }

    public void onPullDown(int percent) {
        int resId;
        if (percent > 100) {
            int degree = (percent - 100) * 180 / 20;
            if (degree > 180) {
                degree = 180;
            }
            if (degree < 0) {
                degree = 0;
            }
            this.ivArrow.setRotation(degree);
        } else {
            this.ivArrow.setRotation(0.0f);
        }
        if (percent < 100) {
            resId = R.getStringRes((Context)this.getContext(), (String)"ssdk_oks_pull_to_refresh");
            if (resId > 0) {
                this.tvHeader.setText(resId);
            }
        } else {
            resId = R.getStringRes((Context)this.getContext(), (String)"ssdk_oks_release_to_refresh");
            if (resId > 0) {
                this.tvHeader.setText(resId);
            }
        }
    }

    public void onRequest() {
        this.ivArrow.setVisibility(8);
        this.pbRefreshing.setVisibility(0);
        int resId = R.getStringRes((Context)this.getContext(), (String)"ssdk_oks_refreshing");
        if (resId > 0) {
            this.tvHeader.setText(resId);
        }
    }

    public void reverse() {
        this.pbRefreshing.setVisibility(8);
        this.ivArrow.setRotation(180.0f);
        this.ivArrow.setVisibility(0);
    }
}

