/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import com.mob.tools.MobHandlerThread;
import com.mob.tools.MobLog;
import com.mob.tools.gui.CachePool;
import com.mob.tools.network.NetworkHelper;
import com.mob.tools.network.RawNetworkCallback;
import com.mob.tools.utils.BitmapHelper;
import com.mob.tools.utils.Data;
import com.mob.tools.utils.ResHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class BitmapProcessor {
    private static final int CAPACITY = 3;
    private static final int SCAN_INTERVAL = 20000;
    private static final int MAX_CACHE_TIME = 60000;
    private static final int MAX_REQ_TIME = 20000;
    private static final int MAX_SIZE = 100;
    private static final int OVERFLOW_SIZE = 120;
    private static final int MAX_CACHE_SIZE = 50;
    private static NetworkHelper.NetworkTimeOut timeout;
    private static CachePool<String, Bitmap> cachePool;
    private static ArrayList<ImageReq> reqList;
    private static WorkerThread[] workerList;
    private static ArrayList<ImageReq> netReqTPS;
    private static File cacheDir;
    private static boolean work;
    private static ManagerThread manager;

    public static synchronized void prepare(Context context) {
        cacheDir = new File(ResHelper.getImageCachePath(context));
    }

    public static synchronized void start() {
        if (!work) {
            work = true;
            manager = new ManagerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void stop() {
        if (work) {
            work = false;
            ArrayList<ImageReq> arrayList = reqList;
            synchronized (arrayList) {
                reqList.clear();
                cachePool.clear();
            }
            manager.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void process(String url, BitmapCallback callback) {
        if (url == null) {
            return;
        }
        ArrayList<ImageReq> arrayList = reqList;
        synchronized (arrayList) {
            int size = reqList.size();
            for (int i = 0; i < size; ++i) {
                ImageReq req = reqList.get(i);
                if (!req.url.equals(url)) continue;
                if (callback != null && req.callbacks.indexOf(callback) == -1) {
                    req.callbacks.add(callback);
                }
                BitmapProcessor.start();
                return;
            }
        }
        ImageReq req = new ImageReq();
        req.url = url;
        if (callback != null) {
            req.callbacks.add(callback);
        }
        ArrayList<ImageReq> arrayList2 = reqList;
        synchronized (arrayList2) {
            reqList.add(req);
            if (reqList.size() > 120) {
                while (reqList.size() > 100) {
                    reqList.remove(0);
                }
            }
        }
        BitmapProcessor.start();
    }

    public static Bitmap getBitmapFromCache(String url) {
        return cachePool != null ? null : cachePool.get(url);
    }

    static {
        NetworkHelper.NetworkTimeOut timeout = new NetworkHelper.NetworkTimeOut();
        timeout.connectionTimeout = 5000;
        timeout.readTimout = 20000 - timeout.connectionTimeout;
        reqList = new ArrayList();
        netReqTPS = new ArrayList();
        workerList = new WorkerThread[3];
        cachePool = new CachePool(50);
    }

    public static class ImageReq {
        private String url;
        private ArrayList<BitmapCallback> callbacks;
        private WorkerThread worker;
        private long reqTime = System.currentTimeMillis();
        private Bitmap image;

        public ImageReq() {
            this.callbacks = new ArrayList();
        }

        private void throwComplete(Bitmap bitmap) {
            this.image = bitmap;
            for (BitmapCallback cb : this.callbacks) {
                cb.onImageGot(this.url, this.image);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("url=").append(this.url);
            sb.append("time=").append(this.reqTime);
            sb.append("worker=").append(this.worker.getName()).append(" (").append(this.worker.getId()).append("");
            return sb.toString();
        }
    }

    public static interface BitmapCallback {
        public void onImageGot(String var1, Bitmap var2);
    }

    private static class PatchInputStream
    extends FilterInputStream {
        InputStream in;

        protected PatchInputStream(InputStream in) {
            super(in);
            this.in = in;
        }

        @Override
        public long skip(long n) throws IOException {
            long m;
            long mm;
            for (m = 0L; m < n && (mm = this.in.skip(n - m)) != 0L; m += mm) {
            }
            return m;
        }
    }

    private static class WorkerThread
    extends Thread {
        private boolean localType;
        private ImageReq curReq;

        private WorkerThread() {
        }

        @Override
        public void run() {
            while (work) {
                try {
                    if (this.localType) {
                        this.doLocalTask();
                        continue;
                    }
                    this.doNetworkTask();
                }
                catch (Throwable t) {
                    MobLog.getInstance().w(t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doLocalTask() throws Throwable {
            ImageReq req = null;
            ArrayList arrayList = reqList;
            synchronized (arrayList) {
                if (reqList.size() > 0) {
                    req = (ImageReq)reqList.remove(0);
                }
            }
            if (req != null) {
                Bitmap bm = (Bitmap)cachePool.get(req.url);
                if (bm != null) {
                    this.curReq = req;
                    this.curReq.worker = this;
                    req.throwComplete(bm);
                } else if (cacheDir != null && new File(cacheDir, Data.MD5(req.url)).exists()) {
                    this.doTask(req);
                } else {
                    ArrayList arrayList2 = reqList;
                    synchronized (arrayList2) {
                        if (netReqTPS.size() > 100) {
                            ArrayList arrayList3 = reqList;
                            synchronized (arrayList3) {
                                while (reqList.size() > 0) {
                                    reqList.remove(0);
                                }
                            }
                            netReqTPS.remove(0);
                        }
                    }
                    netReqTPS.add(req);
                }
            } else {
                try {
                    Thread.sleep(30L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doNetworkTask() throws Throwable {
            ImageReq req = null;
            ArrayList arrayList = netReqTPS;
            synchronized (arrayList) {
                if (netReqTPS.size() > 0) {
                    req = (ImageReq)netReqTPS.remove(0);
                }
            }
            if (req == null) {
                arrayList = reqList;
                synchronized (arrayList) {
                    if (reqList.size() > 0) {
                        req = (ImageReq)reqList.remove(0);
                    }
                }
            }
            if (req != null) {
                Bitmap bm = (Bitmap)cachePool.get(req.url);
                if (bm != null) {
                    this.curReq = req;
                    this.curReq.worker = this;
                    req.throwComplete(bm);
                } else {
                    this.doTask(req);
                }
            } else {
                try {
                    Thread.sleep(30L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private void doTask(final ImageReq req) throws Throwable {
            this.curReq = req;
            this.curReq.worker = this;
            Bitmap bm = null;
            final boolean saveAsPng = req.url.toLowerCase().endsWith("png") || req.url.toLowerCase().endsWith("gif");
            final String md5 = Data.MD5(req.url);
            if (cacheDir != null && new File(cacheDir, md5).exists()) {
                bm = BitmapHelper.getBitmap(new File(cacheDir, md5).getAbsolutePath());
                if (bm != null) {
                    cachePool.put(req.url, bm);
                    req.throwComplete(bm);
                }
                this.curReq = null;
            } else {
                NetworkHelper helper = new NetworkHelper();
                helper.rawGet(req.url, new RawNetworkCallback(){

                    @Override
                    public void onResponse(InputStream is) throws Throwable {
                        PatchInputStream pis = new PatchInputStream(is);
                        Bitmap bitmap = BitmapHelper.getBitmap(pis, 1);
                        if (bitmap == null || bitmap.isRecycled()) {
                            WorkerThread.this.curReq = null;
                            return;
                        }
                        if (bitmap != null) {
                            if (cacheDir != null) {
                                File file = new File(cacheDir, md5);
                                WorkerThread.this.saveFile(bitmap, file, saveAsPng);
                            }
                            cachePool.put(req.url, bitmap);
                            req.throwComplete(bitmap);
                        }
                        WorkerThread.this.curReq = null;
                    }
                }, timeout);
            }
            if (bm != null) {
                cachePool.put(req.url, bm);
                req.throwComplete(bm);
            }
            this.curReq = null;
        }

        private void saveFile(Bitmap bitmap, File file, boolean saveAdPng) {
            block4: {
                try {
                    if (file.exists()) {
                        file.delete();
                    }
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                    Bitmap.CompressFormat type = saveAdPng ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG;
                    FileOutputStream fos = new FileOutputStream(file);
                    bitmap.compress(type, 100, (OutputStream)fos);
                    fos.flush();
                    fos.close();
                }
                catch (Throwable t) {
                    if (!file.exists()) break block4;
                    file.delete();
                }
            }
        }

        @Override
        public void interrupt() {
            try {
                super.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class ManagerThread
    implements Handler.Callback {
        private Handler handler;

        public ManagerThread() {
            MobHandlerThread thread = new MobHandlerThread(){

                @Override
                public void run() {
                    ManagerThread.this.beforeRun();
                    super.run();
                }
            };
            thread.start();
            this.handler = new Handler(thread.getLooper(), (Handler.Callback)this);
            this.handler.sendEmptyMessageDelayed(1, 20000L);
        }

        private void beforeRun() {
            for (int i = 0; i < workerList.length; ++i) {
                if (workerList[i] != null) continue;
                workerList[i] = new WorkerThread();
                workerList[i].setName("worker " + i);
                workerList[i].localType = i == 0;
                workerList[i].start();
            }
        }

        public boolean handleMessage(Message msg) {
            if (cachePool != null) {
                cachePool.trimBeforeTime(System.currentTimeMillis() - 60000L);
            }
            int cacheMapSize = cachePool == null ? 0 : cachePool.size();
            MobLog.getInstance().d(">>>> BitmapProcessor.cachePool: " + cacheMapSize, new Object[0]);
            int reqListSize = reqList == null ? 0 : reqList.size();
            MobLog.getInstance().d(">>>> BitmapProcessor.reqList: " + reqListSize, new Object[0]);
            if (work) {
                this.handler.sendEmptyMessageDelayed(1, 20000L);
            }
            return false;
        }

        public void quit() {
            this.handler.removeMessages(1);
            this.handler.getLooper().quit();
            for (int i = 0; i < workerList.length; ++i) {
                if (workerList[i] == null) continue;
                workerList[i].interrupt();
                workerList[i] = null;
            }
        }
    }
}

