/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.app.UiModeManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.mob.tools.MobLog;
import com.mob.tools.utils.Data;
import com.mob.tools.utils.LocationHelper;
import com.mob.tools.utils.ReflectHelper;
import com.mob.tools.utils.ResHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;

public class DeviceHelper {
    private Context context;
    private static DeviceHelper deviceHelper;

    public static synchronized DeviceHelper getInstance(Context c) {
        if (deviceHelper == null && c != null) {
            deviceHelper = new DeviceHelper(c);
        }
        return deviceHelper;
    }

    private DeviceHelper(Context context) {
        this.context = context.getApplicationContext();
    }

    public boolean isRooted() {
        return false;
    }

    public String getSSID() {
        try {
            if (this.checkPermission("android.permission.ACCESS_WIFI_STATE")) {
                Object wifi = this.getSystemService("wifi");
                if (wifi == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("ge");
                sb.append("tC");
                sb.append("on");
                sb.append("ne");
                sb.append("ct");
                sb.append("io");
                sb.append("nI");
                sb.append("nf");
                sb.append("o");
                Object info = ReflectHelper.invokeInstanceMethod(wifi, sb.toString(), new Object[0]);
                if (info != null) {
                    StringBuilder sb1 = new StringBuilder();
                    sb1.append("ge");
                    sb1.append("tS");
                    sb1.append("SI");
                    sb1.append("D");
                    String ssid = (String)ReflectHelper.invokeInstanceMethod(info, sb1.toString(), new Object[0]);
                    return ssid == null ? null : ssid.replace("\"", "");
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    public String getBssid() {
        try {
            if (this.checkPermission("android.permission.ACCESS_WIFI_STATE")) {
                Object wifi = this.getSystemService("wifi");
                if (wifi == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("ge");
                sb.append("tC");
                sb.append("on");
                sb.append("ne");
                sb.append("ct");
                sb.append("io");
                sb.append("nI");
                sb.append("nf");
                sb.append("o");
                Object info = ReflectHelper.invokeInstanceMethod(wifi, sb.toString(), new Object[0]);
                if (info != null) {
                    StringBuilder sb1 = new StringBuilder();
                    sb1.append("ge");
                    sb1.append("tB");
                    sb1.append("SS");
                    sb1.append("ID");
                    String bssid = (String)ReflectHelper.invokeInstanceMethod(info, sb1.toString(), new Object[0]);
                    return bssid == null ? null : bssid;
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    public String getMacAddress() {
        if (Build.VERSION.SDK_INT >= 23) {
            String hd = null;
            try {
                hd = this.getHardwareAddressFromShell("wlan0");
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
                hd = null;
            }
            if (hd == null) {
                try {
                    hd = this.getCurrentNetworkHardwareAddress();
                }
                catch (Throwable t) {
                    MobLog.getInstance().d(t);
                    hd = null;
                }
            }
            if (hd == null) {
                try {
                    String[] hds = this.listNetworkHardwareAddress();
                    if (hds.length > 0) {
                        hd = hds[0];
                    }
                }
                catch (Throwable t) {
                    MobLog.getInstance().d(t);
                    hd = null;
                }
            }
            if (hd != null) {
                return hd;
            }
        }
        try {
            Object wifi = this.getSystemService("wifi");
            if (wifi == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("ge");
            sb.append("tC");
            sb.append("on");
            sb.append("ne");
            sb.append("ct");
            sb.append("io");
            sb.append("nI");
            sb.append("nf");
            sb.append("o");
            Object info = ReflectHelper.invokeInstanceMethod(wifi, sb.toString(), new Object[0]);
            if (info != null) {
                StringBuilder sb1 = new StringBuilder();
                sb1.append("ge");
                sb1.append("tM");
                sb1.append("ac");
                sb1.append("Ad");
                sb1.append("dr");
                sb1.append("es");
                sb1.append("s");
                String mac = (String)ReflectHelper.invokeInstanceMethod(info, sb1.toString(), new Object[0]);
                return mac == null ? null : mac;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return null;
    }

    private String getCurrentNetworkHardwareAddress() throws Throwable {
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        if (nis == null) {
            return null;
        }
        ArrayList<NetworkInterface> interfaces = Collections.list(nis);
        for (NetworkInterface intf : interfaces) {
            Enumeration<InetAddress> ias = intf.getInetAddresses();
            if (ias == null) continue;
            ArrayList<InetAddress> addrs = Collections.list(ias);
            for (InetAddress add : addrs) {
                byte[] mac;
                if (add.isLoopbackAddress() || !(add instanceof Inet4Address) || (mac = intf.getHardwareAddress()) == null) continue;
                StringBuilder buf = new StringBuilder();
                for (byte aMac : mac) {
                    buf.append(String.format("%02x:", aMac));
                }
                if (buf.length() > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                return buf.toString();
            }
        }
        return null;
    }

    private String[] listNetworkHardwareAddress() throws Throwable {
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        if (nis == null) {
            return null;
        }
        ArrayList<NetworkInterface> interfaces = Collections.list(nis);
        HashMap<String, String> macs = new HashMap<String, String>();
        for (NetworkInterface intf : interfaces) {
            byte[] mac = intf.getHardwareAddress();
            if (mac == null) continue;
            StringBuilder buf = new StringBuilder();
            for (byte aMac : mac) {
                buf.append(String.format("%02x:", aMac));
            }
            if (buf.length() > 0) {
                buf.deleteCharAt(buf.length() - 1);
            }
            macs.put(intf.getName(), buf.toString());
        }
        ArrayList names = new ArrayList(macs.keySet());
        ArrayList<String> wlans = new ArrayList<String>();
        ArrayList<String> eths = new ArrayList<String>();
        ArrayList<String> rmnets = new ArrayList<String>();
        ArrayList<String> dummys = new ArrayList<String>();
        ArrayList<String> usbs = new ArrayList<String>();
        ArrayList<String> rmnetUsbs = new ArrayList<String>();
        ArrayList<String> others = new ArrayList<String>();
        while (names.size() > 0) {
            String name = (String)names.remove(0);
            if (name.startsWith("wlan")) {
                wlans.add(name);
                continue;
            }
            if (name.startsWith("eth")) {
                eths.add(name);
                continue;
            }
            if (name.startsWith("rev_rmnet")) {
                rmnets.add(name);
                continue;
            }
            if (name.startsWith("dummy")) {
                dummys.add(name);
                continue;
            }
            if (name.startsWith("usbnet")) {
                usbs.add(name);
                continue;
            }
            if (name.startsWith("rmnet_usb")) {
                rmnetUsbs.add(name);
                continue;
            }
            others.add(name);
        }
        Collections.sort(wlans);
        Collections.sort(eths);
        Collections.sort(rmnets);
        Collections.sort(dummys);
        Collections.sort(usbs);
        Collections.sort(rmnetUsbs);
        Collections.sort(others);
        names.addAll(wlans);
        names.addAll(eths);
        names.addAll(rmnets);
        names.addAll(dummys);
        names.addAll(usbs);
        names.addAll(rmnetUsbs);
        names.addAll(others);
        String[] macArr = new String[names.size()];
        for (int i = 0; i < macArr.length; ++i) {
            macArr[i] = (String)macs.get(names.get(i));
        }
        return macArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHardwareAddressFromShell(String networkCard) {
        String line = null;
        BufferedReader br = null;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("ca");
            sb.append("t ");
            sb.append("/s");
            sb.append("ys");
            sb.append("/c");
            sb.append("la");
            sb.append("ss");
            sb.append("/n");
            sb.append("et");
            sb.append("/");
            sb.append(networkCard);
            sb.append("/a");
            sb.append("dd");
            sb.append("re");
            sb.append("ss");
            Process p = Runtime.getRuntime().exec(sb.toString());
            InputStreamReader isr = new InputStreamReader(p.getInputStream());
            br = new BufferedReader(isr);
            line = br.readLine();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Throwable sb) {}
            }
        }
        return TextUtils.isEmpty(line) ? null : line;
    }

    public String getModel() {
        return Build.MODEL;
    }

    public String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public String getDeviceId() {
        String deviceId = this.getIMEI();
        if (TextUtils.isEmpty((CharSequence)deviceId) && Build.VERSION.SDK_INT >= 9) {
            return this.getSerialno();
        }
        return deviceId;
    }

    public String getMime() {
        return this.getIMEI();
    }

    public String getIMEI() {
        Object phone = this.getSystemService("phone");
        if (phone == null) {
            return null;
        }
        String deviceId = null;
        try {
            if (this.checkPermission("android.permission.READ_PHONE_STATE")) {
                StringBuilder sb = new StringBuilder();
                sb.append("ge");
                sb.append("tD");
                sb.append("ev");
                sb.append("ic");
                sb.append("eI");
                sb.append("d");
                deviceId = (String)ReflectHelper.invokeInstanceMethod(phone, sb.toString(), new Object[0]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        if (TextUtils.isEmpty(deviceId)) {
            return null;
        }
        return deviceId;
    }

    public String getSerialno() {
        String serialno = null;
        if (Build.VERSION.SDK_INT >= 9) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("an");
                sb.append("dr");
                sb.append("oi");
                sb.append("d.");
                sb.append("os");
                sb.append(".S");
                sb.append("ys");
                sb.append("te");
                sb.append("mP");
                sb.append("ro");
                sb.append("pe");
                sb.append("rt");
                sb.append("ie");
                sb.append("s");
                ReflectHelper.importClass(sb.toString());
                StringBuilder sb1 = new StringBuilder();
                sb1.append("ge");
                sb1.append("t");
                serialno = (String)ReflectHelper.invokeStaticMethod("SystemProperties", sb1.toString(), "ro.serialno", "unknown");
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
                serialno = null;
            }
        }
        return serialno;
    }

    public String getDeviceData() {
        String data = this.getModel() + "|" + this.getOSVersionInt() + "|" + this.getManufacturer() + "|" + this.getCarrier() + "|" + this.getScreenSize();
        String deviString = this.getDeviceKey();
        return this.Base64AES(data, deviString.substring(0, 16));
    }

    public String getDeviceDataNotAES() {
        return this.getModel() + "|" + this.getOSVersion() + "|" + this.getManufacturer() + "|" + this.getCarrier() + "|" + this.getScreenSize();
    }

    public String Base64AES(String msg, String key) {
        String result = null;
        try {
            result = Base64.encodeToString((byte[])Data.AES128Encode(key, msg), (int)0);
            if (result.contains("\n")) {
                result = result.replace("\n", "");
            }
        }
        catch (Throwable e) {
            MobLog.getInstance().w(e);
        }
        return result;
    }

    public String getOSVersion() {
        return String.valueOf(this.getOSVersionInt());
    }

    public int getOSVersionInt() {
        return Build.VERSION.SDK_INT;
    }

    public String getOSVersionName() {
        return Build.VERSION.RELEASE;
    }

    public String getOSLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public String getAppLanguage() {
        return this.context.getResources().getConfiguration().locale.getLanguage();
    }

    public String getOSCountry() {
        return Locale.getDefault().getCountry();
    }

    public String getScreenSize() {
        int[] size = ResHelper.getScreenSize(this.context);
        if (this.context.getResources().getConfiguration().orientation == 1) {
            return size[0] + "x" + size[1];
        }
        return size[1] + "x" + size[0];
    }

    public String getCarrier() {
        try {
            Object tm = this.getSystemService("phone");
            if (tm == null) {
                return "-1";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("ge");
            sb.append("tS");
            sb.append("im");
            sb.append("Op");
            sb.append("er");
            sb.append("at");
            sb.append("or");
            String operator = (String)ReflectHelper.invokeInstanceMethod(tm, sb.toString(), new Object[0]);
            if (TextUtils.isEmpty((CharSequence)operator)) {
                operator = "-1";
            }
            return operator;
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return "-1";
        }
    }

    public String getCarrierName() {
        Object tm = this.getSystemService("phone");
        if (tm == null) {
            return null;
        }
        try {
            if (this.checkPermission("android.permission.READ_PHONE_STATE")) {
                StringBuilder sb = new StringBuilder();
                sb.append("ge");
                sb.append("tS");
                sb.append("im");
                sb.append("Op");
                sb.append("er");
                sb.append("at");
                sb.append("or");
                sb.append("Na");
                sb.append("me");
                String operator = (String)ReflectHelper.invokeInstanceMethod(tm, sb.toString(), new Object[0]);
                if (TextUtils.isEmpty((CharSequence)operator)) {
                    operator = null;
                }
                return operator;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return null;
    }

    public String getMCC() {
        String imsi = this.getIMSI();
        if (imsi != null && imsi.length() >= 3) {
            return imsi.substring(0, 3);
        }
        return null;
    }

    public String getMNC() {
        String imsi = this.getIMSI();
        if (imsi != null && imsi.length() >= 5) {
            return imsi.substring(3, 5);
        }
        return null;
    }

    public String getSimSerialNumber() {
        try {
            Object tm = this.getSystemService("phone");
            if (tm == null) {
                return "-1";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("ge");
            sb.append("tS");
            sb.append("im");
            sb.append("Se");
            sb.append("ri");
            sb.append("al");
            sb.append("Nu");
            sb.append("mb");
            sb.append("er");
            return (String)ReflectHelper.invokeInstanceMethod(tm, sb.toString(), new Object[0]);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return "-1";
        }
    }

    public String getLine1Number() {
        try {
            Object tm = this.getSystemService("phone");
            if (tm == null) {
                return "-1";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("ge");
            sb.append("tL");
            sb.append("in");
            sb.append("e1");
            sb.append("Nu");
            sb.append("mb");
            sb.append("er");
            return (String)ReflectHelper.invokeInstanceMethod(tm, sb.toString(), new Object[0]);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return "-1";
        }
    }

    public String getBluetoothName() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("an");
            sb.append("dr");
            sb.append("oi");
            sb.append("d.");
            sb.append("bl");
            sb.append("ue");
            sb.append("to");
            sb.append("ot");
            sb.append("h.");
            sb.append("Bl");
            sb.append("ue");
            sb.append("to");
            sb.append("ot");
            sb.append("hA");
            sb.append("da");
            sb.append("pt");
            sb.append("er");
            ReflectHelper.importClass(sb.toString());
            if (this.checkPermission("android.permission.BLUETOOTH")) {
                StringBuilder sb1 = new StringBuilder();
                sb1.append("ge");
                sb1.append("tD");
                sb1.append("ef");
                sb1.append("au");
                sb1.append("lt");
                sb1.append("Ad");
                sb1.append("ap");
                sb1.append("te");
                sb1.append("r");
                Object myDevice = ReflectHelper.invokeStaticMethod("BluetoothAdapter", sb1.toString(), new Object[0]);
                if (myDevice != null) {
                    StringBuilder sb2 = new StringBuilder();
                    sb2.append("ge");
                    sb2.append("tN");
                    sb2.append("am");
                    sb2.append("e");
                    return (String)ReflectHelper.invokeInstanceMethod(myDevice, sb2.toString(), new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            MobLog.getInstance().d(e);
        }
        return null;
    }

    public String getSignMD5() {
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.getPackageName(), 64);
            Signature[] signs = packageInfo.signatures;
            return Data.MD5(signs[0].toByteArray());
        }
        catch (Exception e) {
            MobLog.getInstance().w(e);
            return null;
        }
    }

    private Object getSystemService(String name) {
        try {
            return this.context.getSystemService(name);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return null;
        }
    }

    public String getNetworkType() {
        ConnectivityManager conn = (ConnectivityManager)this.getSystemService("connectivity");
        if (conn == null) {
            return "none";
        }
        try {
            if (!this.checkPermission("android.permission.ACCESS_NETWORK_STATE")) {
                return "none";
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return "none";
        }
        NetworkInfo network = conn.getActiveNetworkInfo();
        if (network == null || !network.isAvailable()) {
            return "none";
        }
        int type = network.getType();
        switch (type) {
            case 1: {
                return "wifi";
            }
            case 0: {
                if (this.is4GMobileNetwork()) {
                    return "4G";
                }
                return this.isFastMobileNetwork() ? "3G" : "2G";
            }
            case 7: {
                return "bluetooth";
            }
            case 8: {
                return "dummy";
            }
            case 9: {
                return "ethernet";
            }
            case 6: {
                return "wimax";
            }
        }
        return String.valueOf(type);
    }

    public String getNetworkTypeForStatic() {
        String networkType = this.getNetworkType().toLowerCase();
        if (TextUtils.isEmpty((CharSequence)networkType) || "none".equals(networkType)) {
            return "none";
        }
        if (networkType.startsWith("4g") || networkType.startsWith("3g") || networkType.startsWith("2g")) {
            return "cell";
        }
        if (networkType.startsWith("wifi")) {
            return "wifi";
        }
        return "other";
    }

    public String getDetailNetworkTypeForStatic() {
        String networkType = this.getNetworkType().toLowerCase();
        if (TextUtils.isEmpty((CharSequence)networkType) || "none".equals(networkType)) {
            return "none";
        }
        if (networkType.startsWith("wifi")) {
            return "wifi";
        }
        if (networkType.startsWith("4g")) {
            return "4g";
        }
        if (networkType.startsWith("3g")) {
            return "3g";
        }
        if (networkType.startsWith("2g")) {
            return "2g";
        }
        if (networkType.startsWith("bluetooth")) {
            return "bluetooth";
        }
        return networkType;
    }

    public int getPlatformCode() {
        return 1;
    }

    private boolean is4GMobileNetwork() {
        Object phone = this.getSystemService("phone");
        if (phone == null) {
            return false;
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("ge");
            sb.append("tN");
            sb.append("et");
            sb.append("wo");
            sb.append("rk");
            sb.append("Ty");
            sb.append("pe");
            int type = (Integer)ReflectHelper.invokeInstanceMethod(phone, sb.toString(), new Object[0]);
            return type == 13;
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return false;
        }
    }

    private boolean isFastMobileNetwork() {
        Object phone = this.getSystemService("phone");
        if (phone == null) {
            return false;
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("ge");
            sb.append("tN");
            sb.append("et");
            sb.append("wo");
            sb.append("rk");
            sb.append("Ty");
            sb.append("pe");
            int type = (Integer)ReflectHelper.invokeInstanceMethod(phone, sb.toString(), new Object[0]);
            switch (type) {
                case 7: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 8: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 15: {
                    return true;
                }
                case 11: {
                    return false;
                }
                case 13: {
                    return true;
                }
                case 0: {
                    return false;
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return false;
    }

    public JSONArray getRunningApp() {
        JSONArray appNmes = new JSONArray();
        Object am = this.getSystemService("activity");
        if (am == null) {
            return appNmes;
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("ge");
            sb.append("tR");
            sb.append("un");
            sb.append("ni");
            sb.append("ng");
            sb.append("Ap");
            sb.append("pP");
            sb.append("ro");
            sb.append("ce");
            sb.append("ss");
            sb.append("es");
            List apps = (List)ReflectHelper.invokeInstanceMethod(am, sb.toString(), new Object[0]);
            if (apps == null) {
                return appNmes;
            }
            for (Object app : apps) {
                StringBuilder sb1 = new StringBuilder();
                sb1.append("pr");
                sb1.append("oc");
                sb1.append("es");
                sb1.append("sN");
                sb1.append("am");
                sb1.append("e");
                appNmes.put(ReflectHelper.getInstanceField(app, sb1.toString()));
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return appNmes;
    }

    public String getRunningAppStr() throws JSONException {
        JSONArray apps = this.getRunningApp();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < apps.length(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(String.valueOf(apps.get(i)));
        }
        return sb.toString();
    }

    public String getDeviceKey() {
        String deviceKey = null;
        try {
            deviceKey = this.getDeviceKeyWithDuid("comm/dbs/.duid");
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        if (TextUtils.isEmpty((CharSequence)deviceKey) || deviceKey.length() < 40) {
            deviceKey = this.genDeviceKey();
        }
        if (!TextUtils.isEmpty((CharSequence)deviceKey) && deviceKey.length() >= 40) {
            return deviceKey;
        }
        try {
            deviceKey = this.getLocalDeviceKey();
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            deviceKey = null;
        }
        if (!TextUtils.isEmpty((CharSequence)deviceKey) && deviceKey.length() >= 40) {
            return deviceKey;
        }
        if (TextUtils.isEmpty((CharSequence)deviceKey) || deviceKey.length() < 40) {
            deviceKey = this.getCharAndNumr(40);
        }
        if (deviceKey != null) {
            try {
                this.saveLocalDeviceKey(deviceKey);
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }
        return deviceKey;
    }

    private String genDeviceKey() {
        String newKey = null;
        try {
            String mac = this.getMacAddress();
            String udid = this.getDeviceId();
            String model = this.getModel();
            String data = mac + ":" + udid + ":" + model;
            byte[] bytes = Data.SHA1(data);
            newKey = Data.byteToHex(bytes);
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            newKey = null;
        }
        return newKey;
    }

    public String getCharAndNumr(int length) {
        long currentTime = System.currentTimeMillis();
        long elapseTime = SystemClock.elapsedRealtime();
        long realTime = currentTime ^ elapseTime;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(realTime);
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                char charValue = (char)(97 + random.nextInt(26));
                stringBuffer.insert(i + 1, charValue);
                continue;
            }
            stringBuffer.insert(stringBuffer.length(), random.nextInt(10));
        }
        return stringBuffer.toString().substring(0, 40);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDeviceKeyWithDuid(String duidFilePath) throws Throwable {
        HashMap map;
        block19: {
            map = null;
            try {
                File file = new File(ResHelper.getCacheRoot(this.context), duidFilePath);
                if (!file.exists() || !file.isFile()) break block19;
                ObjectInputStream ois = null;
                try {
                    FileInputStream fis = new FileInputStream(file);
                    ois = new ObjectInputStream(fis);
                    map = (HashMap)ois.readObject();
                }
                catch (Throwable t) {
                    MobLog.getInstance().w(t);
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Throwable fis) {}
                    }
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }
        if (map == null) {
            return null;
        }
        HashMap deviceInfo = (HashMap)map.get("deviceInfo");
        if (deviceInfo == null) {
            return null;
        }
        String deviceKey = "";
        try {
            String mac = (String)deviceInfo.get("mac");
            String deviceId = (String)deviceInfo.get("imei");
            if (TextUtils.isEmpty((CharSequence)deviceId) && Build.VERSION.SDK_INT >= 9) {
                deviceId = (String)deviceInfo.get("serialno");
            }
            String model = (String)deviceInfo.get("model");
            String data = mac + ":" + deviceId + ":" + model;
            byte[] bytes = Data.SHA1(data);
            deviceKey = Data.byteToHex(bytes);
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            deviceKey = null;
        }
        return deviceKey;
    }

    private String getLocalDeviceKey() throws Throwable {
        boolean success;
        File keyFile;
        if (!this.getSdcardState()) {
            return null;
        }
        String sdPath = this.getSdcardPath();
        File cacheRoot = new File(sdPath, "ShareSDK");
        if (cacheRoot.exists() && (keyFile = new File(cacheRoot, ".dk")).exists() && (success = keyFile.renameTo(new File(ResHelper.getCacheRoot(this.context), ".dk")))) {
            keyFile.delete();
        }
        if (!(keyFile = new File(ResHelper.getCacheRoot(this.context), ".dk")).exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(keyFile);
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object key = ois.readObject();
        String strKey = null;
        if (key != null && key instanceof char[]) {
            char[] cKey = (char[])key;
            strKey = String.valueOf(cKey);
        }
        ois.close();
        return strKey;
    }

    private void saveLocalDeviceKey(String key) throws Throwable {
        if (!this.getSdcardState()) {
            return;
        }
        File keyFile = new File(ResHelper.getCacheRoot(this.context), ".dk");
        if (keyFile.exists()) {
            keyFile.delete();
        }
        FileOutputStream fos = new FileOutputStream(keyFile);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        char[] cKey = key.toCharArray();
        oos.writeObject(cKey);
        oos.flush();
        oos.close();
    }

    public String getPackageName() {
        return this.context.getPackageName();
    }

    public String getAppName() {
        int appLbl;
        String appName = this.context.getApplicationInfo().name;
        if (appName != null) {
            if (Build.VERSION.SDK_INT >= 25 && !appName.endsWith(".*")) {
                try {
                    ReflectHelper.importClass(appName);
                    appName = null;
                }
                catch (Throwable throwable) {}
            } else {
                return appName;
            }
        }
        appName = (appLbl = this.context.getApplicationInfo().labelRes) > 0 ? this.context.getString(appLbl) : String.valueOf(this.context.getApplicationInfo().nonLocalizedLabel);
        return appName;
    }

    public int getAppVersion() {
        try {
            PackageManager pm = this.context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(this.context.getPackageName(), 0);
            return pi.versionCode;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return 0;
        }
    }

    public String getAppVersionName() {
        try {
            PackageManager pm = this.context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(this.context.getPackageName(), 0);
            return pi.versionName;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return "1.0";
        }
    }

    public ArrayList<HashMap<String, String>> getInstalledApp(boolean includeSystemApp) {
        try {
            ArrayList<String> packages = new ArrayList<String>();
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("pm");
                sb.append(" l");
                sb.append("is");
                sb.append("t ");
                sb.append("pa");
                sb.append("ck");
                sb.append("ag");
                sb.append("es");
                Process p = Runtime.getRuntime().exec(sb.toString());
                InputStreamReader isr = new InputStreamReader(p.getInputStream(), "utf-8");
                BufferedReader br = new BufferedReader(isr);
                String line = br.readLine();
                while (line != null) {
                    if ((line = line.toLowerCase().trim()).startsWith("package:")) {
                        line = line.substring("package:".length()).trim();
                        packages.add(line);
                    }
                    line = br.readLine();
                }
                br.close();
                p.destroy();
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
            ArrayList<HashMap<String, String>> apps = new ArrayList<HashMap<String, String>>();
            PackageManager pm = this.context.getPackageManager();
            for (String pkg : packages) {
                PackageInfo pi = null;
                try {
                    pi = pm.getPackageInfo(pkg, 0);
                }
                catch (Throwable t) {
                    MobLog.getInstance().d(t);
                }
                if (pi == null || !includeSystemApp && this.isSystemApp(pi)) continue;
                HashMap<String, String> app = new HashMap<String, String>();
                app.put("pkg", pi.packageName);
                String appName = pi.applicationInfo.name;
                if (appName == null) {
                    CharSequence label;
                    int appLbl = pi.applicationInfo.labelRes;
                    if (appLbl > 0 && (label = pm.getText(pi.packageName, appLbl, pi.applicationInfo)) != null) {
                        appName = label.toString().trim();
                    }
                    if (appName == null) {
                        appName = String.valueOf(pi.applicationInfo.nonLocalizedLabel);
                    }
                }
                app.put("name", appName);
                app.put("version", pi.versionName);
                apps.add(app);
            }
            return apps;
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return new ArrayList<HashMap<String, String>>();
        }
    }

    private boolean isSystemApp(PackageInfo pi) {
        boolean isSysApp = (pi.applicationInfo.flags & 1) == 1;
        boolean isSysUpd = (pi.applicationInfo.flags & 0x80) == 1;
        return isSysApp || isSysUpd;
    }

    public String getNetworkOperator() {
        Object tm = this.getSystemService("phone");
        if (tm == null) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("ge");
            sb.append("tN");
            sb.append("et");
            sb.append("wo");
            sb.append("rk");
            sb.append("Op");
            sb.append("er");
            sb.append("at");
            sb.append("or");
            return (String)ReflectHelper.invokeInstanceMethod(tm, sb.toString(), new Object[0]);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return null;
        }
    }

    public boolean checkPermission(String permission) throws Throwable {
        int res;
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("an");
                sb.append("dr");
                sb.append("oi");
                sb.append("d.");
                sb.append("co");
                sb.append("nt");
                sb.append("en");
                sb.append("t.");
                sb.append("Co");
                sb.append("nt");
                sb.append("ex");
                sb.append("t");
                ReflectHelper.importClass(sb.toString());
                StringBuilder sb1 = new StringBuilder();
                sb1.append("ch");
                sb1.append("ec");
                sb1.append("kS");
                sb1.append("el");
                sb1.append("fP");
                sb1.append("er");
                sb1.append("mi");
                sb1.append("ss");
                sb1.append("io");
                sb1.append("n");
                Integer ret = (Integer)ReflectHelper.invokeInstanceMethod(this.context, sb1.toString(), permission);
                res = ret == null ? -1 : ret;
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
                res = -1;
            }
        } else {
            this.context.checkPermission(permission, android.os.Process.myPid(), android.os.Process.myUid());
            res = this.context.getPackageManager().checkPermission(permission, this.getPackageName());
        }
        return res == 0;
    }

    public String getTopTaskPackageName() {
        boolean hasPer = false;
        try {
            hasPer = this.checkPermission("android.permission.GET_TASKS");
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            hasPer = false;
        }
        if (hasPer) {
            try {
                Object am = this.getSystemService("activity");
                if (am == null) {
                    return null;
                }
                if (Build.VERSION.SDK_INT <= 20) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("ge");
                    sb.append("tR");
                    sb.append("un");
                    sb.append("ni");
                    sb.append("ng");
                    sb.append("Ta");
                    sb.append("sk");
                    sb.append("s");
                    List tasks = (List)ReflectHelper.invokeInstanceMethod(am, sb.toString(), 1);
                    StringBuilder sb1 = new StringBuilder();
                    sb1.append("to");
                    sb1.append("pA");
                    sb1.append("ct");
                    sb1.append("iv");
                    sb1.append("it");
                    sb1.append("y");
                    Object topActivity = ReflectHelper.getInstanceField(tasks.get(0), sb1.toString());
                    StringBuilder sb2 = new StringBuilder();
                    sb2.append("ge");
                    sb2.append("tP");
                    sb2.append("ac");
                    sb2.append("ka");
                    sb2.append("ge");
                    sb2.append("Na");
                    sb2.append("me");
                    return (String)ReflectHelper.invokeInstanceMethod(topActivity, sb2.toString(), new Object[0]);
                }
                StringBuilder sb = new StringBuilder();
                sb.append("ge");
                sb.append("tR");
                sb.append("un");
                sb.append("ni");
                sb.append("ng");
                sb.append("Ap");
                sb.append("pP");
                sb.append("ro");
                sb.append("ce");
                sb.append("ss");
                sb.append("es");
                List processInfos = (List)ReflectHelper.invokeInstanceMethod(am, sb.toString(), new Object[0]);
                StringBuilder sb1 = new StringBuilder();
                sb1.append("pr");
                sb1.append("oc");
                sb1.append("es");
                sb1.append("sN");
                sb1.append("am");
                sb1.append("e");
                String processName = (String)ReflectHelper.getInstanceField(processInfos.get(0), sb1.toString());
                return processName.split(":")[0];
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
        }
        return null;
    }

    public boolean getSdcardState() {
        try {
            return this.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE") && "mounted".equals(Environment.getExternalStorageState());
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return false;
        }
    }

    public String getSdcardPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public String getAndroidID() {
        String androidId = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
        MobLog.getInstance().i("getAndroidID === " + androidId, new Object[0]);
        return androidId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAdvertisingID() throws Throwable {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new Throwable("Do not call this function from the main thread !");
        }
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        GSConnection gsc = new GSConnection();
        String adsid = null;
        try {
            this.context.bindService(intent, (ServiceConnection)gsc, 1);
            IBinder binder = gsc.takeBinder();
            Parcel input = Parcel.obtain();
            Parcel output = Parcel.obtain();
            input.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
            binder.transact(1, input, output, 0);
            output.readException();
            adsid = output.readString();
            output.recycle();
            input.recycle();
            String string = adsid;
            return string;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            String string = adsid;
            return string;
        }
        finally {
            this.context.unbindService((ServiceConnection)gsc);
        }
    }

    public void hideSoftInput(View view) {
        Object service = this.getSystemService("input_method");
        if (service == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)service;
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public void showSoftInput(View view) {
        Object service = this.getSystemService("input_method");
        if (service == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)service;
        imm.toggleSoftInputFromWindow(view.getWindowToken(), 2, 0);
    }

    public boolean isMainProcess(int pid) {
        try {
            Object am = this.getSystemService("activity");
            StringBuilder sb = new StringBuilder();
            sb.append("ge");
            sb.append("tR");
            sb.append("un");
            sb.append("ni");
            sb.append("ng");
            sb.append("Ap");
            sb.append("pP");
            sb.append("ro");
            sb.append("ce");
            sb.append("ss");
            sb.append("es");
            List rps = (List)ReflectHelper.invokeInstanceMethod(am, sb.toString(), new Object[0]);
            if (rps == null) {
                return pid <= 0;
            }
            String application = null;
            int myPid = pid <= 0 ? android.os.Process.myPid() : pid;
            for (Object appProcess : rps) {
                StringBuilder sb1 = new StringBuilder();
                sb1.append("pi");
                sb1.append("d");
                int apid = (Integer)ReflectHelper.getInstanceField(appProcess, sb1.toString());
                if (apid != myPid) continue;
                StringBuilder sb2 = new StringBuilder();
                sb2.append("pr");
                sb2.append("oc");
                sb2.append("es");
                sb2.append("sN");
                sb2.append("am");
                sb2.append("e");
                application = (String)ReflectHelper.getInstanceField(appProcess, sb2.toString());
                break;
            }
            return this.getPackageName().equals(application);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return false;
        }
    }

    public String getIMSI() {
        Object phone = this.getSystemService("phone");
        if (phone == null) {
            return null;
        }
        String imsi = null;
        try {
            if (this.checkPermission("android.permission.READ_PHONE_STATE")) {
                StringBuilder sb = new StringBuilder();
                sb.append("ge");
                sb.append("tS");
                sb.append("ub");
                sb.append("sc");
                sb.append("ri");
                sb.append("be");
                sb.append("rI");
                sb.append("d");
                imsi = (String)ReflectHelper.invokeInstanceMethod(phone, sb.toString(), new Object[0]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        if (TextUtils.isEmpty(imsi)) {
            return null;
        }
        return imsi;
    }

    public String getIPAddress() {
        try {
            if (this.checkPermission("android.permission.INTERNET")) {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                    while (enumIpAddr.hasMoreElements()) {
                        InetAddress inetAddress = enumIpAddr.nextElement();
                        if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                        return inetAddress.getHostAddress();
                    }
                }
            }
        }
        catch (Throwable e) {
            MobLog.getInstance().w(e);
        }
        return "0.0.0.0";
    }

    public float[] getLocation(int GPSTimeout, int networkTimeout) {
        Location loc = this.getLocation(GPSTimeout, networkTimeout, true);
        if (loc != null) {
            return new float[]{(float)loc.getLatitude(), (float)loc.getLongitude()};
        }
        return null;
    }

    public Location getLocation(int GPSTimeout, int networkTimeout, boolean useLastKnown) {
        try {
            if (this.checkPermission("android.permission.ACCESS_FINE_LOCATION")) {
                LocationHelper helper = new LocationHelper();
                return helper.getLocation(this.context, GPSTimeout, networkTimeout, useLastKnown);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    public HashMap<String, String> ping(String address, int count, int packetsize) {
        ArrayList<Float> sucRes = new ArrayList<Float>();
        try {
            String cmd = "ping -c " + count + " -s " + packetsize + " " + address;
            int bytes = packetsize + 8;
            Process p = Runtime.getRuntime().exec(cmd);
            InputStreamReader isr = new InputStreamReader(p.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                if (line.startsWith(bytes + " bytes from")) {
                    if (line.endsWith("ms")) {
                        line = line.substring(0, line.length() - 2).trim();
                    } else if (line.endsWith("s")) {
                        line = line.substring(0, line.length() - 1).trim() + "000";
                    }
                    int i = line.indexOf("time=");
                    if (i > 0) {
                        line = line.substring(i + 5).trim();
                        try {
                            sucRes.add(Float.valueOf(Float.parseFloat(line)));
                        }
                        catch (Throwable t) {
                            MobLog.getInstance().w(t);
                        }
                    }
                }
                line = br.readLine();
            }
            p.waitFor();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        int sucCount = sucRes.size();
        int fldCount = count - sucRes.size();
        float min = 0.0f;
        float max = 0.0f;
        float average = 0.0f;
        if (sucCount > 0) {
            min = Float.MAX_VALUE;
            for (int i = 0; i < sucCount; ++i) {
                float item = ((Float)sucRes.get(i)).floatValue();
                if (item < min) {
                    min = item;
                }
                if (item > max) {
                    max = item;
                }
                average += item;
            }
            average /= (float)sucCount;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("address", address);
        map.put("transmitted", String.valueOf(count));
        map.put("received", String.valueOf(sucCount));
        map.put("loss", String.valueOf(fldCount));
        map.put("min", String.valueOf(min));
        map.put("max", String.valueOf(max));
        map.put("avg", String.valueOf(average));
        return map;
    }

    public int getCellId() {
        try {
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemService("phone")) != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("ge");
                sb.append("tC");
                sb.append("el");
                sb.append("lL");
                sb.append("oc");
                sb.append("at");
                sb.append("io");
                sb.append("n");
                Object loc = ReflectHelper.invokeInstanceMethod(tm, sb.toString(), new Object[0]);
                if (loc != null) {
                    StringBuilder sb1 = new StringBuilder();
                    sb1.append("ge");
                    sb1.append("tC");
                    sb1.append("id");
                    return ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, sb1.toString(), new Object[0]), -1);
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return -1;
    }

    public int getCellLac() {
        try {
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemService("phone")) != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("ge");
                sb.append("tC");
                sb.append("el");
                sb.append("lL");
                sb.append("oc");
                sb.append("at");
                sb.append("io");
                sb.append("n");
                Object loc = ReflectHelper.invokeInstanceMethod(tm, sb.toString(), new Object[0]);
                if (loc != null) {
                    StringBuilder sb1 = new StringBuilder();
                    sb1.append("ge");
                    sb1.append("tL");
                    sb1.append("ac");
                    return ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, sb1.toString(), new Object[0]), -1);
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return -1;
    }

    public String getDeviceType() {
        UiModeManager um = (UiModeManager)this.getSystemService("uimode");
        if (um != null) {
            int type = um.getCurrentModeType();
            switch (type) {
                case 1: {
                    return "NO_UI";
                }
                case 2: {
                    return "DESK";
                }
                case 3: {
                    return "CAR";
                }
                case 4: {
                    return "TELEVISION";
                }
                case 5: {
                    return "APPLIANCE";
                }
                case 6: {
                    return "WATCH";
                }
            }
        }
        return "UNDEFINED";
    }

    private class GSConnection
    implements ServiceConnection {
        boolean got = false;
        private final BlockingQueue<IBinder> iBinders = new LinkedBlockingQueue<IBinder>();

        private GSConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this.iBinders.put(service);
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        public IBinder takeBinder() throws InterruptedException {
            if (this.got) {
                throw new IllegalStateException();
            }
            this.got = true;
            return this.iBinders.poll(1500L, TimeUnit.MILLISECONDS);
        }
    }
}

