/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.text.TextUtils;
import com.mob.tools.MobLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Hashon {
    public <T> HashMap<String, T> fromJson(String jsonStr) {
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return new HashMap();
        }
        try {
            if (jsonStr.startsWith("[") && jsonStr.endsWith("]")) {
                jsonStr = "{\"fakelist\":" + jsonStr + "}";
            }
            JSONObject json = new JSONObject(jsonStr);
            return this.fromJson(json);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(jsonStr, new Object[0]);
            MobLog.getInstance().w(t);
            return new HashMap();
        }
    }

    private <T> HashMap<String, T> fromJson(JSONObject json) throws JSONException {
        HashMap<String, HashMap<String, T>> map = new HashMap<String, HashMap<String, T>>();
        Iterator iKey = json.keys();
        while (iKey.hasNext()) {
            String key = (String)iKey.next();
            Cloneable value = json.opt(key);
            if (JSONObject.NULL.equals(value)) {
                value = null;
            }
            if (value == null) continue;
            if (value instanceof JSONObject) {
                value = this.fromJson((JSONObject)value);
            } else if (value instanceof JSONArray) {
                value = this.fromJson((JSONArray)value);
            }
            map.put(key, (HashMap<String, T>)value);
        }
        return map;
    }

    private ArrayList<Object> fromJson(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        int size = array.length();
        for (int i = 0; i < size; ++i) {
            Cloneable value = array.opt(i);
            if (value instanceof JSONObject) {
                value = this.fromJson((JSONObject)value);
            } else if (value instanceof JSONArray) {
                value = this.fromJson((JSONArray)value);
            }
            list.add(value);
        }
        return list;
    }

    public <T> String fromHashMap(HashMap<String, T> map) {
        try {
            JSONObject obj = this.getJSONObject(map);
            if (obj == null) {
                return "";
            }
            return obj.toString();
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return "";
        }
    }

    private <T> JSONObject getJSONObject(HashMap<String, T> map) throws JSONException {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof HashMap) {
                value = this.getJSONObject((HashMap)value);
            } else if (value instanceof ArrayList) {
                value = this.getJSONArray((ArrayList)value);
            } else if (this.isBasicArray(value)) {
                value = this.getJSONArray(this.arrayToList(value));
            }
            json.put(entry.getKey(), value);
        }
        return json;
    }

    private boolean isBasicArray(Object value) {
        return value instanceof byte[] || value instanceof short[] || value instanceof int[] || value instanceof long[] || value instanceof float[] || value instanceof double[] || value instanceof char[] || value instanceof boolean[] || value instanceof String[];
    }

    private ArrayList<?> arrayToList(Object value) {
        if (value instanceof byte[]) {
            ArrayList<Byte> list = new ArrayList<Byte>();
            for (byte item : (byte[])value) {
                list.add(item);
            }
            return list;
        }
        if (value instanceof short[]) {
            ArrayList<Short> list = new ArrayList<Short>();
            for (short item : (short[])value) {
                list.add(item);
            }
            return list;
        }
        if (value instanceof int[]) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int item : (int[])value) {
                list.add(item);
            }
            return list;
        }
        if (value instanceof long[]) {
            ArrayList<Long> list = new ArrayList<Long>();
            for (long item : (long[])value) {
                list.add(item);
            }
            return list;
        }
        if (value instanceof float[]) {
            ArrayList<Float> list = new ArrayList<Float>();
            for (float item : (float[])value) {
                list.add(Float.valueOf(item));
            }
            return list;
        }
        if (value instanceof double[]) {
            ArrayList<Double> list = new ArrayList<Double>();
            for (double item : (double[])value) {
                list.add(item);
            }
            return list;
        }
        if (value instanceof char[]) {
            ArrayList<Character> list = new ArrayList<Character>();
            for (char item : (char[])value) {
                list.add(Character.valueOf(item));
            }
            return list;
        }
        if (value instanceof boolean[]) {
            ArrayList<Boolean> list = new ArrayList<Boolean>();
            for (boolean item : (boolean[])value) {
                list.add(item);
            }
            return list;
        }
        if (value instanceof String[]) {
            ArrayList<String> list = new ArrayList<String>();
            for (String item : (String[])value) {
                list.add(item);
            }
            return list;
        }
        return null;
    }

    private JSONArray getJSONArray(ArrayList<Object> list) throws JSONException {
        JSONArray array = new JSONArray();
        for (Object value : list) {
            if (value instanceof HashMap) {
                value = this.getJSONObject((HashMap)value);
            } else if (value instanceof ArrayList) {
                value = this.getJSONArray((ArrayList)value);
            }
            array.put(value);
        }
        return array;
    }

    public String format(String jsonStr) {
        try {
            return this.format("", this.fromJson(jsonStr));
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return "";
        }
    }

    private String format(String sepStr, HashMap<String, Object> map) {
        StringBuffer sb = new StringBuffer();
        sb.append("{\n");
        String mySepStr = sepStr + "\t";
        int i = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (i > 0) {
                sb.append(",\n");
            }
            sb.append(mySepStr).append('\"').append(entry.getKey()).append("\":");
            Object value = entry.getValue();
            if (value instanceof HashMap) {
                sb.append(this.format(mySepStr, (HashMap)value));
            } else if (value instanceof ArrayList) {
                sb.append(this.format(mySepStr, (ArrayList)value));
            } else if (value instanceof String) {
                sb.append('\"').append(value).append('\"');
            } else {
                sb.append(value);
            }
            ++i;
        }
        sb.append('\n').append(sepStr).append('}');
        return sb.toString();
    }

    private String format(String sepStr, ArrayList<Object> list) {
        StringBuffer sb = new StringBuffer();
        sb.append("[\n");
        String mySepStr = sepStr + "\t";
        int i = 0;
        for (Object value : list) {
            if (i > 0) {
                sb.append(",\n");
            }
            sb.append(mySepStr);
            if (value instanceof HashMap) {
                sb.append(this.format(mySepStr, (HashMap)value));
            } else if (value instanceof ArrayList) {
                sb.append(this.format(mySepStr, (ArrayList)value));
            } else if (value instanceof String) {
                sb.append('\"').append(value).append('\"');
            } else {
                sb.append(value);
            }
            ++i;
        }
        sb.append('\n').append(sepStr).append(']');
        return sb.toString();
    }
}

