/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.mob.tools.MobHandlerThread;

public class LocationHelper
implements LocationListener,
Handler.Callback {
    private Handler handler;
    private Location res;
    private int gpsTimeoutSec;
    private int networkTimeoutSec;
    private LocationManager lm;
    private boolean gpsRequesting;
    private boolean networkRequesting;

    public LocationHelper() {
        MobHandlerThread thread = new MobHandlerThread();
        thread.start();
        this.handler = new Handler(thread.getLooper(), (Handler.Callback)this);
    }

    public Location getLocation(Context context) throws Throwable {
        return this.getLocation(context, 0);
    }

    public Location getLocation(Context context, int GPSTimeoutSec) throws Throwable {
        return this.getLocation(context, GPSTimeoutSec, 0);
    }

    public Location getLocation(Context context, int GPSTimeoutSec, int networkTimeoutSec) throws Throwable {
        return this.getLocation(context, GPSTimeoutSec, networkTimeoutSec, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getLocation(Context context, int GPSTimeoutSec, int networkTimeoutSec, boolean useLastKnown) throws Throwable {
        this.gpsTimeoutSec = GPSTimeoutSec;
        this.networkTimeoutSec = networkTimeoutSec;
        this.lm = (LocationManager)context.getSystemService("location");
        if (this.lm == null) {
            return null;
        }
        LocationHelper locationHelper = this;
        synchronized (locationHelper) {
            this.handler.sendEmptyMessageDelayed(0, 50L);
            this.wait();
        }
        if (this.res == null && useLastKnown) {
            boolean preferNetwork;
            boolean preferGPS = GPSTimeoutSec != 0;
            boolean bl = preferNetwork = networkTimeoutSec != 0;
            if (preferGPS && this.lm.isProviderEnabled("gps")) {
                this.res = this.lm.getLastKnownLocation("gps");
            } else if (preferNetwork && this.lm.isProviderEnabled("network")) {
                this.res = this.lm.getLastKnownLocation("network");
            }
        }
        return this.res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        if (msg.what == 0) {
            this.onRequest();
        } else if (this.gpsRequesting) {
            this.onGPSTimeout();
        } else if (this.networkRequesting) {
            this.lm.removeUpdates((LocationListener)this);
            LocationHelper locationHelper = this;
            synchronized (locationHelper) {
                this.notifyAll();
            }
            this.handler.getLooper().quit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRequest() {
        boolean preferNetwork;
        boolean preferGPS = this.gpsTimeoutSec != 0;
        boolean bl = preferNetwork = this.networkTimeoutSec != 0;
        if (preferGPS && this.lm.isProviderEnabled("gps")) {
            this.gpsRequesting = true;
            this.lm.requestLocationUpdates("gps", 1000L, 0.0f, (LocationListener)this);
            if (this.gpsTimeoutSec > 0) {
                this.handler.sendEmptyMessageDelayed(1, (long)(this.gpsTimeoutSec * 1000));
            }
        } else if (preferNetwork && this.lm.isProviderEnabled("network")) {
            this.networkRequesting = true;
            this.lm.requestLocationUpdates("network", 1000L, 0.0f, (LocationListener)this);
            if (this.networkTimeoutSec > 0) {
                this.handler.sendEmptyMessageDelayed(1, (long)(this.networkTimeoutSec * 1000));
            }
        } else {
            LocationHelper locationHelper = this;
            synchronized (locationHelper) {
                this.notifyAll();
            }
            this.handler.getLooper().quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onGPSTimeout() {
        boolean preferNetwork;
        this.lm.removeUpdates((LocationListener)this);
        this.gpsRequesting = false;
        boolean bl = preferNetwork = this.networkTimeoutSec != 0;
        if (preferNetwork && this.lm.isProviderEnabled("network")) {
            this.networkRequesting = true;
            this.lm.requestLocationUpdates("network", 1000L, 0.0f, (LocationListener)this);
            if (this.networkTimeoutSec > 0) {
                this.handler.sendEmptyMessageDelayed(1, (long)(this.networkTimeoutSec * 1000));
            }
        } else {
            LocationHelper locationHelper = this;
            synchronized (locationHelper) {
                this.notifyAll();
            }
            this.handler.getLooper().quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLocationChanged(Location location) {
        LocationHelper locationHelper = this;
        synchronized (locationHelper) {
            this.lm.removeUpdates((LocationListener)this);
            this.res = location;
            this.notifyAll();
        }
        this.handler.getLooper().quit();
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onProviderDisabled(String provider) {
    }
}

