/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddictionui.widget;

import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.tapsdk.antiaddiction.entities.response.IdentifyState;
import com.tapsdk.antiaddiction.models.IdentifyModel;
import com.tapsdk.antiaddiction.reactor.Subscriber;
import com.tapsdk.antiaddiction.reactor.Subscription;
import com.tapsdk.antiaddiction.reactor.rxandroid.schedulers.AndroidSchedulers;
import com.tapsdk.antiaddiction.reactor.schedulers.Schedulers;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;
import com.tapsdk.antiaddictionui.R;
import com.tapsdk.antiaddictionui.entities.response.TapTapIdentifyInfoResult;
import com.tapsdk.antiaddictionui.model.TapTapModel;
import com.tapsdk.antiaddictionui.utils.DataUtil;
import com.tapsdk.antiaddictionui.utils.TapSDKHelper;
import com.tapsdk.antiaddictionui.widget.HoloThemeHelper;
import com.tapsdk.antiaddictionui.widget.SafeDialogFragment;
import com.tds.common.entities.AccessToken;
import com.tds.common.oauth.AuthorizeModel;
import com.tds.common.oauth.exception.AuthorizeException;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class SandboxAuthIdentityFragment
extends SafeDialogFragment {
    public static final String TAG = "SandboxAuthIdentityFragment";
    private static final String REQUEST_ID_NOTIFY_IDENTITY = UUID.randomUUID().toString();
    private static final String REQUEST_ID_NOTIFY_ANTI_ADDITION = UUID.randomUUID().toString();
    private static final String encodeKey = "8RgdZs8pcHx5SWJ3";
    private static final String requestAction = "com.taptap.tds_to_sandbox.request";
    private static final String responseAction = "com.taptap.tds_to_sandbox.response";
    private Subscription fetchTapTapInfoSubscription;
    private Subscription identifyFromTapTapSubscription;
    private TapTapIdentifyInfoResult identifyInfoResult;
    private boolean useTapAntiAddiction = false;
    private String userIdentity;
    private String clientId;
    private SandboxAuthIdentityCallback authIdentifyCallback;
    private Animation mAnimation;
    private BroadcastReceiver tapResponseReceiver;
    private final TapTapModel tapTapModel = new TapTapModel();

    public static SandboxAuthIdentityFragment newInstance(String clientId, String userIdentity, SandboxAuthIdentityCallback callback) {
        SandboxAuthIdentityFragment sandboxAuthIdentityFragment = new SandboxAuthIdentityFragment();
        sandboxAuthIdentityFragment.authIdentifyCallback = callback;
        sandboxAuthIdentityFragment.clientId = clientId;
        sandboxAuthIdentityFragment.userIdentity = userIdentity;
        return sandboxAuthIdentityFragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.getDialog() == null || this.getActivity() == null) {
            return null;
        }
        return inflater.inflate(R.layout.antiaddiction_loading_toast, container, false);
    }

    @Override
    public void onStart() {
        super.onStart();
        Dialog dialog = this.getDialog();
        if (dialog == null || this.getActivity() == null || this.getActivity().getWindowManager() == null || dialog.getWindow() == null) {
            return;
        }
        HoloThemeHelper.fixHoloDialogBlueLine(dialog);
        dialog.getWindow().clearFlags(2);
        dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
        lp.width = -1;
        lp.height = -1;
        dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        if (this.getDialog() != null && this.getDialog().getWindow() != null) {
            Window window = this.getDialog().getWindow();
            View decorView = window.getDecorView();
            if (Build.VERSION.SDK_INT >= 28) {
                lp.layoutInDisplayCutoutMode = 1;
                window.setAttributes(lp);
            }
            decorView.setSystemUiVisibility(1024);
        }
        dialog.getWindow().setAttributes(lp);
        dialog.getWindow().setFlags(1024, 1024);
        dialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialogInterface, int i, KeyEvent keyEvent) {
                return i == 4;
            }
        });
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.getWindow().requestFeature(1);
        return dialog;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getDialog() != null && this.getDialog().getWindow() != null) {
            Window window = this.getDialog().getWindow();
            window.setFlags(1024, 1024);
            window.getDecorView().setPadding(0, 0, 0, 0);
        }
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.getDialog() == null || this.getActivity() == null) {
            return;
        }
        ImageView iv = (ImageView)view.findViewById(R.id.iv_toast_loading);
        FrameLayout fl = (FrameLayout)view.findViewById(R.id.fl_toast_loading);
        fl.setVisibility(0);
        this.mAnimation = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.antiaddiction_anim_loading);
        this.mAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        iv.setImageResource(R.drawable.antiaddiction_loading);
        iv.startAnimation(this.mAnimation);
        this.useTapAntiAddiction = this.checkUseTapAntiAddiction((Context)this.getActivity());
        AntiAddictionLogger.d((String)("set requestId = " + REQUEST_ID_NOTIFY_IDENTITY + " anti = " + REQUEST_ID_NOTIFY_ANTI_ADDITION));
        AntiAddictionLogger.d((String)("enter sandbox identity and useTapAnti = " + this.useTapAntiAddiction));
        this.registerTapApiChannel();
        this.callTapAuthAndIdentity();
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.getActivity() != null && this.tapResponseReceiver != null) {
            AntiAddictionLogger.d((String)"remove tap client receiver");
            this.getActivity().unregisterReceiver(this.tapResponseReceiver);
        }
    }

    private void callTapAuthAndIdentity() {
        JSONObject object = new JSONObject();
        try {
            object.put("timestamp", System.currentTimeMillis());
            object.put("packageName", (Object)this.getActivity().getPackageName());
            this.callTapApi("verifyRealName", REQUEST_ID_NOTIFY_IDENTITY, object.toString());
            AntiAddictionLogger.d((String)("call tap client verifyRealName data = " + object));
        }
        catch (JSONException e) {
            AntiAddictionLogger.e((String)("callTapAuthAndIdentity fail error = " + e.getMessage()));
        }
    }

    private void callTapAntiAddition() {
        JSONObject object = new JSONObject();
        try {
            object.put("timestamp", System.currentTimeMillis());
            object.put("packageName", (Object)this.getActivity().getPackageName());
            this.callTapApi("startupAntiAddiction", REQUEST_ID_NOTIFY_ANTI_ADDITION, object.toString());
            AntiAddictionLogger.d((String)("call tap client startupAntiAddiction data = " + object));
        }
        catch (JSONException e) {
            AntiAddictionLogger.e((String)("callTapAntiAddition fail error = " + e.getMessage()));
        }
    }

    private void fetchTapIdentity() {
        this.tapTapModel.getTapIdentifyToken(this.getActivity(), new AuthorizeModel.AuthorizationCallback(){

            public void onSuccess(AccessToken accessToken) {
                AntiAddictionLogger.d((String)("fetchTapIdentity success " + accessToken));
                if (accessToken != null) {
                    TapTapModel.accessToken = accessToken;
                    SandboxAuthIdentityFragment.this.fetchTapTapIdentifyInfo();
                } else {
                    SandboxAuthIdentityFragment.this.dismissAllowingStateLoss();
                    if (SandboxAuthIdentityFragment.this.authIdentifyCallback != null) {
                        SandboxAuthIdentityFragment.this.authIdentifyCallback.onRealNameFail(new RuntimeException("invalid token"));
                    }
                }
            }

            public void onCancel() {
                AntiAddictionLogger.d((String)"fetchTapIdentity cancel");
                SandboxAuthIdentityFragment.this.dismissAllowingStateLoss();
                if (SandboxAuthIdentityFragment.this.authIdentifyCallback != null) {
                    SandboxAuthIdentityFragment.this.authIdentifyCallback.onRealNameFail(new RuntimeException("auth cancel"));
                }
            }

            public void onError(AuthorizeException e) {
                e.printStackTrace();
                AntiAddictionLogger.d((String)("fetchTapIdentity error " + e.getMessage()));
                SandboxAuthIdentityFragment.this.dismissAllowingStateLoss();
                if (SandboxAuthIdentityFragment.this.authIdentifyCallback != null) {
                    SandboxAuthIdentityFragment.this.authIdentifyCallback.onRealNameFail((Throwable)e);
                }
            }
        });
    }

    public void dismiss() {
        try {
            super.dismiss();
            if (this.mAnimation != null) {
                this.mAnimation.cancel();
                this.mAnimation = null;
            }
        }
        catch (Exception e) {
            AntiAddictionLogger.e((String)e.getMessage());
        }
    }

    public void dismissAllowingStateLoss() {
        super.dismissAllowingStateLoss();
        try {
            if (this.mAnimation != null) {
                this.mAnimation.cancel();
                this.mAnimation = null;
            }
        }
        catch (Exception e) {
            AntiAddictionLogger.e((String)e.getMessage());
        }
    }

    private void fetchTapTapIdentifyInfo() {
        AntiAddictionLogger.d((String)(" fetchTapTapIdentifyInfo clientId = " + this.clientId));
        if (this.fetchTapTapInfoSubscription != null && !this.fetchTapTapInfoSubscription.isUnsubscribed()) {
            return;
        }
        this.fetchTapTapInfoSubscription = this.tapTapModel.fetchTapTapIdentifyInfo(this.clientId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(tapTapIdentifyInfoResult -> {
            AntiAddictionLogger.d((String)"fetchTapTapIdentifyInfo success");
            this.identifyInfoResult = tapTapIdentifyInfoResult;
            if (this.checkIdentifyInfoValid((TapTapIdentifyInfoResult)tapTapIdentifyInfoResult)) {
                this.uploadTapTapAuthorizationInfo();
            } else {
                AntiAddictionLogger.d((String)"fetchTapTapIdentifyInfo success but invalid result");
                this.dismissAllowingStateLoss();
                if (this.authIdentifyCallback != null) {
                    this.authIdentifyCallback.onUploadIdentifyFail(new RuntimeException("invalid identity code"));
                }
            }
        }, throwable -> {
            throwable.printStackTrace();
            AntiAddictionLogger.d((String)("fetchTapTapIdentifyInfo fail error = " + throwable.getMessage()));
            this.dismissAllowingStateLoss();
            if (this.authIdentifyCallback != null) {
                this.authIdentifyCallback.onUploadIdentifyFail((Throwable)throwable);
            }
        });
    }

    private void uploadTapTapAuthorizationInfo() {
        String accessTokenJson;
        if (this.identifyInfoResult == null) {
            return;
        }
        if (this.identifyFromTapTapSubscription != null && !this.identifyFromTapTapSubscription.isUnsubscribed()) {
            this.identifyFromTapTapSubscription.unsubscribe();
        }
        int fromTapTap = TextUtils.isEmpty((CharSequence)(accessTokenJson = TapSDKHelper.getTapTokenJSONStr())) ? 0 : 1;
        IdentifyModel identifyModel = new IdentifyModel();
        this.identifyFromTapTapSubscription = identifyModel.identifyUserFromTapTap(this.clientId, this.userIdentity, this.identifyInfoResult.code, fromTapTap).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<IdentifyState>(){

            public void onCompleted() {
            }

            public void onError(Throwable throwable) {
                throwable.printStackTrace();
                AntiAddictionLogger.d((String)("uploadTapTapAuthorizationInfo fail " + throwable.getMessage()));
                SandboxAuthIdentityFragment.this.dismissAllowingStateLoss();
                if (SandboxAuthIdentityFragment.this.authIdentifyCallback != null) {
                    SandboxAuthIdentityFragment.this.authIdentifyCallback.onUploadIdentifyFail(throwable);
                }
            }

            public void onNext(IdentifyState identifyState) {
                AntiAddictionLogger.d((String)"uploadTapTapAuthorizationInfo success ");
                SandboxAuthIdentityFragment.this.processIdentifyResult(identifyState);
            }
        });
    }

    private void processIdentifyResult(IdentifyState identifyState) {
        if (identifyState == null) {
            return;
        }
        this.dismissAllowingStateLoss();
        AntiAddictionLogger.d((String)("processIdentifyResult identity = " + identifyState));
        if (identifyState.identifyState == 0) {
            if (this.authIdentifyCallback != null) {
                this.authIdentifyCallback.onRealNameSuccess(identifyState);
            }
        } else if (this.authIdentifyCallback != null) {
            this.authIdentifyCallback.onUploadIdentifyFail(new RuntimeException("invalid identity code"));
        }
    }

    private void callTapApi(String apiName, String requestId, String jsonExtra) {
        Intent intent = new Intent(requestAction);
        intent.putExtra("api", apiName);
        intent.putExtra("packageName", this.getActivity().getPackageName());
        intent.putExtra("requestId", requestId);
        if (!TextUtils.isEmpty((CharSequence)jsonExtra)) {
            intent.putExtra("data", DataUtil.encrypt(jsonExtra, encodeKey));
        }
        this.getActivity().sendBroadcast(intent);
    }

    private void registerTapApiChannel() {
        if (this.tapResponseReceiver != null) {
            return;
        }
        this.tapResponseReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                try {
                    String pkgName = intent.getStringExtra("packageName");
                    if (SandboxAuthIdentityFragment.this.getActivity().getPackageName().equals(pkgName)) {
                        String responseId = intent.getStringExtra("responseId");
                        String data = intent.getStringExtra("data");
                        JSONObject object = SandboxAuthIdentityFragment.this.parseTapResponseData(data);
                        AntiAddictionLogger.d((String)("receive tap client response id = " + responseId + " data = " + object));
                        if (object != null && Math.abs(object.getLong("timestamp") - System.currentTimeMillis()) < 30000L) {
                            if (REQUEST_ID_NOTIFY_IDENTITY.equals(responseId)) {
                                AntiAddictionLogger.d((String)(" receive tap client identity data and useTapAntiAddiction = " + SandboxAuthIdentityFragment.this.useTapAntiAddiction));
                                if (!SandboxAuthIdentityFragment.this.useTapAntiAddiction) {
                                    SandboxAuthIdentityFragment.this.fetchTapIdentity();
                                } else {
                                    SandboxAuthIdentityFragment.this.callTapAntiAddition();
                                }
                            } else if (REQUEST_ID_NOTIFY_ANTI_ADDITION.equals(responseId)) {
                                boolean needStrict = false;
                                boolean isAdult = object.getBoolean("isAdult");
                                if (!isAdult) {
                                    needStrict = object.getInt("remainTime") <= 0;
                                }
                                AntiAddictionLogger.d((String)(" receive tap client antiAddition data and needStrict = " + needStrict));
                                SandboxAuthIdentityFragment.this.dismissAllowingStateLoss();
                                if (SandboxAuthIdentityFragment.this.authIdentifyCallback != null) {
                                    SandboxAuthIdentityFragment.this.authIdentifyCallback.onUseTapAntiAddition(needStrict);
                                }
                            }
                        } else {
                            AntiAddictionLogger.d((String)"receive tap client response invalid data or timestamp timeout");
                        }
                    }
                }
                catch (Exception e) {
                    AntiAddictionLogger.e((String)("receive client data  but handle data fail " + e.getMessage()));
                }
            }
        };
        AntiAddictionLogger.d((String)"register tap client receiver");
        IntentFilter intentFilter = new IntentFilter(responseAction);
        this.getActivity().registerReceiver(this.tapResponseReceiver, intentFilter);
    }

    private JSONObject parseTapResponseData(String data) {
        if (!TextUtils.isEmpty((CharSequence)data)) {
            try {
                AntiAddictionLogger.d((String)("get tap client response data = " + data));
                String validData = DataUtil.decrypt(data, encodeKey);
                if (validData != null) {
                    return new JSONObject(validData);
                }
            }
            catch (Exception e) {
                AntiAddictionLogger.e((String)("get tap client response = " + data + " but handle data fail " + e.getMessage()));
            }
        } else {
            AntiAddictionLogger.d((String)"get tap client response data invalid ");
        }
        return null;
    }

    private boolean checkIdentifyInfoValid(TapTapIdentifyInfoResult tapTapIdentifyInfoResult) {
        return tapTapIdentifyInfoResult != null && !TextUtils.isEmpty((CharSequence)tapTapIdentifyInfoResult.code);
    }

    private boolean checkUseTapAntiAddiction(Context context) {
        return !TapTapModel.checkGameLicense(context) && TapTapModel.checkTapSupportAntiAddiction(context);
    }

    public static interface SandboxAuthIdentityCallback {
        public void onRealNameSuccess(IdentifyState var1);

        public void onRealNameFail(Throwable var1);

        public void onUploadIdentifyFail(Throwable var1);

        public void onUseTapAntiAddition(boolean var1);
    }
}

