/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.tracker;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.tds.common.net.TdsApiClient;
import com.tds.common.net.TdsHttp;
import com.tds.common.reactor.RxBus;
import com.tds.common.tracker.TdsTrackerConfig;
import com.tds.common.tracker.entities.LogBean;
import com.tds.common.tracker.entities.TrackMessage;
import com.tds.common.tracker.entities.TrackMessageList;
import com.tds.common.tracker.entities.TwoTuple;
import com.tds.common.tracker.model.TrackEventUpdateAction;
import com.tds.common.utils.CommonUtils;
import com.tds.common.utils.DeviceUtils;
import com.tds.common.utils.FileUtil;
import com.tds.common.utils.GUIDHelper;
import com.tds.common.utils.ListUtil;
import com.tds.common.utils.Lz4Util;
import com.tds.common.utils.ParcelableUtil;
import com.tds.common.utils.SP;
import com.tds.common.utils.TimeUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class TdsTrackerHandler
extends Handler {
    public static final String TAG = "TdsTrackerHandler";
    private static final String TOPIC_PREFERENCE = "topic_preference";
    private static final String SUFFIX_TOPIC_COUNT_PREFERENCE = "_topic_count_preference";
    private static final String SUFFIX_TOPIC_DATA_SIZE_PREFERENCE = "_topic_data_size_preference";
    private static final long DEFAULT_SAVE_TIME_INTERVAL = 500L;
    public static final int DELAY_MILLIS = 5000;
    public static final int MESSAGES_EXCEED = 2000;
    private static final int LOG_READ_FROM_CACHE = 0;
    private static final int LOG_SEND = 1;
    private static final int LOG_DELAY = 2;
    private static final int SAVE_UNSENT_LOGS = 3;
    private static final Set<String> unReadCacheSet = new HashSet<String>();
    private long lastSaveTime = -1L;
    private final SP mSp;
    private boolean readUnSendData = false;
    TdsApiClient tdsApiClient;
    Map<String, CopyOnWriteArrayList<TrackMessage>> messageListMap = new ConcurrentHashMap<String, CopyOnWriteArrayList<TrackMessage>>();

    public TdsTrackerHandler(Looper looper) {
        super(looper);
        TdsHttp.Client client = TdsHttp.newClientBuilder().trustAllCerts(false).build();
        this.tdsApiClient = new TdsApiClient.Builder().baseUrl("").tdsClient(client).build();
        this.mSp = SP.getSP(TAG);
        this.readUnSendData = false;
        this.sendReadFromCacheMessage();
    }

    public void sendReadFromCacheMessage() {
        Message msg = Message.obtain((Handler)this, (int)0);
        this.sendMessage(msg);
    }

    public void sendTrackMessage(TdsTrackerConfig tdsTrackerConfig, Map<String, String> logContentsMap) {
        TrackMessage trackMessage = new TrackMessage(tdsTrackerConfig, logContentsMap, TimeUtil.getUnixTimestamp(), this.makeCommonParams(tdsTrackerConfig));
        Message msg = Message.obtain((Handler)this, (int)1, (Object)trackMessage);
        this.sendMessage(msg);
    }

    public void sendLogMessageDelayed() {
        this.removeMessages(2);
        Message msg = Message.obtain((Handler)this, (int)2);
        this.sendMessageDelayed(msg, 5000L);
    }

    public void sendSaveLogMessage(TdsTrackerConfig tdsTrackerConfig) {
        this.removeMessages(3);
        Message msg = Message.obtain((Handler)this, (int)3);
        msg.obj = tdsTrackerConfig;
        this.sendMessage(msg);
    }

    public void sendSaveLogMessageDelay(TdsTrackerConfig tdsTrackerConfig, long delay) {
        this.removeMessages(3);
        Message msg = Message.obtain((Handler)this, (int)3);
        msg.obj = tdsTrackerConfig;
        this.sendMessageDelayed(msg, delay);
    }

    public Map<String, String> makeCommonParams(TdsTrackerConfig tdsTrackerConfig) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("sdk_version", String.valueOf(tdsTrackerConfig.sdkVersionCode));
        result.put("sdk_version_name", String.valueOf(tdsTrackerConfig.sdkVersionName));
        result.put("device_id", GUIDHelper.INSTANCE.getUID());
        result.put("t_log_id", UUID.randomUUID().toString());
        result.put("version", "1.0.1");
        result.put("dv", DeviceUtils.getManufacturer());
        result.put("md", DeviceUtils.getModel());
        result.put("cpu", DeviceUtils.getCpuInfo());
        result.put("app_package_name", tdsTrackerConfig.appPackageName);
        result.put("app_version", tdsTrackerConfig.appVersion);
        result.put("ram", tdsTrackerConfig.ramSize);
        result.put("rom", tdsTrackerConfig.romSize);
        result.put("network_type", tdsTrackerConfig.networkType);
        result.put("mobile_type", tdsTrackerConfig.mobileType);
        result.put("os", DeviceUtils.getPlatform());
        result.put("sv", DeviceUtils.getOSVersion());
        return result;
    }

    private boolean hasUnSendTrackMessage() {
        for (Map.Entry<String, CopyOnWriteArrayList<TrackMessage>> entry : this.messageListMap.entrySet()) {
            if (entry.getValue().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean checkShouldUpload() {
        return this.hasUnSendTrackMessage();
    }

    private boolean checkAbnormal(List<TrackMessage> messageList) {
        boolean isAbnormal;
        boolean bl = isAbnormal = messageList != null && messageList.size() >= 2000;
        if (isAbnormal) {
            TdsTrackerConfig tdsTrackerConfig = messageList.get((int)0).tdsTrackerConfig;
            messageList.clear();
            this.saveUnSendTrackMessageToFile(tdsTrackerConfig);
            RxBus.getInstance().send(new TwoTuple<String, String>(tdsTrackerConfig.topic, String.valueOf(0)));
        }
        return isAbnormal;
    }

    public void handleMessage(Message msg) {
        Log.i((String)TAG, (String)"------handleMessage------");
        try {
            switch (msg.what) {
                case 0: {
                    if (this.readUnSendData) break;
                    this.readUnSendTrackMessageFromCache();
                    this.readUnSendData = true;
                    break;
                }
                case 1: {
                    Log.i((String)TAG, (String)"LOG_SEND");
                    if (!(msg.obj instanceof TrackMessage)) {
                        return;
                    }
                    TrackMessage logMessage = (TrackMessage)msg.obj;
                    RxBus.getInstance().send(new TrackEventUpdateAction(new TwoTuple<String, String>(logMessage.tdsTrackerConfig.topic, logMessage.logContentsMap.get("tds_user_id"))));
                    unReadCacheSet.add(logMessage.tdsTrackerConfig.cachePath);
                    this.doUploadLog(logMessage);
                    this.sendSaveLogMessage(logMessage.tdsTrackerConfig);
                    break;
                }
                case 2: {
                    Log.i((String)TAG, (String)"LOG_DELAY");
                    this.doUploadLog();
                    break;
                }
                case 3: {
                    long current = SystemClock.uptimeMillis();
                    if (this.lastSaveTime == -1L || current - this.lastSaveTime > 500L) {
                        this.saveUnSendTrackMessageToFile((TdsTrackerConfig)msg.obj);
                        this.lastSaveTime = current;
                        break;
                    }
                    this.sendSaveLogMessageDelay((TdsTrackerConfig)msg.obj, 500L);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readUnSendTrackMessageFromCache() {
        Log.i((String)TAG, (String)"-------readUnSendTrackMessageFromCache-------start");
        Set<String> topicCaches = this.mSp.getStringSet(TOPIC_PREFERENCE, new HashSet<String>());
        for (String cachePath : topicCaches) {
            try {
                Log.i((String)TAG, (String)("cachePath:" + cachePath));
                String topic = cachePath.substring(cachePath.lastIndexOf("/")).substring(1);
                Log.i((String)TAG, (String)("topic:" + topic));
                int sourceLength = this.mSp.getInt(topic + SUFFIX_TOPIC_DATA_SIZE_PREFERENCE, 0);
                Log.i((String)TAG, (String)("topic:" + sourceLength));
                byte[] unSendData = Lz4Util.decompressorByte(FileUtil.returnFileByte(cachePath), sourceLength);
                List<TrackMessage> unSendtrackMessageList = ParcelableUtil.unmarshall((byte[])unSendData, TrackMessageList.CREATOR).trackMessageList;
                Log.i((String)TAG, (String)("unSendtrackMessageList size:" + unSendtrackMessageList.size()));
                if (ListUtil.isEmpty(unSendtrackMessageList)) {
                    unSendtrackMessageList = new ArrayList<TrackMessage>();
                }
                for (TrackMessage trackMessage : unSendtrackMessageList) {
                    if (trackMessage == null || trackMessage.tdsTrackerConfig == null || TextUtils.isEmpty((CharSequence)trackMessage.tdsTrackerConfig.topic)) continue;
                    CopyOnWriteArrayList<TrackMessage> trackMessageList = this.messageListMap.get(trackMessage.tdsTrackerConfig.topic);
                    if (trackMessageList == null) {
                        trackMessageList = new CopyOnWriteArrayList();
                        this.messageListMap.put(trackMessage.tdsTrackerConfig.topic, trackMessageList);
                    }
                    trackMessageList.add(trackMessage);
                }
                RxBus.getInstance().send(new TwoTuple<String, String>(topic, String.valueOf(unSendtrackMessageList.size())));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.checkShouldUpload()) {
            this.doUploadLog();
        }
        Log.i((String)TAG, (String)"-------readUnSendTrackMessageFromCache-------end");
    }

    private void saveUnSendTrackMessageToFile(TdsTrackerConfig tdsTrackerConfig) {
        Log.i((String)TAG, (String)"-------saveUnSendTrackMessageToFile-------start");
        long startTime = System.currentTimeMillis();
        String filePath = tdsTrackerConfig.cachePath;
        TwoTuple<Integer, byte[]> twoTuple = this.getUnSendByteData(tdsTrackerConfig.topic);
        int size = (Integer)twoTuple.paramA;
        byte[] unSendData = (byte[])twoTuple.paramB;
        Set<String> topicSet = this.mSp.getStringSet(TOPIC_PREFERENCE, new HashSet<String>());
        Log.i((String)TAG, (String)("topic:" + tdsTrackerConfig.topic));
        if (unSendData == null) {
            Log.i((String)TAG, (String)"no unsave data");
            topicSet.remove(tdsTrackerConfig.cachePath);
            this.mSp.putInt(tdsTrackerConfig.topic + SUFFIX_TOPIC_DATA_SIZE_PREFERENCE, 0);
            this.mSp.putInt(tdsTrackerConfig.topic + SUFFIX_TOPIC_COUNT_PREFERENCE, 0);
            FileUtil.deleteFile(filePath);
        } else {
            Log.i((String)TAG, (String)"save data");
            int originSize = unSendData.length;
            this.mSp.putInt(tdsTrackerConfig.topic + SUFFIX_TOPIC_DATA_SIZE_PREFERENCE, originSize);
            this.mSp.putInt(tdsTrackerConfig.topic + SUFFIX_TOPIC_COUNT_PREFERENCE, size);
            topicSet.add(tdsTrackerConfig.cachePath);
            FileUtil.createFile(Lz4Util.compressedByte(unSendData), filePath);
        }
        this.mSp.putStringSet(TOPIC_PREFERENCE, topicSet);
        long spentTime = System.currentTimeMillis() - startTime;
        Log.i((String)TAG, (String)("-------saveUnSendTrackMessageToFile-------end:" + spentTime + "ms"));
    }

    private TwoTuple<Integer, byte[]> getUnSendByteData(String topic) {
        Log.i((String)TAG, (String)"-------getUnSendByteData-------start");
        byte[] data = null;
        List trackMessageList = this.messageListMap.get(topic);
        if (trackMessageList != null && trackMessageList.size() > 0) {
            try {
                data = ParcelableUtil.marshall(new TrackMessageList(trackMessageList));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int size = trackMessageList != null ? trackMessageList.size() : 0;
        Log.i((String)TAG, (String)"-------getUnSendByteData-------end");
        return new TwoTuple<Integer, byte[]>(size, data);
    }

    @SuppressLint(value={"DefaultLocale"})
    public void doUploadLog(TrackMessage trackMessage) {
        List<TrackMessage> dealTrackMessageList;
        boolean success;
        CopyOnWriteArrayList<TrackMessage> trackMessagesList;
        Log.i((String)TAG, (String)"-------doUploadLog(TrackMessage trackMessage)-------start");
        TdsTrackerConfig tdsTrackerConfig = trackMessage.tdsTrackerConfig;
        if (this.messageListMap.containsKey(tdsTrackerConfig.topic)) {
            trackMessagesList = this.messageListMap.get(tdsTrackerConfig.topic);
        } else {
            trackMessagesList = new CopyOnWriteArrayList();
            this.messageListMap.put(tdsTrackerConfig.topic, trackMessagesList);
        }
        if (trackMessagesList == null || this.checkAbnormal(trackMessagesList)) {
            return;
        }
        trackMessagesList.add(trackMessage);
        RxBus.getInstance().send(new TwoTuple<String, String>(tdsTrackerConfig.topic, String.valueOf(trackMessagesList.size())));
        this.mSp.putInt(tdsTrackerConfig.topic + SUFFIX_TOPIC_COUNT_PREFERENCE, trackMessagesList.size());
        while (trackMessagesList.size() >= tdsTrackerConfig.groupSize && (success = this.sendTrackData(dealTrackMessageList = trackMessagesList.subList(0, tdsTrackerConfig.groupSize)))) {
            trackMessagesList.removeAll(dealTrackMessageList);
            this.saveUnSendTrackMessageToFile(tdsTrackerConfig);
            RxBus.getInstance().send(new TwoTuple<String, String>(tdsTrackerConfig.topic, String.valueOf(trackMessagesList.size())));
        }
        if (this.checkShouldUpload()) {
            this.sendLogMessageDelayed();
        }
        Log.i((String)TAG, (String)"-------doUploadLog(TrackMessage trackMessage)-------end");
    }

    @SuppressLint(value={"DefaultLocale"})
    private boolean sendTrackData(List<TrackMessage> trackMessageList) {
        TdsTrackerConfig tdsTrackerConfig = trackMessageList.get((int)0).tdsTrackerConfig;
        try {
            byte[] logBufferData = this.makeProtoBufferData(trackMessageList);
            byte[] lz4LogBufferData = Lz4Util.compressedByte(logBufferData);
            HashMap<String, String> headers = new HashMap<String, String>();
            String md5Buf = CommonUtils.getMD5(lz4LogBufferData).toUpperCase();
            String currentTime = TimeUtil.getUnixTimestampStr();
            String sigContent = String.format("POST\n%s\napplication/x-protobuf\nx-log-apiversion:0.6.0\nx-log-bodyrawsize:%d\nx-log-compresstype:lz4\nx-log-signaturemethod:hmac-sha1\nx-log-timestamp:%s\n/putrecords/%s/%s", md5Buf, logBufferData.length, currentTime, tdsTrackerConfig.project, tdsTrackerConfig.logStore);
            String signBase64 = "";
            try {
                signBase64 = this.signatureToBase64(sigContent, tdsTrackerConfig.accessKeySecret);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            String headerSig = String.format("LOG %s:%s", tdsTrackerConfig.accessKeyId, signBase64);
            headers.put("x-log-timestamp", currentTime);
            headers.put("Content-MD5", md5Buf);
            headers.put("Content-Length", String.valueOf(lz4LogBufferData.length));
            headers.put("x-log-bodyrawsize", String.valueOf(logBufferData.length));
            headers.put("Authorization", headerSig);
            headers.put("Content-Type", "application/x-protobuf");
            headers.put("x-log-apiversion", "0.6.0");
            headers.put("x-log-compresstype", "lz4");
            headers.put("x-log-signaturemethod", "hmac-sha1");
            headers.put("Host", tdsTrackerConfig.endPoint);
            headers.put("accept", "*/*");
            headers.put("Accept-Encoding", "identity");
            return this.tdsApiClient.postProtoBuff("https://" + tdsTrackerConfig.endPoint + "/putrecords/" + tdsTrackerConfig.project + "/" + tdsTrackerConfig.logStore, null, headers, lz4LogBufferData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void doUploadLog() {
        Log.i((String)TAG, (String)"-------doUploadLog()-------start");
        for (Map.Entry<String, CopyOnWriteArrayList<TrackMessage>> entry : this.messageListMap.entrySet()) {
            if (entry.getValue() == null) continue;
            List trackMessagesList = entry.getValue();
            while (trackMessagesList.size() > 0) {
                TdsTrackerConfig logConfig = ((TrackMessage)trackMessagesList.get((int)0)).tdsTrackerConfig;
                int dealSize = Math.min(trackMessagesList.size(), logConfig.groupSize);
                try {
                    if (this.checkAbnormal(trackMessagesList)) {
                        return;
                    }
                    List<TrackMessage> dealTrackMessageList = trackMessagesList.subList(0, dealSize);
                    boolean success = this.sendTrackData(dealTrackMessageList);
                    if (success) {
                        trackMessagesList.removeAll(dealTrackMessageList);
                        this.saveUnSendTrackMessageToFile(logConfig);
                        RxBus.getInstance().send(new TwoTuple<String, String>(logConfig.topic, String.valueOf(trackMessagesList.size())));
                        continue;
                    }
                    this.sendLogMessageDelayed();
                    return;
                }
                catch (Exception e) {
                    this.sendLogMessageDelayed();
                    e.printStackTrace();
                    return;
                }
            }
        }
        Log.i((String)TAG, (String)"-------doUploadLog()-------end");
    }

    private String signatureToBase64(String sigContent, String accessKeySecret) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance("HmacSHA1");
        SecretKeySpec signingKey = new SecretKeySpec(accessKeySecret.getBytes(), "HmacSHA1");
        mac.init(signingKey);
        byte[] signatureBytes = Base64.encode((byte[])mac.doFinal(sigContent.getBytes(StandardCharsets.UTF_8)), (int)2);
        return new String(signatureBytes, StandardCharsets.UTF_8);
    }

    private byte[] makeProtoBufferData(List<TrackMessage> trackMessageList) {
        return this.makeLogGroup(trackMessageList).toByteArray();
    }

    private LogBean.LogGroup makeLogGroup(List<TrackMessage> trackMessageList) {
        LogBean.LogGroup.Builder builder = LogBean.LogGroup.newBuilder().setTopic(trackMessageList.get((int)0).tdsTrackerConfig.topic);
        builder.addAllLogs(this.makeLogs(trackMessageList));
        return (LogBean.LogGroup)builder.build();
    }

    private List<LogBean.Log> makeLogs(List<TrackMessage> trackMessageList) {
        ArrayList<LogBean.Log> result = new ArrayList<LogBean.Log>();
        for (TrackMessage trackMessage : trackMessageList) {
            Log.d((String)"trackerData", (String)("contents:" + trackMessage.logContentsMap + "\n common params" + trackMessage.logCommonParams + "\n"));
            LogBean.Log log = (LogBean.Log)LogBean.Log.newBuilder().setTime((int)trackMessage.createTime).addAllContents(this.makeLogContents(trackMessage.logContentsMap, trackMessage.logCommonParams)).build();
            result.add(log);
        }
        return result;
    }

    private List<LogBean.LogContent> makeLogContents(Map<String, String> logContentsMap, Map<String, String> commonParamsMap) {
        ArrayList<LogBean.LogContent> result = new ArrayList<LogBean.LogContent>();
        for (Map.Entry<String, String> entry : logContentsMap.entrySet()) {
            result.add((LogBean.LogContent)LogBean.LogContent.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        for (Map.Entry<String, String> entry : commonParamsMap.entrySet()) {
            result.add((LogBean.LogContent)LogBean.LogContent.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        return result;
    }
}

