/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.websocket.extensions;

import com.tds.common.websocket.exceptions.InvalidDataException;
import com.tds.common.websocket.exceptions.InvalidFrameException;
import com.tds.common.websocket.extensions.DefaultExtension;
import com.tds.common.websocket.framing.ControlFrame;
import com.tds.common.websocket.framing.DataFrame;
import com.tds.common.websocket.framing.Framedata;

public abstract class CompressionExtension
extends DefaultExtension {
    @Override
    public void isFrameValid(Framedata inputFrame) throws InvalidDataException {
        if (inputFrame instanceof DataFrame && (inputFrame.isRSV2() || inputFrame.isRSV3())) {
            throw new InvalidFrameException("bad rsv RSV1: " + inputFrame.isRSV1() + " RSV2: " + inputFrame.isRSV2() + " RSV3: " + inputFrame.isRSV3());
        }
        if (inputFrame instanceof ControlFrame && (inputFrame.isRSV1() || inputFrame.isRSV2() || inputFrame.isRSV3())) {
            throw new InvalidFrameException("bad rsv RSV1: " + inputFrame.isRSV1() + " RSV2: " + inputFrame.isRSV2() + " RSV3: " + inputFrame.isRSV3());
        }
    }
}

