/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.widgets.image;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import com.tds.common.io.IoUtil;
import com.tds.common.net.TdsHttp;
import com.tds.common.reactor.Observable;
import com.tds.common.reactor.Subscriber;
import com.tds.common.reactor.Subscription;
import com.tds.common.reactor.rxandroid.schedulers.AndroidSchedulers;
import com.tds.common.reactor.schedulers.Schedulers;
import com.tds.common.utils.UIUtils;
import com.tds.common.widgets.image.DiskCache;
import com.tds.common.widgets.image.ImageTarget;
import com.tds.common.widgets.image.ImageUtil;
import com.tds.common.widgets.image.TdsImage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class LoadBuilder {
    final TdsImage tdsImage;
    final Uri uri;
    final int resId;
    int placeholderResId = 0;
    Drawable placeholderDrawable;
    int errorRedId = 0;
    Drawable errorDrawable;
    int roundCornerRadius = 0;
    int width = 0;
    int height = 0;
    ImageView.ScaleType scaleType = ImageView.ScaleType.CENTER_INSIDE;
    boolean circle = false;

    LoadBuilder(TdsImage tdsImage, Uri uri, int resId) {
        this.tdsImage = tdsImage;
        this.uri = uri;
        this.resId = resId;
    }

    public LoadBuilder placeholder(int placeholderResId) {
        this.placeholderResId = placeholderResId;
        return this;
    }

    public LoadBuilder placeholder(Drawable placeholderDrawable) {
        this.placeholderDrawable = placeholderDrawable;
        return this;
    }

    public LoadBuilder error(int errorResId) {
        this.errorRedId = errorResId;
        return this;
    }

    public LoadBuilder error(Drawable errorDrawable) {
        this.errorDrawable = errorDrawable;
        return this;
    }

    public LoadBuilder roundCornerPx(int radiusPx) {
        this.roundCornerRadius = Math.max(0, radiusPx);
        return this;
    }

    public LoadBuilder roundCornerDp(float radiusDp) {
        return this.roundCornerPx(UIUtils.dp2px(this.tdsImage.context, radiusDp));
    }

    public LoadBuilder setCircle(boolean circle) {
        this.circle = true;
        return this;
    }

    public LoadBuilder scale(int width, int height, ImageView.ScaleType scaleType) {
        this.width = width;
        this.height = height;
        this.scaleType = scaleType;
        return this;
    }

    private String getKey() {
        if (this.uri != null) {
            if (this.width * this.height == 0) {
                return this.getMd5(this.uri.toString());
            }
            String taretUrl = this.uri + "#W" + this.width + "#H" + this.height + "#S" + this.scaleType.ordinal();
            if (this.circle) {
                taretUrl = taretUrl + "#C";
            } else if (this.roundCornerRadius > 0) {
                taretUrl = taretUrl + "#R" + this.roundCornerRadius;
            }
            return this.getMd5(taretUrl);
        }
        return this.getMd5(String.valueOf(this.resId));
    }

    private String getDiskKey() {
        if (this.uri != null) {
            return this.getMd5(this.uri.toString());
        }
        return this.getMd5(String.valueOf(this.resId));
    }

    private String getMd5(String in) {
        return ImageUtil.getMd5(in);
    }

    public void into(ImageView imageView) {
        ImageUtil.checkMain();
        if (this.uri == null && this.resId == 0) {
            if (this.errorRedId != 0) {
                imageView.setImageResource(this.errorRedId);
            } else if (this.errorDrawable != null) {
                imageView.setImageDrawable(this.errorDrawable);
            }
            return;
        }
        this.tdsImage.cancelRequest(imageView);
        Bitmap bitmap = this.tdsImage.memCache.get(this.getKey());
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
            return;
        }
        if (this.placeholderResId != 0) {
            imageView.setImageResource(this.placeholderResId);
        } else if (this.placeholderDrawable != null) {
            imageView.setImageDrawable(this.placeholderDrawable);
        }
        Subscription subscription = this.loadImageInto(imageView);
        this.tdsImage.enqueue(imageView, subscription);
    }

    public void into(ImageTarget imageTarget) {
        ImageUtil.checkMain();
        if (imageTarget == null) {
            return;
        }
        if (this.uri == null && this.resId == 0) {
            imageTarget.onFailure(new Exception("uri == null && resId == 0"));
            return;
        }
        this.tdsImage.cancelRequest(imageTarget);
        Bitmap bitmap = this.tdsImage.memCache.get(this.getKey());
        if (bitmap != null) {
            imageTarget.onSuccess(bitmap);
            return;
        }
        Subscription subscription = this.loadImageInto(imageTarget);
        this.tdsImage.enqueue(imageTarget, subscription);
    }

    private Subscription loadImageInto(ImageView imageView) {
        final WeakReference<ImageView> view = new WeakReference<ImageView>(imageView);
        return this.loadImageInto(new ImageTarget(){

            @Override
            public void onSuccess(Bitmap bitmap) {
                ImageView iv = (ImageView)view.get();
                if (iv != null) {
                    iv.setImageBitmap(bitmap);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                ImageView iv = (ImageView)view.get();
                if (iv != null) {
                    if (LoadBuilder.this.errorRedId != 0) {
                        iv.setImageResource(LoadBuilder.this.errorRedId);
                    } else if (LoadBuilder.this.errorDrawable != null) {
                        iv.setImageDrawable(LoadBuilder.this.errorDrawable);
                    }
                }
            }
        });
    }

    private Subscription loadImageInto(final ImageTarget target) {
        return Observable.create(new Observable.OnSubscribe<Bitmap>(){

            @Override
            public void call(Subscriber<? super Bitmap> subscriber) {
                block3: {
                    try {
                        Bitmap bitmap = this.loadBitmap();
                        if (!subscriber.isUnsubscribed()) {
                            bitmap = this.postProcess(bitmap);
                            subscriber.onNext((Bitmap)bitmap);
                            subscriber.onCompleted();
                        }
                    }
                    catch (IOException e) {
                        if (subscriber.isUnsubscribed()) break block3;
                        subscriber.onError(e);
                    }
                }
            }

            private Bitmap postProcess(Bitmap bitmap) {
                if (LoadBuilder.this.circle) {
                    Bitmap result = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                    Paint paint = new Paint();
                    paint.setAntiAlias(true);
                    paint.setShader((Shader)shader);
                    Canvas canvas = new Canvas(result);
                    canvas.drawColor(0);
                    canvas.drawCircle((float)result.getWidth() * 1.0f / 2.0f, (float)result.getWidth() * 1.0f / 2.0f, (float)result.getWidth() * 1.0f / 2.0f, paint);
                    canvas.setBitmap(null);
                    LoadBuilder.this.tdsImage.memCache.put(LoadBuilder.this.getKey(), result);
                    bitmap.recycle();
                    return result;
                }
                if (LoadBuilder.this.roundCornerRadius > 0) {
                    Bitmap result = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                    Paint paint = new Paint();
                    paint.setAntiAlias(true);
                    paint.setShader((Shader)shader);
                    Canvas canvas = new Canvas(result);
                    canvas.drawColor(0);
                    canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)result.getWidth(), (float)result.getHeight()), (float)LoadBuilder.this.roundCornerRadius, (float)LoadBuilder.this.roundCornerRadius, paint);
                    canvas.setBitmap(null);
                    LoadBuilder.this.tdsImage.memCache.put(LoadBuilder.this.getKey(), result);
                    bitmap.recycle();
                    return result;
                }
                return bitmap;
            }

            private Bitmap loadBitmap() throws IOException {
                Bitmap bitmap;
                if (LoadBuilder.this.resId != 0 && (bitmap = BitmapFactory.decodeResource((Resources)LoadBuilder.this.tdsImage.context.getResources(), (int)LoadBuilder.this.resId)) != null) {
                    LoadBuilder.this.tdsImage.memCache.put(LoadBuilder.this.getKey(), bitmap);
                    return bitmap;
                }
                bitmap = this.loadFromDisk();
                if (bitmap != null) {
                    return bitmap;
                }
                return this.loadAndCacheFromNet();
            }

            private Bitmap loadFromDisk() throws IOException {
                File bmpFile = "file".equals(LoadBuilder.this.uri.getScheme()) ? new File(LoadBuilder.this.uri.getPath()) : LoadBuilder.this.tdsImage.diskCache.get(LoadBuilder.this.getDiskKey());
                if (bmpFile != null) {
                    Bitmap bmp = LoadBuilder.this.width * LoadBuilder.this.height == 0 ? BitmapFactory.decodeFile((String)bmpFile.getAbsolutePath()) : this.getScaleBitmap(bmpFile);
                    if (bmp != null) {
                        LoadBuilder.this.tdsImage.memCache.put(LoadBuilder.this.getKey(), bmp);
                    }
                    return bmp;
                }
                return null;
            }

            private Bitmap getScaleBitmap(File file) {
                if (file == null || !file.exists()) {
                    return null;
                }
                Bitmap bitmap = null;
                BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
                decodeOptions.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)decodeOptions);
                int actualWidth = decodeOptions.outWidth;
                int actualHeight = decodeOptions.outHeight;
                int desiredWidth = this.getResizedDimension(LoadBuilder.this.width, LoadBuilder.this.height, actualWidth, actualHeight, LoadBuilder.this.scaleType);
                int desiredHeight = this.getResizedDimension(LoadBuilder.this.height, LoadBuilder.this.width, actualHeight, actualWidth, LoadBuilder.this.scaleType);
                decodeOptions.inJustDecodeBounds = false;
                decodeOptions.inSampleSize = this.findBestSampleSize(actualWidth, actualHeight, desiredWidth, desiredHeight);
                Bitmap tempBitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)decodeOptions);
                if (tempBitmap != null) {
                    bitmap = Bitmap.createScaledBitmap((Bitmap)tempBitmap, (int)desiredWidth, (int)desiredHeight, (boolean)true);
                    tempBitmap.recycle();
                } else {
                    bitmap = null;
                }
                return bitmap;
            }

            private int findBestSampleSize(int actualWidth, int actualHeight, int desiredWidth, int desiredHeight) {
                double wr = (double)actualWidth / (double)desiredWidth;
                double hr = (double)actualHeight / (double)desiredHeight;
                double ratio = Math.min(wr, hr);
                float n = 1.0f;
                while ((double)(n * 2.0f) <= ratio) {
                    n *= 2.0f;
                }
                return (int)n;
            }

            private int getResizedDimension(int maxPrimary, int maxSecondary, int actualPrimary, int actualSecondary, ImageView.ScaleType scaleType) {
                if (maxPrimary == 0 && maxSecondary == 0) {
                    return actualPrimary;
                }
                if (scaleType == ImageView.ScaleType.FIT_XY) {
                    return maxPrimary == 0 ? actualPrimary : maxPrimary;
                }
                if (maxPrimary == 0) {
                    double ratio = (double)maxSecondary / (double)actualSecondary;
                    return (int)((double)actualPrimary * ratio);
                }
                if (maxSecondary == 0) {
                    return maxPrimary;
                }
                double ratio = (double)actualSecondary / (double)actualPrimary;
                int resized = maxPrimary;
                if (scaleType == ImageView.ScaleType.CENTER_CROP) {
                    if ((double)maxPrimary * ratio < (double)maxSecondary) {
                        resized = (int)((double)maxSecondary / ratio);
                    }
                    return resized;
                }
                if ((double)maxPrimary * ratio > (double)maxSecondary) {
                    resized = (int)((double)maxSecondary / ratio);
                }
                return resized;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Bitmap loadAndCacheFromNet() throws IOException {
                TdsHttp.Request request = new TdsHttp.Request.Builder().url(LoadBuilder.this.uri.toString()).build();
                try (TdsHttp.Response response = null;){
                    final TdsHttp.Response finalResponse = response = LoadBuilder.this.tdsImage.client.newCall(request).execute();
                    LoadBuilder.this.tdsImage.diskCache.put(LoadBuilder.this.getDiskKey(), new DiskCache.Writer(){

                        @Override
                        public boolean write(File file) throws IOException {
                            IoUtil.copy(finalResponse.body().byteStream(), file);
                            return true;
                        }
                    });
                    Bitmap bitmap = this.loadFromDisk();
                    return bitmap;
                }
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Subscriber<Bitmap>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                target.onFailure(e);
            }

            @Override
            public void onNext(Bitmap bitmap) {
                target.onSuccess(bitmap);
            }
        });
    }
}

