/*
 * Decompiled with CFR 0.152.
 */
package com.m3839.sdk.common.dialog;

import android.app.Activity;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.m3839.sdk.common.R;
import com.m3839.sdk.common.dialog.AbstractBodyDialog;
import com.m3839.sdk.common.util.ScreenUtils;

public abstract class AbstractDialog
extends AbstractBodyDialog {
    public TextView cancelTxt;
    public TextView confirmTxt;
    public View dividerView;
    private String cancel;
    private String confirm;
    private View.OnClickListener onClickCancelListener;
    private View.OnClickListener onClickConfirmListener;
    private int confirmColor;
    private int cancelColor;

    @Override
    public int getBottomLayoutId() {
        return R.layout.hykb_common_dialog_abstract_bottom;
    }

    @Override
    public int getBackground() {
        return R.drawable.hykb_bg_default_dialog;
    }

    @Override
    public abstract int getLayoutId();

    @Override
    public int getDialogWidth() {
        return ScreenUtils.dip2px(this.getContext(), 320.0f);
    }

    @Override
    public void initView(Bundle bundle) {
        AbstractDialog abstractDialog = this;
        super.initView(bundle);
        abstractDialog.confirmTxt = (TextView)abstractDialog.findViewById(R.id.confirm_txt);
        abstractDialog.cancelTxt = (TextView)abstractDialog.findViewById(R.id.cancel_txt);
        abstractDialog.dividerView = abstractDialog.findViewById(R.id.divider_view);
        abstractDialog.confirmTxt.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (AbstractDialog.this.onClickConfirmListener != null) {
                    AbstractDialog.this.onClickConfirmListener.onClick(view);
                }
            }
        });
    }

    @Override
    public void initUI() {
        super.initUI();
    }

    @Override
    public void initAfterUI() {
        AbstractDialog abstractDialog = this;
        super.initAfterUI();
        int n = abstractDialog.confirmColor;
        if (n != 0) {
            this.confirmTxt.setTextColor(n);
        }
        if ((n = this.cancelColor) != 0) {
            this.cancelTxt.setTextColor(n);
        }
        if (TextUtils.isEmpty((CharSequence)this.cancel)) {
            AbstractDialog abstractDialog2 = this;
            abstractDialog2.cancelTxt.setVisibility(8);
            abstractDialog2.dividerView.setVisibility(8);
            abstractDialog2.confirmTxt.setBackgroundResource(R.drawable.hykb_bg_default_dialog_single_btn);
            abstractDialog2.confirmTxt.setText((CharSequence)this.confirm);
            if (abstractDialog2.confirmColor == 0) {
                this.confirmTxt.setTextColor(Color.parseColor((String)"#333333"));
            }
        } else {
            AbstractDialog abstractDialog3 = this;
            abstractDialog3.cancelTxt.setVisibility(0);
            abstractDialog3.dividerView.setVisibility(0);
            abstractDialog3.confirmTxt.setText((CharSequence)this.confirm);
            abstractDialog3.cancelTxt.setText((CharSequence)this.cancel);
            abstractDialog3.cancelTxt.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (AbstractDialog.this.onClickCancelListener != null) {
                        AbstractDialog.this.onClickCancelListener.onClick(view);
                    }
                }
            });
        }
    }

    public AbstractDialog setOnConfirmClickListener(View.OnClickListener onClickListener) {
        this.onClickConfirmListener = onClickListener;
        return this;
    }

    public AbstractDialog setOnCancelClickListener(View.OnClickListener onClickListener) {
        this.onClickCancelListener = onClickListener;
        return this;
    }

    public AbstractDialog setConfirm(String string2) {
        this.confirm = string2;
        return this;
    }

    public AbstractDialog setCancel(String string2) {
        this.cancel = string2;
        return this;
    }

    public AbstractDialog setConfirmColor(int n) {
        this.confirmColor = n;
        return this;
    }

    public AbstractDialog setCancelColor(int n) {
        this.cancelColor = n;
        return this;
    }

    @Override
    public AbstractDialog show(Activity activity) {
        AbstractDialog abstractDialog = this;
        super.show(activity);
        return abstractDialog;
    }

    public TextView getConfirmTxt() {
        return this.confirmTxt;
    }

    public TextView getCancelTxt() {
        return this.cancelTxt;
    }
}

