/*
 * Decompiled with CFR 0.152.
 */
package com.m3839.sdk.common.util;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.view.WindowManager;

public class ScreenUtils {
    public static int dip2px(Context context, float f2) {
        return (int)(f2 * context.getResources().getDisplayMetrics().density + 0.5f);
    }

    public static int sp2px(Context context, float f2) {
        return (int)(f2 * context.getResources().getDisplayMetrics().scaledDensity + 0.5f);
    }

    public static int getScreenHeight(Context context) {
        int n;
        if (Build.VERSION.SDK_INT >= 13) {
            context = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            Point point = new Point();
            context.getSize(point);
            n = point.y;
        } else {
            n = context.getResources().getDisplayMetrics().heightPixels;
        }
        return n;
    }

    public static int getScreenWidth(Context context) {
        int n;
        if (Build.VERSION.SDK_INT >= 13) {
            context = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            Point point = new Point();
            context.getSize(point);
            n = point.x;
        } else {
            n = context.getResources().getDisplayMetrics().widthPixels;
        }
        return n;
    }

    public static boolean isScreenOriatationPortrait(Context context) {
        return context.getResources().getConfiguration().orientation == 1;
    }
}

