/*
 * Decompiled with CFR 0.152.
 */
package com.yasirkula.unity;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.yasirkula.unity.NativeGalleryPermissionReceiver;

@TargetApi(value=23)
public class NativeGalleryPermissionFragment
extends Fragment {
    public static final String READ_PERMISSION_ONLY = "NG_ReadOnly";
    public static final String MEDIA_TYPE_ID = "NG_MediaType";
    private static final int PERMISSIONS_REQUEST_CODE = 123655;
    private final NativeGalleryPermissionReceiver permissionReceiver;

    public NativeGalleryPermissionFragment() {
        this.permissionReceiver = null;
    }

    public NativeGalleryPermissionFragment(NativeGalleryPermissionReceiver permissionReceiver) {
        this.permissionReceiver = permissionReceiver;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.permissionReceiver == null) {
            this.onRequestPermissionsResult(123655, new String[0], new int[0]);
        } else {
            boolean readPermissionOnly = this.getArguments().getBoolean(READ_PERMISSION_ONLY);
            if (!readPermissionOnly && Build.VERSION.SDK_INT < 30) {
                this.requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"}, 123655);
            } else if (Build.VERSION.SDK_INT < 33 || this.getActivity().getApplicationInfo().targetSdkVersion < 33) {
                this.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 123655);
            } else {
                this.onRequestPermissionsResult(123655, new String[0], new int[0]);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode != 123655) {
            return;
        }
        if (this.permissionReceiver == null) {
            Log.e((String)"Unity", (String)"Fragment data got reset while asking permissions!");
            this.getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
            return;
        }
        int result = 1;
        if (permissions.length == 0 || grantResults.length == 0) {
            result = 2;
        } else {
            for (int i = 0; i < permissions.length && i < grantResults.length; ++i) {
                if (grantResults[i] != -1) continue;
                if (!this.shouldShowRequestPermissionRationale(permissions[i])) {
                    result = 0;
                    break;
                }
                result = 2;
            }
        }
        this.permissionReceiver.OnPermissionResult(result);
        this.getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        try {
            Intent resumeUnityActivity = new Intent((Context)this.getActivity(), this.getActivity().getClass());
            resumeUnityActivity.setFlags(131072);
            this.getActivity().startActivityIfNeeded(resumeUnityActivity, 0);
        }
        catch (Exception e) {
            Log.e((String)"Unity", (String)"Exception (resume):", (Throwable)e);
        }
    }
}

