/*
 * Decompiled with CFR 0.152.
 */
package com.m3839.sdk.common.view.floatview;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.m3839.sdk.common.view.floatview.DismissRunnable;
import com.m3839.sdk.common.view.floatview.OnCancelListener;
import com.m3839.sdk.common.view.floatview.OnClickListener;
import com.m3839.sdk.common.view.floatview.ViewClickWrapper;

public class HykbFloatView {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private Context mContext;
    private View mRootView;
    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mWindowParams;
    private boolean mShow;
    private int mDuration;
    private OnCancelListener mListener;

    private HykbFloatView(Context context) {
        WindowManager.LayoutParams layoutParams;
        WindowManager.LayoutParams layoutParams2;
        this.mContext = context;
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        WindowManager.LayoutParams layoutParams3 = layoutParams2 = layoutParams;
        WindowManager.LayoutParams layoutParams4 = layoutParams2;
        layoutParams4();
        this.mWindowParams = layoutParams4;
        layoutParams3.height = -2;
        layoutParams3.width = -2;
        layoutParams3.format = -3;
        layoutParams3.windowAnimations = 16973828;
        layoutParams3.flags = 152;
        layoutParams.packageName = context.getPackageName();
    }

    public HykbFloatView(Activity activity) {
        this((Context)activity);
        if ((activity.getWindow().getAttributes().flags & 0x400) != 0) {
            this.addWindowFlags(1024);
        }
    }

    public HykbFloatView setAnimStyle(int n) {
        this.mWindowParams.windowAnimations = n;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    public HykbFloatView addWindowFlags(int n) {
        HykbFloatView hykbFloatView = this;
        hykbFloatView.mWindowParams.flags |= n;
        if (hykbFloatView.isShow()) {
            this.update();
        }
        return this;
    }

    public boolean hasWindowFlags(int n) {
        return (this.mWindowParams.flags & n) != 0;
    }

    public HykbFloatView removeWindowFlags(int n) {
        HykbFloatView hykbFloatView = this;
        hykbFloatView.mWindowParams.flags &= ~n;
        if (hykbFloatView.isShow()) {
            this.update();
        }
        return this;
    }

    public <V extends View> V findViewById(int n) {
        HykbFloatView hykbFloatView = hykbFloatView.mRootView;
        if (hykbFloatView != null) {
            return (V)hykbFloatView.findViewById(n);
        }
        throw new IllegalStateException("Please setup view");
    }

    public HykbFloatView setText(int n, int n2) {
        return this.setText(n, this.mContext.getResources().getString(n2));
    }

    public HykbFloatView setText(CharSequence charSequence) {
        return this.setText(16908299, charSequence);
    }

    public HykbFloatView setText(int n, CharSequence charSequence) {
        HykbFloatView hykbFloatView = this;
        ((TextView)hykbFloatView.findViewById(n)).setText(charSequence);
        return hykbFloatView;
    }

    public HykbFloatView setOnClickListener(int n, OnClickListener onClickListener) {
        HykbFloatView hykbFloatView = this;
        new ViewClickWrapper(hykbFloatView, (View)hykbFloatView.findViewById(n), onClickListener);
        if (this.hasWindowFlags(16)) {
            HykbFloatView hykbFloatView2 = this;
            hykbFloatView2.removeWindowFlags(16);
            if (hykbFloatView2.isShow()) {
                this.update();
            }
        }
        return this;
    }

    public HykbFloatView setXOffset(int n) {
        this.mWindowParams.x = n;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    public HykbFloatView setYOffset(int n) {
        this.mWindowParams.y = n;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    public HykbFloatView setGravity(int n) {
        this.mWindowParams.gravity = n;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    public HykbFloatView setWidth(int n) {
        this.mWindowParams.width = n;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    public HykbFloatView setHeight(int n) {
        this.mWindowParams.height = n;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    public HykbFloatView setOnCancelListener(OnCancelListener onCancelListener) {
        this.mListener = onCancelListener;
        return this;
    }

    public HykbFloatView setDuration(int n) {
        this.mDuration = n;
        if (this.isShow() && this.mDuration != 0) {
            HykbFloatView hykbFloatView = this;
            hykbFloatView.removeCallbacks();
            HykbFloatView hykbFloatView2 = this;
            hykbFloatView.postDelayed(new DismissRunnable(hykbFloatView2, hykbFloatView2.mListener), this.mDuration);
        }
        return this;
    }

    public View getRootView() {
        return this.mRootView;
    }

    public HykbFloatView setView(int n) {
        FrameLayout frameLayout;
        HykbFloatView hykbFloatView = this;
        FrameLayout frameLayout2 = frameLayout;
        frameLayout = new FrameLayout(this.mContext);
        return hykbFloatView.setView(LayoutInflater.from((Context)hykbFloatView.mContext).inflate(n, (ViewGroup)frameLayout2, false));
    }

    public HykbFloatView setView(View view) {
        this.mRootView = view;
        if ((view = view.getLayoutParams()) != null) {
            WindowManager.LayoutParams layoutParams = this.mWindowParams;
            if (layoutParams.width == -2 && layoutParams.height == -2) {
                this.setWidth(view.width);
                this.setHeight(view.height);
            }
        }
        if (this.mWindowParams.gravity == 0) {
            if (view instanceof FrameLayout.LayoutParams) {
                this.setGravity(((FrameLayout.LayoutParams)view).gravity);
            } else if (view instanceof LinearLayout.LayoutParams) {
                this.setGravity(((LinearLayout.LayoutParams)view).gravity);
            } else {
                this.setGravity(17);
            }
        }
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HykbFloatView show() {
        Throwable throwable2;
        block6: {
            HykbFloatView hykbFloatView;
            if (this.mRootView == null) throw new IllegalArgumentException("WindowParams and view cannot be empty");
            if (this.mWindowParams == null) throw new IllegalArgumentException("WindowParams and view cannot be empty");
            if (this.mShow) {
                this.cancel();
            }
            try {
                HykbFloatView hykbFloatView2 = this;
                HykbFloatView hykbFloatView3 = this;
                View view = hykbFloatView3.mRootView;
                hykbFloatView2.mWindowManager.addView(view, (ViewGroup.LayoutParams)hykbFloatView3.mWindowParams);
                hykbFloatView2.mShow = true;
                if (hykbFloatView2.mDuration == 0) return this;
                hykbFloatView = this;
            }
            catch (WindowManager.BadTokenException throwable2) {
                break block6;
            }
            catch (IllegalStateException throwable2) {
                break block6;
            }
            catch (NullPointerException throwable2) {
                // empty catch block
                break block6;
            }
            {
                HykbFloatView hykbFloatView4 = this;
                hykbFloatView.postDelayed(new DismissRunnable(hykbFloatView4, hykbFloatView4.mListener), this.mDuration);
            }
            return this;
        }
        throwable2.printStackTrace();
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HykbFloatView cancel() {
        RuntimeException runtimeException2;
        if (!this.mShow) return this;
        try {
            try {
                try {
                    this.mWindowManager.removeView(this.mRootView);
                    this.mShow = false;
                    return this;
                }
                catch (IllegalStateException runtimeException2) {
                }
            }
            catch (IllegalArgumentException runtimeException2) {}
        }
        catch (NullPointerException runtimeException2) {
            // empty catch block
        }
        runtimeException2.printStackTrace();
        return this;
    }

    public void update() {
        HykbFloatView hykbFloatView = hykbFloatView2;
        HykbFloatView hykbFloatView2 = hykbFloatView.mRootView;
        hykbFloatView2.mWindowManager.updateViewLayout((View)hykbFloatView2, (ViewGroup.LayoutParams)hykbFloatView.mWindowParams);
    }

    public boolean isShow() {
        return this.mShow;
    }

    public boolean postDelayed(Runnable runnable, long l2) {
        if (l2 < 0L) {
            l2 = 0L;
        }
        return this.postAtTime(runnable, SystemClock.uptimeMillis() + l2);
    }

    public boolean postAtTime(Runnable runnable, long l2) {
        return HANDLER.postAtTime(runnable, (Object)this, l2);
    }

    public void removeCallbacks() {
        HANDLER.removeCallbacksAndMessages((Object)this);
    }

    public Context getContext() {
        return this.mContext;
    }
}

