/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddictionui.widget;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.tapsdk.antiaddictionui.R;
import com.tapsdk.antiaddictionui.utils.ActivityUtils;
import com.tapsdk.antiaddictionui.utils.UIUtil;
import com.tapsdk.antiaddictionui.widget.SafeDialogFragment;

public abstract class AbstractAlertDialogFragment
extends SafeDialogFragment {
    protected Activity mActivity;

    public abstract View getContentView();

    public abstract Event leftEvent();

    public abstract Event rightEvent();

    public abstract int[] getLayoutParams();

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mActivity = (Activity)context;
    }

    @Override
    public void onStart() {
        super.onStart();
        Activity activity = this.getActivity();
        Dialog dialog = this.getDialog();
        if (dialog == null || activity == null || activity.getWindowManager() == null || dialog.getWindow() == null) {
            return;
        }
        dialog.getWindow().setLayout(this.getLayoutParams()[0], -2);
        dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.antiaddictionui_view_alert, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.getArguments() == null) {
            this.dismissAllowingStateLoss();
            return;
        }
        this.initView(view);
    }

    private void initView(View view) {
        TextView mTvNegative = (TextView)view.findViewById(R.id.tv_alert_negative);
        TextView mTvPositive = (TextView)view.findViewById(R.id.tv_alert_positive);
        if (this.leftEvent() != null) {
            mTvNegative.setText((CharSequence)this.leftEvent().text);
            mTvNegative.setOnClickListener(this.leftEvent().listener);
            mTvNegative.setVisibility(0);
        } else {
            mTvNegative.setVisibility(8);
        }
        if (this.rightEvent() != null) {
            mTvPositive.setText((CharSequence)this.rightEvent().text);
            mTvPositive.setOnClickListener(this.rightEvent().listener);
            mTvPositive.setVisibility(0);
        } else {
            mTvPositive.setVisibility(8);
        }
        if (view instanceof LinearLayout && this.getContentView() != null) {
            ViewGroup.LayoutParams viewLayoutParams = new ViewGroup.LayoutParams(-1, UIUtil.dp2px((Context)this.getActivity(), -2.0f));
            ((LinearLayout)view).addView(this.getContentView(), 0, viewLayoutParams);
        }
    }

    protected void safeToast(String msg) {
        Activity activity = this.getActivity();
        if (ActivityUtils.isActivityAlive(activity)) {
            // empty if block
        }
    }

    protected void safeToastError(Throwable throwable) {
        Activity activity = this.getActivity();
        if (ActivityUtils.isActivityAlive(activity)) {
            // empty if block
        }
    }

    public static class Event {
        String text;
        View.OnClickListener listener;

        public Event(String text, View.OnClickListener listener) {
            this.text = text;
            this.listener = listener;
        }
    }

    public static interface AlertClickCallback {
        public void onLeftClick(String var1);

        public void onRightClick(String var1);
    }
}

