/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddictionui.widget;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;
import com.tapsdk.antiaddictionui.R;
import com.tapsdk.antiaddictionui.widget.HoloThemeHelper;
import com.tapsdk.antiaddictionui.widget.SafeDialogFragment;

public class AntiAddictionProgressToast
extends SafeDialogFragment {
    public static final String TAG = AntiAddictionProgressToast.class.getSimpleName();
    private static final String TOAST_MESSAGE = "TOAST_MESSAGE";
    private static final String TOAST_LOAD = "TOAST_LOADING";
    private static final String TOAST_CANCEL = "TOAST_CANCEL";
    private Animation mAnimation;

    public static AntiAddictionProgressToast newInstance(String message, boolean cancelAble) {
        AntiAddictionProgressToast antiAddictionProgressToast = new AntiAddictionProgressToast();
        Bundle args = new Bundle();
        args.putBoolean(TOAST_LOAD, false);
        args.putBoolean(TOAST_CANCEL, cancelAble);
        args.putString(TOAST_MESSAGE, message);
        antiAddictionProgressToast.setArguments(args);
        return antiAddictionProgressToast;
    }

    public static AntiAddictionProgressToast newInstance(boolean cancelAble) {
        AntiAddictionProgressToast antiAddictionProgressToast = new AntiAddictionProgressToast();
        Bundle args = new Bundle();
        args.putBoolean(TOAST_LOAD, true);
        args.putBoolean(TOAST_CANCEL, cancelAble);
        antiAddictionProgressToast.setArguments(args);
        return antiAddictionProgressToast;
    }

    public static AntiAddictionProgressToast newInstance() {
        return AntiAddictionProgressToast.newInstance(false);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.getDialog() == null || this.getActivity() == null) {
            return null;
        }
        return inflater.inflate(R.layout.antiaddiction_loading_toast, container, false);
    }

    @Override
    public void onStart() {
        super.onStart();
        Dialog dialog = this.getDialog();
        if (dialog == null || this.getArguments() == null || this.getActivity() == null || this.getActivity().getWindowManager() == null || dialog.getWindow() == null) {
            return;
        }
        HoloThemeHelper.fixHoloDialogBlueLine(dialog);
        dialog.getWindow().clearFlags(2);
        dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        dialog.setCancelable(this.getArguments().getBoolean(TOAST_CANCEL));
        dialog.setCanceledOnTouchOutside(this.getArguments().getBoolean(TOAST_CANCEL));
        dialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialogInterface, int i, KeyEvent keyEvent) {
                boolean cancelAble = AntiAddictionProgressToast.this.getArguments().getBoolean(AntiAddictionProgressToast.TOAST_CANCEL);
                if (i == 4) {
                    if (cancelAble) {
                        AntiAddictionProgressToast.this.dismissAllowingStateLoss();
                    }
                    return true;
                }
                return false;
            }
        });
        WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
        lp.width = -1;
        lp.height = -1;
        dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        if (this.getDialog() != null && this.getDialog().getWindow() != null) {
            Window window = this.getDialog().getWindow();
            View decorView = window.getDecorView();
            if (Build.VERSION.SDK_INT >= 28) {
                lp.layoutInDisplayCutoutMode = 1;
                window.setAttributes(lp);
            }
            decorView.setSystemUiVisibility(1024);
        }
        dialog.getWindow().setAttributes(lp);
        dialog.getWindow().setFlags(1024, 1024);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.getWindow().requestFeature(1);
        return dialog;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getDialog() != null && this.getDialog().getWindow() != null) {
            Window window = this.getDialog().getWindow();
            window.setFlags(1024, 1024);
            window.getDecorView().setPadding(0, 0, 0, 0);
        }
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Bundle args = this.getArguments();
        if (args == null || this.getDialog() == null || this.getActivity() == null) {
            return;
        }
        ImageView iv = (ImageView)view.findViewById(R.id.iv_toast_loading);
        FrameLayout fl = (FrameLayout)view.findViewById(R.id.fl_toast_loading);
        if (!args.getBoolean(TOAST_LOAD)) {
            fl.setVisibility(4);
            return;
        }
        fl.setVisibility(0);
        this.mAnimation = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.antiaddiction_anim_loading);
        this.mAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        iv.setImageResource(R.drawable.antiaddiction_loading);
        iv.startAnimation(this.mAnimation);
    }

    public void dismiss() {
        try {
            super.dismiss();
            if (this.mAnimation != null) {
                this.mAnimation.cancel();
                this.mAnimation = null;
            }
        }
        catch (Exception e) {
            AntiAddictionLogger.e((String)e.getMessage());
        }
    }

    public void dismissAllowingStateLoss() {
        super.dismissAllowingStateLoss();
        try {
            if (this.mAnimation != null) {
                this.mAnimation.cancel();
                this.mAnimation = null;
            }
        }
        catch (Exception e) {
            AntiAddictionLogger.e((String)e.getMessage());
        }
    }
}

