/*
 * Decompiled with CFR 0.152.
 */
package com.m3839.sdk.common.view.password;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.EditText;

@SuppressLint(value={"AppCompatCustomView"})
public class PasswordEditText
extends EditText {
    private static final int DEFAULT_PASSWORD_COLOR = Color.parseColor((String)"#333333");
    private static final int DEFAULT_BORDER_COLOR = Color.parseColor((String)"#d1d2d6");
    private static final int DEFAULT_UNDERLINE_COLOR = Color.parseColor((String)"#e5e5e5");
    private static final int BACKGROUND_STYLE_BORDER = 0;
    private static final int BACKGROUND_STYLE_UNDERLINE = 1;
    private Paint mPasswordPaint;
    private int mPasswordColor;
    private int mPasswordItemWidth;
    private int mPasswordNumber;
    private int mPasswordRadius;
    private Paint mUnderlinePaint;
    private int mUnderlineWidth;
    private int mUnderlineSize;
    private int mUnderlineColor;
    private Paint mBorderPaint;
    private int mBorderColor;
    private int mBorderStrokeSize;
    private int mBorderCorner;
    private Paint mDivisionLinePaint;
    private int mDivisionLineColor;
    private int mDivisionLineSize;
    private int mBgStyle;
    private PasswordFullListener mListener;

    public PasswordEditText(Context context) {
        this(context, null);
    }

    public PasswordEditText(Context context, AttributeSet attributeSet) {
        int n;
        PasswordEditText passwordEditText = this;
        super(context, attributeSet);
        this.mPasswordColor = DEFAULT_PASSWORD_COLOR;
        this.mPasswordNumber = 4;
        this.mPasswordRadius = 4;
        this.mUnderlineSize = 2;
        this.mUnderlineColor = DEFAULT_UNDERLINE_COLOR;
        this.mBorderColor = n = DEFAULT_BORDER_COLOR;
        this.mBorderStrokeSize = 1;
        this.mBorderCorner = 0;
        this.mDivisionLineColor = n;
        this.mDivisionLineSize = 1;
        this.mBgStyle = 1;
        passwordEditText.initAttributeSet(context, attributeSet);
        passwordEditText.initPaint();
        passwordEditText.setInputType(2);
    }

    private void initPaint() {
        PasswordEditText passwordEditText = this;
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setAntiAlias(true);
        passwordEditText.mBorderPaint.setDither(true);
        passwordEditText.mBorderPaint.setStrokeWidth((float)this.mBorderStrokeSize);
        passwordEditText.mBorderPaint.setColor(this.mBorderColor);
        passwordEditText.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mDivisionLinePaint = new Paint();
        this.mDivisionLinePaint.setAntiAlias(true);
        passwordEditText.mDivisionLinePaint.setDither(true);
        passwordEditText.mDivisionLinePaint.setStrokeWidth((float)this.mDivisionLineSize);
        passwordEditText.mDivisionLinePaint.setColor(this.mDivisionLineColor);
        this.mPasswordPaint = new Paint();
        this.mPasswordPaint.setAntiAlias(true);
        passwordEditText.mPasswordPaint.setDither(true);
        passwordEditText.mPasswordPaint.setStyle(Paint.Style.FILL);
        passwordEditText.mPasswordPaint.setColor(this.mPasswordColor);
        this.mUnderlinePaint = new Paint();
        this.mUnderlinePaint.setAntiAlias(true);
        passwordEditText.mUnderlinePaint.setDither(true);
        passwordEditText.mUnderlinePaint.setColor(this.mUnderlineColor);
        passwordEditText.mUnderlinePaint.setStrokeWidth((float)this.mUnderlineSize);
    }

    private void initAttributeSet(Context context, AttributeSet attributeSet) {
        PasswordEditText passwordEditText = this;
        passwordEditText.mPasswordRadius = (int)passwordEditText.dip2px(passwordEditText.mPasswordRadius);
        passwordEditText.mDivisionLineSize = (int)passwordEditText.dip2px(passwordEditText.mDivisionLineSize);
        passwordEditText.mBorderStrokeSize = (int)passwordEditText.dip2px(passwordEditText.mBorderStrokeSize);
        passwordEditText.mUnderlineSize = (int)passwordEditText.dip2px(passwordEditText.mUnderlineSize);
    }

    private float dip2px(int n) {
        float f2 = n;
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)displayMetrics);
    }

    private void drawPassword(Canvas canvas) {
        PasswordEditText passwordEditText = this;
        int n = passwordEditText.getText().toString().trim().length();
        if (passwordEditText.mBgStyle == 1) {
            for (int i2 = 0; i2 < n; ++i2) {
                PasswordEditText passwordEditText2 = this;
                float f2 = this.mBorderStrokeSize * 8 + i2 * this.mPasswordItemWidth + this.mUnderlineWidth / 2;
                float f3 = passwordEditText2.getHeight() / 2;
                float f4 = passwordEditText2.mPasswordRadius;
                Paint paint = passwordEditText2.mPasswordPaint;
                canvas.drawCircle(f2, f3, f4, paint);
            }
        } else {
            int n2 = 0;
            while (n2 < n) {
                PasswordEditText passwordEditText3 = this;
                int n3 = n2 + 1;
                float f5 = this.mBorderStrokeSize + n3 * this.mPasswordItemWidth + n2 * this.mDivisionLineSize;
                float f6 = passwordEditText3.getHeight() / 2;
                float f7 = passwordEditText3.mPasswordRadius;
                Paint paint = passwordEditText3.mPasswordPaint;
                canvas.drawCircle(f5, f6, f7, paint);
                n2 = n3;
            }
        }
    }

    private void drawDivisionLine(Canvas canvas) {
        int n = 0;
        while (n < this.mPasswordNumber - 1) {
            PasswordEditText passwordEditText = this;
            int n2 = passwordEditText.mBorderStrokeSize;
            int n3 = n + 1;
            n = n2 + n3 * this.mPasswordItemWidth + n * this.mDivisionLineSize;
            float f2 = n;
            float f3 = n2;
            float f4 = passwordEditText.getHeight() - this.mBorderStrokeSize;
            Paint paint = passwordEditText.mDivisionLinePaint;
            canvas.drawLine(f2, f3, f2, f4, paint);
            n = n3;
        }
    }

    private void drawBg(Canvas canvas) {
        RectF rectF;
        RectF rectF2 = rectF;
        int n = this.mBorderStrokeSize;
        float f2 = n;
        float f3 = n;
        float f4 = f2;
        PasswordEditText passwordEditText = this;
        f2 = passwordEditText.getWidth() - this.mBorderStrokeSize;
        float f5 = passwordEditText.getHeight() - this.mBorderStrokeSize;
        rectF = new RectF(f4, f3, f2, f5);
        int n2 = this.mBorderCorner;
        if (n2 == 0) {
            canvas.drawRect(rectF2, this.mBorderPaint);
        } else {
            int n3 = n2;
            float f6 = n3;
            float f7 = n3;
            Paint paint = this.mBorderPaint;
            canvas.drawRoundRect(rectF2, f6, f7, paint);
        }
    }

    private void drawUnderLine(Canvas canvas) {
        for (int i2 = 0; i2 < this.mPasswordNumber; ++i2) {
            PasswordEditText passwordEditText = this;
            int n = passwordEditText.mBorderStrokeSize * 8 + i2 * this.mPasswordItemWidth;
            PasswordEditText passwordEditText2 = this;
            int n2 = passwordEditText2.getHeight() - this.mBorderStrokeSize;
            int n3 = n + passwordEditText2.mUnderlineWidth;
            float f2 = n;
            float f3 = n2;
            float f4 = n3;
            float f5 = passwordEditText.getHeight() - this.mBorderStrokeSize;
            Paint paint = passwordEditText.mUnderlinePaint;
            canvas.drawLine(f2, f3, f4, f5, paint);
        }
    }

    public void onDraw(Canvas object) {
        PasswordEditText passwordEditText = this;
        int n = this.mBorderStrokeSize;
        int n2 = this.mPasswordNumber;
        this.mPasswordItemWidth = n2 = (passwordEditText.getWidth() - n * 2 - (n2 - 1) * this.mDivisionLineSize) / n2;
        passwordEditText.mUnderlineWidth = n2 - n * 16;
        if (passwordEditText.mBgStyle == 1) {
            this.drawUnderLine((Canvas)object);
        } else {
            PasswordEditText passwordEditText2 = this;
            passwordEditText2.drawBg((Canvas)object);
            passwordEditText2.drawDivisionLine((Canvas)object);
        }
        PasswordEditText passwordEditText3 = this;
        passwordEditText3.drawPassword((Canvas)object);
        if (passwordEditText3.mListener != null) {
            object = this.getText().toString().trim();
            if (object.length() >= this.mPasswordNumber) {
                this.mListener.passwordFull((String)object);
            } else {
                this.mListener.passwordChanged((String)object);
            }
        }
    }

    public void addPassword(String string2) {
        String string3 = this.getText().toString().trim();
        if (string3.length() >= this.mPasswordNumber) {
            return;
        }
        this.setText(string3 + string2);
    }

    public void deleteLastPassword() {
        String string2 = this.getText().toString().trim();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        String string3 = string2;
        this.setText(string3.substring(0, string3.length() - 1));
    }

    public void setOnPasswordFullListener(PasswordFullListener passwordFullListener) {
        this.mListener = passwordFullListener;
    }

    public static interface PasswordFullListener {
        public void passwordFull(String var1);

        public void passwordChanged(String var1);
    }
}

