/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.localize;

import android.content.Context;
import android.text.TextUtils;
import com.tds.common.localize.LocalizeStore;
import com.tds.common.localize.model.PreferredLanguageChangedAction;
import com.tds.common.reactor.subjects.PublishSubject;
import com.tds.common.utils.DeviceUtils;
import com.tds.common.utils.FileUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class LocalizeManager {
    private static final Map<String, LocalizeStore> localizeCache = new HashMap<String, LocalizeStore>();
    private static int gameSelectedLang = 0;
    private static final PublishSubject<PreferredLanguageChangedAction> preferredLanguageChangedActionPublishSubject = PublishSubject.create();
    public static final Set<String> supportedLangSet = new HashSet<String>();
    public static final Set<Integer> supportedLangTypeSet = new HashSet<Integer>();
    public static final Map<String, Integer> supportedLangMap = new HashMap<String, Integer>();
    public static final Map<Integer, String> supportedLangStringMap = new HashMap<Integer, String>();
    private static boolean isDomestic;

    public static boolean isLangSupport(String lang) {
        return supportedLangSet.contains(lang);
    }

    public static PublishSubject<PreferredLanguageChangedAction> getLanguageChangedObservable() {
        return preferredLanguageChangedActionPublishSubject;
    }

    public static void changeGameSelectedLanguage(int lang) {
        if (!supportedLangTypeSet.contains(lang)) {
            return;
        }
        gameSelectedLang = lang;
        preferredLanguageChangedActionPublishSubject.onNext(new PreferredLanguageChangedAction(lang));
    }

    public static LocalizeStore getLocalizeStore(String sdkName) {
        LocalizeStore store = localizeCache.get(sdkName);
        if (store == null) {
            throw new IllegalStateException("please config localizestore(" + sdkName + ") first");
        }
        store.setPreferredLang(LocalizeManager.getPreferredLang());
        return store;
    }

    public static void configSDKLocalizeWith(int regionType) {
        isDomestic = regionType == 0;
    }

    public static void configSDKLocalize(String name, JSONObject dict, boolean domestic) {
        if (dict == null) {
            return;
        }
        LocalizeStore store = new LocalizeStore(dict, domestic);
        localizeCache.put(name, store);
        isDomestic = domestic;
    }

    public static void configSDKLocalize(String name, Context context, String assetsFileName, boolean domestic) {
        JSONObject dict = null;
        try {
            String dictStr = FileUtils.loadAssetTextAsString(context, assetsFileName);
            dict = new JSONObject(dictStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LocalizeManager.configSDKLocalize(name, dict, domestic);
    }

    public static int getPreferredLang() {
        if (gameSelectedLang != 0) {
            return gameSelectedLang;
        }
        String curLanguageDisplayName = DeviceUtils.getCurLanguageDisplayName();
        if (!TextUtils.isEmpty((CharSequence)curLanguageDisplayName)) {
            if (curLanguageDisplayName.startsWith("zh")) {
                if (!curLanguageDisplayName.toLowerCase().contains("cn") || curLanguageDisplayName.toLowerCase().contains("hant")) {
                    return 3;
                }
                return 1;
            }
            if (curLanguageDisplayName.startsWith("en")) {
                return 2;
            }
            if (curLanguageDisplayName.startsWith("ja")) {
                return 4;
            }
            if (curLanguageDisplayName.startsWith("ko")) {
                return 5;
            }
            if (curLanguageDisplayName.startsWith("th")) {
                return 6;
            }
            if (curLanguageDisplayName.startsWith("id") || curLanguageDisplayName.startsWith("in")) {
                return 7;
            }
        }
        return isDomestic ? 1 : 2;
    }

    public static Locale getLocale(int languageType) {
        switch (languageType) {
            case 1: {
                return Locale.CHINA;
            }
            case 2: {
                return Locale.US;
            }
            case 3: {
                return Locale.TRADITIONAL_CHINESE;
            }
            case 4: {
                return Locale.JAPAN;
            }
            case 5: {
                return Locale.KOREA;
            }
            case 6: {
                return new Locale("th");
            }
            case 7: {
                return new Locale("in");
            }
        }
        return LocalizeManager.getDefaultLocaleByDomestic();
    }

    public static Locale getDefaultLocaleByDomestic() {
        return isDomestic ? Locale.CHINA : Locale.US;
    }

    public static String getPreferredLanguageString() {
        return supportedLangStringMap.get(LocalizeManager.getPreferredLang());
    }

    static {
        supportedLangSet.addAll(Arrays.asList("zh_hans", "zh_hant", "en", "ja", "ko", "th", "id"));
        supportedLangTypeSet.addAll(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7));
        supportedLangMap.put("zh_hans", 1);
        supportedLangMap.put("en", 2);
        supportedLangMap.put("zh_hant", 3);
        supportedLangMap.put("ja", 4);
        supportedLangMap.put("ko", 5);
        supportedLangMap.put("th", 6);
        supportedLangMap.put("id", 7);
        supportedLangStringMap.put(1, "zh_CN");
        supportedLangStringMap.put(2, "en_US");
        supportedLangStringMap.put(3, "zh_TW");
        supportedLangStringMap.put(4, "ja_JP");
        supportedLangStringMap.put(5, "ko_KR");
        supportedLangStringMap.put(6, "th_TH");
        supportedLangStringMap.put(7, "id_ID");
        isDomestic = true;
    }
}

