/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.net.intercerptor;

import android.text.TextUtils;
import com.tds.common.net.TdsHttp;
import com.tds.common.net.XUAParams;
import java.io.IOException;

public class AddXUAInterceptor
implements TdsHttp.Interceptor {
    private final XUAParams xuaParams;

    public AddXUAInterceptor(XUAParams params) {
        this.xuaParams = params;
    }

    public AddXUAInterceptor(String sdkName, int sdkVersionCode, String sdkVersionName) {
        this(XUAParams.getCommonXUAParams(sdkName, sdkVersionCode, sdkVersionName));
    }

    @Override
    public TdsHttp.Response intercept(TdsHttp.Interceptor.Chain chain) throws IOException {
        TdsHttp.Request originRequest = chain.request();
        String xuaVal = "";
        if (this.xuaParams != null) {
            xuaVal = this.xuaParams.getXUAValue();
        }
        if (!TextUtils.isEmpty((CharSequence)xuaVal)) {
            originRequest.headers().put("XUA", xuaVal);
        }
        return chain.proceed(originRequest);
    }
}

