/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.permission;

import android.app.DialogFragment;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.tds.common.R;
import com.tds.common.permission.PermissionDialogCallback;
import com.tds.common.utils.NavigationBarUtil;

public class PermissionDialog
extends DialogFragment {
    public static final String TAG = PermissionDialog.class.getSimpleName();
    private PermissionDialogCallback mCallback;

    public static PermissionDialog newInstance(String title, String content, String cancel, String confirm, PermissionDialogCallback callback) {
        Bundle args = new Bundle();
        args.putString("title", title);
        args.putString("content", content);
        args.putString("cancel", cancel);
        args.putString("confirm", confirm);
        PermissionDialog dialog = new PermissionDialog();
        dialog.setArguments(args);
        dialog.setPermissionCallback(callback);
        return dialog;
    }

    public void setPermissionCallback(PermissionDialogCallback callback) {
        this.mCallback = callback;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        assert (this.getActivity() != null);
        this.setStyle(0, R.style.tds_common_permission_dialog);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        assert (this.getActivity() != null);
        return inflater.inflate(R.layout.tds_common_permission_forward_setting, container, false);
    }

    public void onStart() {
        this.getDialog().setCancelable(false);
        this.getDialog().setCanceledOnTouchOutside(false);
        this.getDialog().setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                return keyCode == 4;
            }
        });
        NavigationBarUtil.focusNotAle(this.getDialog().getWindow());
        super.onStart();
        NavigationBarUtil.hideNavigationBar(this.getDialog().getWindow());
        NavigationBarUtil.clearFocusNotAle(this.getDialog().getWindow());
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Bundle args = this.getArguments();
        if (args == null || this.getActivity() == null) {
            this.dismiss();
            return;
        }
        ((TextView)view.findViewById(R.id.tv_permission_title)).setText((CharSequence)args.getString("title"));
        ((TextView)view.findViewById(R.id.tv_permission_content)).setText((CharSequence)args.getString("content"));
        Button btCancel = (Button)view.findViewById(R.id.bt_permission_cancel);
        Button btConfirm = (Button)view.findViewById(R.id.bt_permission_ok);
        btCancel.setText((CharSequence)args.getString("cancel"));
        btConfirm.setText((CharSequence)args.getString("confirm"));
        btConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PermissionDialog.this.mCallback.onConfirm();
                PermissionDialog.this.dismiss();
            }
        });
        btCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PermissionDialog.this.mCallback.onClose();
                PermissionDialog.this.dismiss();
            }
        });
        view.findViewById(R.id.iv_permission_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PermissionDialog.this.mCallback.onClose();
                PermissionDialog.this.dismiss();
            }
        });
    }
}

