/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.reactor.observers;

import com.tds.common.reactor.Subscriber;
import com.tds.common.reactor.exceptions.CompositeException;
import com.tds.common.reactor.exceptions.Exceptions;
import com.tds.common.reactor.exceptions.OnCompletedFailedException;
import com.tds.common.reactor.exceptions.OnErrorFailedException;
import com.tds.common.reactor.exceptions.OnErrorNotImplementedException;
import com.tds.common.reactor.exceptions.UnsubscribeFailedException;
import com.tds.common.reactor.plugins.RxJavaHooks;
import com.tds.common.reactor.plugins.RxJavaPlugins;
import java.util.Arrays;

public class SafeSubscriber<T>
extends Subscriber<T> {
    private final Subscriber<? super T> actual;
    boolean done;

    public SafeSubscriber(Subscriber<? super T> actual) {
        super(actual);
        this.actual = actual;
    }

    @Override
    public void onCompleted() {
        if (!this.done) {
            this.done = true;
            try {
                this.actual.onCompleted();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaHooks.onError(e);
                throw new OnCompletedFailedException(e.getMessage(), e);
            }
            finally {
                try {
                    this.unsubscribe();
                }
                catch (Throwable e) {
                    RxJavaHooks.onError(e);
                    throw new UnsubscribeFailedException(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        Exceptions.throwIfFatal(e);
        if (!this.done) {
            this.done = true;
            this._onError(e);
        }
    }

    @Override
    public void onNext(T t) {
        try {
            if (!this.done) {
                this.actual.onNext(t);
            }
        }
        catch (Throwable e) {
            Exceptions.throwOrReport(e, this);
        }
    }

    protected void _onError(Throwable e) {
        RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
        try {
            this.actual.onError(e);
        }
        catch (OnErrorNotImplementedException e2) {
            try {
                this.unsubscribe();
            }
            catch (Throwable unsubscribeException) {
                RxJavaHooks.onError(unsubscribeException);
                throw new OnErrorNotImplementedException("Observer.onError not implemented and error while unsubscribing.", new CompositeException(Arrays.asList(e, unsubscribeException)));
            }
            throw e2;
        }
        catch (Throwable e2) {
            RxJavaHooks.onError(e2);
            try {
                this.unsubscribe();
            }
            catch (Throwable unsubscribeException) {
                RxJavaHooks.onError(unsubscribeException);
                throw new OnErrorFailedException("Error occurred when trying to propagate error to Observer.onError and during unsubscription.", new CompositeException(Arrays.asList(e, e2, unsubscribeException)));
            }
            throw new OnErrorFailedException("Error occurred when trying to propagate error to Observer.onError", new CompositeException(Arrays.asList(e, e2)));
        }
        try {
            this.unsubscribe();
        }
        catch (Throwable unsubscribeException) {
            RxJavaHooks.onError(unsubscribeException);
            throw new OnErrorFailedException(unsubscribeException);
        }
    }

    public Subscriber<? super T> getActual() {
        return this.actual;
    }
}

