/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.utils;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.tds.common.localize.LocalizeManager;
import java.util.Locale;

public class UIUtils {
    public static String getLocalizedString(Context context, int id2) {
        String result = UIUtils.getPreferredLocalizedResources(context).getString(id2);
        if (TextUtils.isEmpty((CharSequence)result)) {
            result = UIUtils.getLocalizedResourcesByDomestic(context).getString(id2);
        }
        return result;
    }

    public static Resources getPreferredLocalizedResources(Context context) {
        return UIUtils.getLocalizedResources(context, LocalizeManager.getLocale(LocalizeManager.getPreferredLang()));
    }

    public static Resources getLocalizedResourcesByDomestic(Context context) {
        return UIUtils.getLocalizedResources(context, LocalizeManager.getDefaultLocaleByDomestic());
    }

    public static Resources getLocalizedResources(Context context, Locale locale) {
        Resources standardResources = context.getResources();
        AssetManager assets = standardResources.getAssets();
        DisplayMetrics metrics = standardResources.getDisplayMetrics();
        Configuration config = new Configuration(standardResources.getConfiguration());
        config.locale = locale;
        return new Resources(assets, metrics, config);
    }

    public static int getLayoutId(Context context, String name) {
        return context.getResources().getIdentifier(name, "layout", context.getPackageName());
    }

    public static int getViewId(Context context, String name) {
        return context.getResources().getIdentifier(name, "id", context.getPackageName());
    }

    public static int getDrawableId(Context context, String name) {
        return context.getResources().getIdentifier(name, "drawable", context.getPackageName());
    }

    public static int getStringId(Context context, String name) {
        int resultID = UIUtils.getPreferredLocalizedResources(context).getIdentifier(name, "string", context.getPackageName());
        if (resultID == 0) {
            resultID = UIUtils.getLocalizedResourcesByDomestic(context).getIdentifier(name, "string", context.getPackageName());
        }
        return resultID;
    }

    public static int getId(Context context, String name) {
        return context.getResources().getIdentifier(name, "id", context.getPackageName());
    }

    public static String getString(Context context, String name) {
        try {
            return context.getString(UIUtils.getStringId(context, name));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static int dp2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale);
    }

    public static int dp2pxWithScale(float scale, float dipValue) {
        return (int)(dipValue * scale);
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int getWindowShortLength(Activity context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        context.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels);
    }

    public static int getWindowLongLength(Activity context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        context.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return Math.max(displayMetrics.widthPixels, displayMetrics.heightPixels);
    }

    public static int getWindowWidth(Activity context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        context.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    public static int getWindowHeight(Activity context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        context.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    public static Drawable getPackageIconDrawable(Activity context) {
        if (context == null) {
            return null;
        }
        PackageManager pm = context.getPackageManager();
        if (pm != null) {
            try {
                ApplicationInfo info = pm.getApplicationInfo(context.getPackageName(), 0);
                return info.loadIcon(pm);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getAppName(Context context) {
        if (context == null) {
            return null;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            return String.valueOf(packageManager.getApplicationLabel(context.getApplicationInfo()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

