/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.websocket.framing;

import com.tds.common.websocket.enums.Opcode;
import com.tds.common.websocket.exceptions.InvalidDataException;
import com.tds.common.websocket.exceptions.InvalidFrameException;
import com.tds.common.websocket.framing.FramedataImpl1;

public abstract class ControlFrame
extends FramedataImpl1 {
    public ControlFrame(Opcode opcode) {
        super(opcode);
    }

    @Override
    public void isValid() throws InvalidDataException {
        if (!this.isFin()) {
            throw new InvalidFrameException("Control frame can't have fin==false set");
        }
        if (this.isRSV1()) {
            throw new InvalidFrameException("Control frame can't have rsv1==true set");
        }
        if (this.isRSV2()) {
            throw new InvalidFrameException("Control frame can't have rsv2==true set");
        }
        if (this.isRSV3()) {
            throw new InvalidFrameException("Control frame can't have rsv3==true set");
        }
    }
}

