/*
 * Decompiled with CFR 0.152.
 */
package tds.androidx.recyclerview.widget;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import tds.androidx.annotation.IntRange;
import tds.androidx.annotation.NonNull;
import tds.androidx.annotation.Nullable;
import tds.androidx.recyclerview.widget.AdapterListUpdateCallback;
import tds.androidx.recyclerview.widget.BatchingListUpdateCallback;
import tds.androidx.recyclerview.widget.ListUpdateCallback;
import tds.androidx.recyclerview.widget.RecyclerView;

public class DiffUtil {
    private static final Comparator<Diagonal> DIAGONAL_COMPARATOR = new Comparator<Diagonal>(){

        @Override
        public int compare(Diagonal o1, Diagonal o2) {
            return o1.x - o2.x;
        }
    };

    private DiffUtil() {
    }

    @NonNull
    public static DiffResult calculateDiff(@NonNull Callback cb) {
        return DiffUtil.calculateDiff(cb, true);
    }

    @NonNull
    public static DiffResult calculateDiff(@NonNull Callback cb, boolean detectMoves) {
        int oldSize = cb.getOldListSize();
        int newSize = cb.getNewListSize();
        ArrayList<Diagonal> diagonals = new ArrayList<Diagonal>();
        ArrayList<Range> stack = new ArrayList<Range>();
        stack.add(new Range(0, oldSize, 0, newSize));
        int max = (oldSize + newSize + 1) / 2;
        CenteredArray forward = new CenteredArray(max * 2 + 1);
        CenteredArray backward = new CenteredArray(max * 2 + 1);
        ArrayList<Range> rangePool = new ArrayList<Range>();
        while (!stack.isEmpty()) {
            Range range = (Range)stack.remove(stack.size() - 1);
            Snake snake = DiffUtil.midPoint(range, cb, forward, backward);
            if (snake != null) {
                if (snake.diagonalSize() > 0) {
                    diagonals.add(snake.toDiagonal());
                }
                Range left = rangePool.isEmpty() ? new Range() : (Range)rangePool.remove(rangePool.size() - 1);
                left.oldListStart = range.oldListStart;
                left.newListStart = range.newListStart;
                left.oldListEnd = snake.startX;
                left.newListEnd = snake.startY;
                stack.add(left);
                Range right = range;
                right.oldListEnd = range.oldListEnd;
                right.newListEnd = range.newListEnd;
                right.oldListStart = snake.endX;
                right.newListStart = snake.endY;
                stack.add(right);
                continue;
            }
            rangePool.add(range);
        }
        Collections.sort(diagonals, DIAGONAL_COMPARATOR);
        return new DiffResult(cb, diagonals, forward.backingData(), backward.backingData(), detectMoves);
    }

    @Nullable
    private static Snake midPoint(Range range, Callback cb, CenteredArray forward, CenteredArray backward) {
        if (range.oldSize() < 1 || range.newSize() < 1) {
            return null;
        }
        int max = (range.oldSize() + range.newSize() + 1) / 2;
        forward.set(1, range.oldListStart);
        backward.set(1, range.oldListEnd);
        for (int d = 0; d < max; ++d) {
            Snake snake = DiffUtil.forward(range, cb, forward, backward, d);
            if (snake != null) {
                return snake;
            }
            snake = DiffUtil.backward(range, cb, forward, backward, d);
            if (snake == null) continue;
            return snake;
        }
        return null;
    }

    @Nullable
    private static Snake forward(Range range, Callback cb, CenteredArray forward, CenteredArray backward, int d) {
        boolean checkForSnake = Math.abs(range.oldSize() - range.newSize()) % 2 == 1;
        int delta = range.oldSize() - range.newSize();
        for (int k = -d; k <= d; k += 2) {
            int backwardsK;
            int y;
            int startY;
            int x;
            int startX;
            if (k == -d || k != d && forward.get(k + 1) > forward.get(k - 1)) {
                x = startX = forward.get(k + 1);
            } else {
                startX = forward.get(k - 1);
                x = startX + 1;
            }
            int n = startY = d == 0 || x != startX ? y : y - 1;
            for (y = range.newListStart + (x - range.oldListStart) - k; x < range.oldListEnd && y < range.newListEnd && cb.areItemsTheSame(x, y); ++x, ++y) {
            }
            forward.set(k, x);
            if (!checkForSnake || (backwardsK = delta - k) < -d + 1 || backwardsK > d - 1 || backward.get(backwardsK) > x) continue;
            Snake snake = new Snake();
            snake.startX = startX;
            snake.startY = startY;
            snake.endX = x;
            snake.endY = y;
            snake.reverse = false;
            return snake;
        }
        return null;
    }

    @Nullable
    private static Snake backward(Range range, Callback cb, CenteredArray forward, CenteredArray backward, int d) {
        boolean checkForSnake = (range.oldSize() - range.newSize()) % 2 == 0;
        int delta = range.oldSize() - range.newSize();
        for (int k = -d; k <= d; k += 2) {
            int forwardsK;
            int y;
            int startY;
            int x;
            int startX;
            if (k == -d || k != d && backward.get(k + 1) < backward.get(k - 1)) {
                x = startX = backward.get(k + 1);
            } else {
                startX = backward.get(k - 1);
                x = startX - 1;
            }
            int n = startY = d == 0 || x != startX ? y : y + 1;
            for (y = range.newListEnd - (range.oldListEnd - x - k); x > range.oldListStart && y > range.newListStart && cb.areItemsTheSame(x - 1, y - 1); --x, --y) {
            }
            backward.set(k, x);
            if (!checkForSnake || (forwardsK = delta - k) < -d || forwardsK > d || forward.get(forwardsK) < x) continue;
            Snake snake = new Snake();
            snake.startX = x;
            snake.startY = y;
            snake.endX = startX;
            snake.endY = startY;
            snake.reverse = true;
            return snake;
        }
        return null;
    }

    static class CenteredArray {
        private final int[] mData;
        private final int mMid;

        CenteredArray(int size) {
            this.mData = new int[size];
            this.mMid = this.mData.length / 2;
        }

        int get(int index) {
            return this.mData[index + this.mMid];
        }

        int[] backingData() {
            return this.mData;
        }

        void set(int index, int value) {
            this.mData[index + this.mMid] = value;
        }

        public void fill(int value) {
            Arrays.fill(this.mData, value);
        }
    }

    private static class PostponedUpdate {
        int posInOwnerList;
        int currentPos;
        boolean removal;

        PostponedUpdate(int posInOwnerList, int currentPos, boolean removal) {
            this.posInOwnerList = posInOwnerList;
            this.currentPos = currentPos;
            this.removal = removal;
        }
    }

    public static class DiffResult {
        public static final int NO_POSITION = -1;
        private static final int FLAG_NOT_CHANGED = 1;
        private static final int FLAG_CHANGED = 2;
        private static final int FLAG_MOVED_CHANGED = 4;
        private static final int FLAG_MOVED_NOT_CHANGED = 8;
        private static final int FLAG_MOVED = 12;
        private static final int FLAG_OFFSET = 4;
        private static final int FLAG_MASK = 15;
        private final List<Diagonal> mDiagonals;
        private final int[] mOldItemStatuses;
        private final int[] mNewItemStatuses;
        private final Callback mCallback;
        private final int mOldListSize;
        private final int mNewListSize;
        private final boolean mDetectMoves;

        DiffResult(Callback callback, List<Diagonal> diagonals, int[] oldItemStatuses, int[] newItemStatuses, boolean detectMoves) {
            this.mDiagonals = diagonals;
            this.mOldItemStatuses = oldItemStatuses;
            this.mNewItemStatuses = newItemStatuses;
            Arrays.fill(this.mOldItemStatuses, 0);
            Arrays.fill(this.mNewItemStatuses, 0);
            this.mCallback = callback;
            this.mOldListSize = callback.getOldListSize();
            this.mNewListSize = callback.getNewListSize();
            this.mDetectMoves = detectMoves;
            this.addEdgeDiagonals();
            this.findMatchingItems();
        }

        private void addEdgeDiagonals() {
            Diagonal first;
            Diagonal diagonal = first = this.mDiagonals.isEmpty() ? null : this.mDiagonals.get(0);
            if (first == null || first.x != 0 || first.y != 0) {
                this.mDiagonals.add(0, new Diagonal(0, 0, 0));
            }
            this.mDiagonals.add(new Diagonal(this.mOldListSize, this.mNewListSize, 0));
        }

        private void findMatchingItems() {
            for (Diagonal diagonal : this.mDiagonals) {
                for (int offset = 0; offset < diagonal.size; ++offset) {
                    int posX = diagonal.x + offset;
                    int posY = diagonal.y + offset;
                    boolean theSame = this.mCallback.areContentsTheSame(posX, posY);
                    int changeFlag = theSame ? 1 : 2;
                    this.mOldItemStatuses[posX] = posY << 4 | changeFlag;
                    this.mNewItemStatuses[posY] = posX << 4 | changeFlag;
                }
            }
            if (this.mDetectMoves) {
                this.findMoveMatches();
            }
        }

        private void findMoveMatches() {
            int posX = 0;
            for (Diagonal diagonal : this.mDiagonals) {
                while (posX < diagonal.x) {
                    if (this.mOldItemStatuses[posX] == 0) {
                        this.findMatchingAddition(posX);
                    }
                    ++posX;
                }
                posX = diagonal.endX();
            }
        }

        private void findMatchingAddition(int posX) {
            int posY = 0;
            int diagonalsSize = this.mDiagonals.size();
            for (int i = 0; i < diagonalsSize; ++i) {
                Diagonal diagonal = this.mDiagonals.get(i);
                while (posY < diagonal.y) {
                    boolean matching;
                    if (this.mNewItemStatuses[posY] == 0 && (matching = this.mCallback.areItemsTheSame(posX, posY))) {
                        boolean contentsMatching = this.mCallback.areContentsTheSame(posX, posY);
                        int changeFlag = contentsMatching ? 8 : 4;
                        this.mOldItemStatuses[posX] = posY << 4 | changeFlag;
                        this.mNewItemStatuses[posY] = posX << 4 | changeFlag;
                        return;
                    }
                    ++posY;
                }
                posY = diagonal.endY();
            }
        }

        public int convertOldPositionToNew(@IntRange(from=0L) int oldListPosition) {
            if (oldListPosition < 0 || oldListPosition >= this.mOldListSize) {
                throw new IndexOutOfBoundsException("Index out of bounds - passed position = " + oldListPosition + ", old list size = " + this.mOldListSize);
            }
            int status = this.mOldItemStatuses[oldListPosition];
            if ((status & 0xF) == 0) {
                return -1;
            }
            return status >> 4;
        }

        public int convertNewPositionToOld(@IntRange(from=0L) int newListPosition) {
            if (newListPosition < 0 || newListPosition >= this.mNewListSize) {
                throw new IndexOutOfBoundsException("Index out of bounds - passed position = " + newListPosition + ", new list size = " + this.mNewListSize);
            }
            int status = this.mNewItemStatuses[newListPosition];
            if ((status & 0xF) == 0) {
                return -1;
            }
            return status >> 4;
        }

        public void dispatchUpdatesTo(@NonNull RecyclerView.Adapter adapter) {
            this.dispatchUpdatesTo(new AdapterListUpdateCallback(adapter));
        }

        public void dispatchUpdatesTo(@NonNull ListUpdateCallback updateCallback) {
            BatchingListUpdateCallback batchingCallback;
            if (updateCallback instanceof BatchingListUpdateCallback) {
                batchingCallback = (BatchingListUpdateCallback)updateCallback;
            } else {
                batchingCallback = new BatchingListUpdateCallback(updateCallback);
                updateCallback = batchingCallback;
            }
            int currentListSize = this.mOldListSize;
            ArrayDeque<PostponedUpdate> postponedUpdates = new ArrayDeque<PostponedUpdate>();
            int posX = this.mOldListSize;
            int posY = this.mNewListSize;
            for (int diagonalIndex = this.mDiagonals.size() - 1; diagonalIndex >= 0; --diagonalIndex) {
                Object changePayload;
                PostponedUpdate postponedUpdate;
                int status;
                Diagonal diagonal = this.mDiagonals.get(diagonalIndex);
                int endX = diagonal.endX();
                int endY = diagonal.endY();
                while (posX > endX) {
                    if (((status = this.mOldItemStatuses[--posX]) & 0xC) != 0) {
                        int newPos = status >> 4;
                        postponedUpdate = DiffResult.getPostponedUpdate(postponedUpdates, newPos, false);
                        if (postponedUpdate != null) {
                            int updatedNewPos = currentListSize - postponedUpdate.currentPos;
                            batchingCallback.onMoved(posX, updatedNewPos - 1);
                            if ((status & 4) == 0) continue;
                            changePayload = this.mCallback.getChangePayload(posX, newPos);
                            batchingCallback.onChanged(updatedNewPos - 1, 1, changePayload);
                            continue;
                        }
                        postponedUpdates.add(new PostponedUpdate(posX, currentListSize - posX - 1, true));
                        continue;
                    }
                    batchingCallback.onRemoved(posX, 1);
                    --currentListSize;
                }
                while (posY > endY) {
                    if (((status = this.mNewItemStatuses[--posY]) & 0xC) != 0) {
                        int oldPos = status >> 4;
                        postponedUpdate = DiffResult.getPostponedUpdate(postponedUpdates, oldPos, true);
                        if (postponedUpdate == null) {
                            postponedUpdates.add(new PostponedUpdate(posY, currentListSize - posX, false));
                            continue;
                        }
                        int updatedOldPos = currentListSize - postponedUpdate.currentPos - 1;
                        batchingCallback.onMoved(updatedOldPos, posX);
                        if ((status & 4) == 0) continue;
                        changePayload = this.mCallback.getChangePayload(oldPos, posY);
                        batchingCallback.onChanged(posX, 1, changePayload);
                        continue;
                    }
                    batchingCallback.onInserted(posX, 1);
                    ++currentListSize;
                }
                posX = diagonal.x;
                posY = diagonal.y;
                for (int i = 0; i < diagonal.size; ++i) {
                    if ((this.mOldItemStatuses[posX] & 0xF) == 2) {
                        Object changePayload2 = this.mCallback.getChangePayload(posX, posY);
                        batchingCallback.onChanged(posX, 1, changePayload2);
                    }
                    ++posX;
                    ++posY;
                }
                posX = diagonal.x;
                posY = diagonal.y;
            }
            batchingCallback.dispatchLastEvent();
        }

        @Nullable
        private static PostponedUpdate getPostponedUpdate(Collection<PostponedUpdate> postponedUpdates, int posInList, boolean removal) {
            PostponedUpdate update;
            PostponedUpdate postponedUpdate = null;
            Iterator<PostponedUpdate> itr = postponedUpdates.iterator();
            while (itr.hasNext()) {
                update = itr.next();
                if (update.posInOwnerList != posInList || update.removal != removal) continue;
                postponedUpdate = update;
                itr.remove();
                break;
            }
            while (itr.hasNext()) {
                update = itr.next();
                if (removal) {
                    --update.currentPos;
                    continue;
                }
                ++update.currentPos;
            }
            return postponedUpdate;
        }
    }

    static class Range {
        int oldListStart;
        int oldListEnd;
        int newListStart;
        int newListEnd;

        public Range() {
        }

        public Range(int oldListStart, int oldListEnd, int newListStart, int newListEnd) {
            this.oldListStart = oldListStart;
            this.oldListEnd = oldListEnd;
            this.newListStart = newListStart;
            this.newListEnd = newListEnd;
        }

        int oldSize() {
            return this.oldListEnd - this.oldListStart;
        }

        int newSize() {
            return this.newListEnd - this.newListStart;
        }
    }

    static class Snake {
        public int startX;
        public int startY;
        public int endX;
        public int endY;
        public boolean reverse;

        Snake() {
        }

        boolean hasAdditionOrRemoval() {
            return this.endY - this.startY != this.endX - this.startX;
        }

        boolean isAddition() {
            return this.endY - this.startY > this.endX - this.startX;
        }

        int diagonalSize() {
            return Math.min(this.endX - this.startX, this.endY - this.startY);
        }

        @NonNull
        Diagonal toDiagonal() {
            if (this.hasAdditionOrRemoval()) {
                if (this.reverse) {
                    return new Diagonal(this.startX, this.startY, this.diagonalSize());
                }
                if (this.isAddition()) {
                    return new Diagonal(this.startX, this.startY + 1, this.diagonalSize());
                }
                return new Diagonal(this.startX + 1, this.startY, this.diagonalSize());
            }
            return new Diagonal(this.startX, this.startY, this.endX - this.startX);
        }
    }

    static class Diagonal {
        public final int x;
        public final int y;
        public final int size;

        Diagonal(int x, int y, int size) {
            this.x = x;
            this.y = y;
            this.size = size;
        }

        int endX() {
            return this.x + this.size;
        }

        int endY() {
            return this.y + this.size;
        }
    }

    public static abstract class ItemCallback<T> {
        public abstract boolean areItemsTheSame(@NonNull T var1, @NonNull T var2);

        public abstract boolean areContentsTheSame(@NonNull T var1, @NonNull T var2);

        @Nullable
        public Object getChangePayload(@NonNull T oldItem, @NonNull T newItem) {
            return null;
        }
    }

    public static abstract class Callback {
        public abstract int getOldListSize();

        public abstract int getNewListSize();

        public abstract boolean areItemsTheSame(int var1, int var2);

        public abstract boolean areContentsTheSame(int var1, int var2);

        @Nullable
        public Object getChangePayload(int oldItemPosition, int newItemPosition) {
            return null;
        }
    }
}

