/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddictionui;

import android.app.Activity;
import android.text.TextUtils;
import com.tapsdk.antiaddiction.AntiAddictionKit;
import com.tapsdk.antiaddiction.Callback;
import com.tapsdk.antiaddiction.config.AntiAddictionFunctionConfig;
import com.tapsdk.antiaddiction.entities.response.CheckPayResult;
import com.tapsdk.antiaddiction.entities.response.SubmitPayResult;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;
import com.tapsdk.antiaddictionui.AntiAddictionUICallback;
import com.tapsdk.antiaddictionui.AntiAddictionUIKit;
import com.tds.gson.JsonObject;
import com.unity3d.player.UnityPlayer;
import java.util.Map;

public class NativeAntiAddictionUIKitPlugin {
    private static final String TAG = "NativeAntiAddictionUIKitPlugin";
    private static final String GAME_OBJECT_NAME = "PluginBridge";

    public void initSDK(Activity activity, String gameIdentifier, boolean useTimeLimit, boolean usePaymentLimit) {
        AntiAddictionLogger.d((String)("Bridge init:[gameIdentifier:" + gameIdentifier + ",useTimeLimit" + useTimeLimit + ",usePaymentLimit" + usePaymentLimit + "]"));
        AntiAddictionFunctionConfig antiAddictionFunctionConfig = new AntiAddictionFunctionConfig.Builder().build();
        AntiAddictionUIKit.init(activity, gameIdentifier, antiAddictionFunctionConfig, new AntiAddictionUICallback(){

            @Override
            public void onCallback(int code, Map<String, Object> extras) {
                try {
                    JsonObject extrasJSONObject = new JsonObject();
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("code", (Number)code);
                    if (extras != null) {
                        for (Map.Entry<String, Object> entry : extras.entrySet()) {
                            extrasJSONObject.addProperty(entry.getKey(), String.valueOf(entry.getValue()));
                        }
                        jsonObject.addProperty("extras", extrasJSONObject.toString());
                    }
                    String antiAddictionCallbackDataStr = jsonObject.toString();
                    AntiAddictionLogger.d((String)("onCallback:" + antiAddictionCallbackDataStr));
                    UnityPlayer.UnitySendMessage((String)NativeAntiAddictionUIKitPlugin.GAME_OBJECT_NAME, (String)"HandleAntiAddictionCallbackMsg", (String)antiAddictionCallbackDataStr);
                }
                catch (Exception e) {
                    String errorMsg = !TextUtils.isEmpty((CharSequence)e.getMessage()) ? e.getMessage() : e.toString();
                    UnityPlayer.UnitySendMessage((String)NativeAntiAddictionUIKitPlugin.GAME_OBJECT_NAME, (String)"HandleException", (String)errorMsg);
                }
            }
        });
    }

    public void initSDK(Activity activity, String gameIdentifier, boolean useTimeLimit, boolean usePaymentLimit, boolean showSwitchAccount) {
        AntiAddictionLogger.d((String)("Bridge init:[gameIdentifier:" + gameIdentifier + ",useTimeLimit" + useTimeLimit + ",usePaymentLimit" + usePaymentLimit + ",showSwitchAccount" + showSwitchAccount + "]"));
        AntiAddictionFunctionConfig antiAddictionFunctionConfig = new AntiAddictionFunctionConfig.Builder().enableOnLineTimeLimit(useTimeLimit).enablePaymentLimit(usePaymentLimit).showSwitchAccount(showSwitchAccount).build();
        AntiAddictionUIKit.init(activity, gameIdentifier, antiAddictionFunctionConfig, new AntiAddictionUICallback(){

            @Override
            public void onCallback(int code, Map<String, Object> extras) {
                try {
                    JsonObject extrasJSONObject = new JsonObject();
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("code", (Number)code);
                    if (extras != null) {
                        for (Map.Entry<String, Object> entry : extras.entrySet()) {
                            extrasJSONObject.addProperty(entry.getKey(), String.valueOf(entry.getValue()));
                        }
                        jsonObject.addProperty("extras", extrasJSONObject.toString());
                    }
                    String antiAddictionCallbackDataStr = jsonObject.toString();
                    AntiAddictionLogger.d((String)("onCallback:" + antiAddictionCallbackDataStr));
                    UnityPlayer.UnitySendMessage((String)NativeAntiAddictionUIKitPlugin.GAME_OBJECT_NAME, (String)"HandleAntiAddictionCallbackMsg", (String)antiAddictionCallbackDataStr);
                }
                catch (Exception e) {
                    String errorMsg = !TextUtils.isEmpty((CharSequence)e.getMessage()) ? e.getMessage() : e.toString();
                    UnityPlayer.UnitySendMessage((String)NativeAntiAddictionUIKitPlugin.GAME_OBJECT_NAME, (String)"HandleException", (String)errorMsg);
                }
            }
        });
    }

    public void startup(Activity activity, boolean useTapLogin, String userIdentifier) {
        AntiAddictionUIKit.startup(activity, useTapLogin, userIdentifier);
    }

    public void checkPayLimit(Activity activity, long amount) {
        AntiAddictionLogger.d((String)("Bridge checkPayLimit[amount:" + amount + "]"));
        AntiAddictionUIKit.checkPayLimit(activity, amount, new com.tapsdk.antiaddictionui.Callback<CheckPayResult>(){

            @Override
            public void onSuccess(CheckPayResult result) {
                JsonObject checkPayLimitJSONObject = new JsonObject();
                checkPayLimitJSONObject.addProperty("status", (Number)(result.status ? 1 : 0));
                checkPayLimitJSONObject.addProperty("title", result.title);
                checkPayLimitJSONObject.addProperty("description", result.description);
                UnityPlayer.UnitySendMessage((String)NativeAntiAddictionUIKitPlugin.GAME_OBJECT_NAME, (String)"HandleCheckPayLimit", (String)checkPayLimitJSONObject.toString());
            }

            @Override
            public void onError(Throwable throwable) {
                String errorMsg = !TextUtils.isEmpty((CharSequence)throwable.getMessage()) ? throwable.getMessage() : throwable.toString();
                UnityPlayer.UnitySendMessage((String)NativeAntiAddictionUIKitPlugin.GAME_OBJECT_NAME, (String)"HandleCheckPayLimitException", (String)errorMsg);
            }
        });
    }

    public void submitPayResult(long amount) {
        AntiAddictionLogger.d((String)("Bridge submitPayResult[amount:" + amount + "]"));
        AntiAddictionUIKit.submitPayResult(amount, new Callback<SubmitPayResult>(){

            public void onSuccess(SubmitPayResult result) {
                UnityPlayer.UnitySendMessage((String)NativeAntiAddictionUIKitPlugin.GAME_OBJECT_NAME, (String)"HandleSubmitPayResult", (String)"");
            }

            public void onError(Throwable throwable) {
                String errorMsg = !TextUtils.isEmpty((CharSequence)throwable.getMessage()) ? throwable.getMessage() : throwable.toString();
                UnityPlayer.UnitySendMessage((String)NativeAntiAddictionUIKitPlugin.GAME_OBJECT_NAME, (String)"HandleSubmitPayResultException", (String)errorMsg);
            }
        });
    }

    public void logout() {
        AntiAddictionUIKit.logout();
    }

    public int getCurrentUserAgeLimit() {
        return AntiAddictionKit.currentUserAgeLimit();
    }

    public int getCurrentUserRemainTime() {
        return AntiAddictionKit.currentUserRemainingTime();
    }

    public void enterGame() {
        AntiAddictionUIKit.enterGame();
    }

    public void leaveGame() {
        AntiAddictionUIKit.leaveGame();
    }

    public void setUnityVersion(String version) {
        AntiAddictionUIKit.setUnityVersion(version);
    }

    public String getCurrentToken() {
        return AntiAddictionUIKit.currentToken();
    }

    public int isStandalone() {
        return AntiAddictionKit.isStandalone() ? 1 : 0;
    }

    public void setRndEnvironment(String newKey) {
        AntiAddictionUIKit.setRndEnvironment(newKey);
    }
}

