/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddictionui.model;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import com.tapsdk.antiaddiction.reactor.Observable;
import com.tapsdk.antiaddiction.skynet.Skynet;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;
import com.tapsdk.antiaddictionui.api.TapTapApi;
import com.tapsdk.antiaddictionui.entities.response.TapTapIdentifyInfoResult;
import com.tapsdk.antiaddictionui.utils.ActivityUtils;
import com.tds.common.entities.AccessToken;
import com.tds.common.oauth.AuthorizeModel;

public class TapTapModel {
    public static AccessToken accessToken;
    private static int gameHasLicense;
    private static int tapSupportAntiAddiction;
    private static int tapSupportIdentity;

    public Observable<TapTapIdentifyInfoResult> fetchTapTapIdentifyInfo(String clientId) {
        TapTapApi tapTapApi = (TapTapApi)Skynet.getService((String)Skynet.RETROFIT_FOR_TAPTAP_OPEN_SERVICE, TapTapApi.class);
        return tapTapApi.fetchTapTapIdentifyInfo(clientId);
    }

    public void getTapIdentifyToken(Activity activity, AuthorizeModel.AuthorizationCallback authorizationCallback) {
        String[] permissions = TapTapModel.isRunInTapSandboxAndProcessMatchCore() ? new String[]{"basic_info", "compliance"} : new String[]{"compliance"};
        AuthorizeModel.authorize((Activity)activity, (String)"tds_AntiAddiction", (AuthorizeModel.AuthorizationCallback)authorizationCallback, (String[])permissions);
    }

    public static boolean isRunInSandbox() {
        Object sandbox = System.getProperties().get("flag_running_in_sandbox");
        return sandbox != null;
    }

    public static boolean isRunInCanary() {
        String canary = (String)System.getProperties().get("flag_tap_canary");
        return !TextUtils.isEmpty((CharSequence)canary);
    }

    public static boolean isRunInTapSandboxAndProcessMatchCore() {
        return TapTapModel.isRunInSandbox() && !TapTapModel.isRunInCanary() && ActivityUtils.isProcessMatchCore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkGameLicense(Context context) {
        if (gameHasLicense > -1) {
            return gameHasLicense > 0;
        }
        if (context == null) {
            return false;
        }
        Cursor cursor = null;
        try {
            int hasLicense = 1;
            ContentResolver contentResolver = context.getApplicationContext().getContentResolver();
            Uri uri = Uri.parse((String)("content://com.taptap.sandbox_provider/game_info?packageName=" + context.getPackageName()));
            cursor = contentResolver.query(uri, null, null, null, null);
            while (cursor.moveToNext()) {
                hasLicense = cursor.getInt(cursor.getColumnIndex("hasAudited"));
            }
            cursor.close();
            AntiAddictionLogger.d((String)("checkGameLicense get value = " + hasLicense));
            gameHasLicense = hasLicense;
            boolean bl = hasLicense > 0;
            return bl;
        }
        catch (Exception e) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkTapSupportAntiAddiction(Context context) {
        if (tapSupportAntiAddiction > -1) {
            return tapSupportAntiAddiction > 0;
        }
        if (context == null) {
            return false;
        }
        Cursor cursor = null;
        try {
            int supportAntiAddiction = 0;
            ContentResolver contentResolver = context.getApplicationContext().getContentResolver();
            Uri uri = Uri.parse((String)"content://com.taptap.sandbox_provider/feature");
            cursor = contentResolver.query(uri, null, null, null, null);
            while (cursor.moveToNext()) {
                supportAntiAddiction = cursor.getInt(cursor.getColumnIndex("startupAntiAddiction"));
            }
            cursor.close();
            AntiAddictionLogger.d((String)("checkTapSupportAntiAddiction get value = " + supportAntiAddiction));
            tapSupportAntiAddiction = supportAntiAddiction;
            boolean bl = supportAntiAddiction > 0;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkTapSupportIdentity(Context context) {
        if (tapSupportIdentity > -1) {
            return tapSupportIdentity > 0;
        }
        if (context == null) {
            return false;
        }
        Cursor cursor = null;
        try {
            int supportIdentity = 0;
            ContentResolver contentResolver = context.getApplicationContext().getContentResolver();
            Uri uri = Uri.parse((String)"content://com.taptap.sandbox_provider/feature");
            cursor = contentResolver.query(uri, null, null, null, null);
            while (cursor.moveToNext()) {
                supportIdentity = cursor.getInt(cursor.getColumnIndex("verifyRealName"));
            }
            cursor.close();
            AntiAddictionLogger.d((String)("checkTapSupportIdentity get value = " + supportIdentity));
            tapSupportIdentity = supportIdentity;
            boolean bl = supportIdentity > 0;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    static {
        gameHasLicense = -1;
        tapSupportAntiAddiction = -1;
        tapSupportIdentity = -1;
    }
}

