/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;

public class RoundImageView
extends ImageView {
    private Context mContext;
    private int defaultColor = -1;
    private int defaultWidth = 0;
    private int defaultHeight = 0;

    public RoundImageView(Context context) {
        super(context);
        this.mContext = context;
    }

    public RoundImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
    }

    public RoundImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
    }

    protected void onDraw(Canvas canvas) {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        this.measure(0, 0);
        Bitmap b = ((BitmapDrawable)drawable).getBitmap();
        Bitmap bitmap = b.copy(Bitmap.Config.ARGB_8888, true);
        if (this.defaultWidth == 0) {
            this.defaultWidth = this.getWidth();
        }
        if (this.defaultHeight == 0) {
            this.defaultHeight = this.getHeight();
        }
        int radius = 0;
        radius = (this.defaultWidth < this.defaultHeight ? this.defaultWidth : this.defaultHeight) / 2;
        Bitmap roundBitmap = this.getCroppedRoundBitmap(bitmap, radius);
        canvas.drawBitmap(roundBitmap, (float)(this.defaultWidth / 2 - radius), (float)(this.defaultHeight / 2 - radius), null);
    }

    public Bitmap getCroppedRoundBitmap(Bitmap bmp, int radius) {
        Bitmap squareBitmap;
        int diameter = radius * 2;
        int bmpWidth = bmp.getWidth();
        int bmpHeight = bmp.getHeight();
        int squareWidth = 0;
        int squareHeight = 0;
        int x = 0;
        int y = 0;
        if (bmpHeight > bmpWidth) {
            squareWidth = squareHeight = bmpWidth;
            x = 0;
            y = (bmpHeight - bmpWidth) / 2;
            squareBitmap = Bitmap.createBitmap((Bitmap)bmp, (int)x, (int)y, (int)squareWidth, (int)squareHeight);
        } else if (bmpHeight < bmpWidth) {
            squareWidth = squareHeight = bmpHeight;
            x = (bmpWidth - bmpHeight) / 2;
            y = 0;
            squareBitmap = Bitmap.createBitmap((Bitmap)bmp, (int)x, (int)y, (int)squareWidth, (int)squareHeight);
        } else {
            squareBitmap = bmp;
        }
        Bitmap scaledSrcBmp = squareBitmap.getWidth() != diameter || squareBitmap.getHeight() != diameter ? Bitmap.createScaledBitmap((Bitmap)squareBitmap, (int)diameter, (int)diameter, (boolean)true) : squareBitmap;
        Bitmap output = Bitmap.createBitmap((int)scaledSrcBmp.getWidth(), (int)scaledSrcBmp.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, scaledSrcBmp.getWidth(), scaledSrcBmp.getHeight());
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        paint.setDither(true);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawCircle((float)(scaledSrcBmp.getWidth() / 2), (float)(scaledSrcBmp.getHeight() / 2), (float)(scaledSrcBmp.getWidth() / 2), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(scaledSrcBmp, rect, rect, paint);
        bmp = null;
        squareBitmap = null;
        scaledSrcBmp = null;
        return output;
    }

    private void drawCircleBorder(Canvas canvas, int radius, int color) {
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        paint.setDither(true);
        paint.setColor(color);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawCircle((float)(this.defaultWidth / 2), (float)(this.defaultHeight / 2), (float)radius, paint);
    }
}

