/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import com.sdk.douyou.util.FalconUtils;
import java.io.File;
import java.io.IOException;

public class ScreenshotUtils {
    public static void copytocustompicturelib(Activity context) throws IOException {
        File outputFile = ScreenshotUtils.createFile((Context)context, ScreenshotUtils.getAppName((Context)context), System.currentTimeMillis() / 1000L + ".png");
        FalconUtils.takeScreenshot(context, outputFile);
        Uri uri = Uri.fromFile((File)outputFile);
        Intent scanFileIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", uri);
        context.sendBroadcast(scanFileIntent);
    }

    public static File createFile(Context context, String path, String fileName) throws IOException {
        File myCaptureFile;
        String subForder = ScreenshotUtils.getRealPath(context) + "/" + path + "/";
        File foder = new File(subForder);
        if (!foder.exists()) {
            foder.mkdirs();
        }
        if (!(myCaptureFile = new File(subForder, fileName)).exists()) {
            myCaptureFile.createNewFile();
        }
        return myCaptureFile;
    }

    public static String getRealPath(Context context) {
        String recAudioPath;
        if (Environment.getExternalStorageState().equals("mounted")) {
            recAudioPath = Environment.getExternalStorageDirectory().getAbsolutePath();
            Log.i((String)"swl", (String)("recAudioPath1 = " + recAudioPath));
        } else {
            recAudioPath = context.getCacheDir().getPath();
            Log.i((String)"swl", (String)("recAudioPath2 = " + recAudioPath));
        }
        return recAudioPath;
    }

    public static String getAppName(Context context) {
        PackageManager packageManager = context.getPackageManager();
        String appName = "";
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            appName = packageInfo.applicationInfo.loadLabel(context.getPackageManager()).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return appName;
    }
}

