/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util.toast;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Build;
import android.view.View;
import com.sdk.douyou.util.ResourceUtil;

final class ToastyUtils {
    private ToastyUtils() {
    }

    static Drawable tintIcon(Drawable drawable, int tintColor) {
        drawable.setColorFilter(tintColor, PorterDuff.Mode.SRC_IN);
        return drawable;
    }

    static Drawable tint9PatchDrawableFrame(Context context, int tintColor) {
        NinePatchDrawable toastDrawable = (NinePatchDrawable)ToastyUtils.getDrawable(context, ResourceUtil.getDrawableId(context, "toast_frame"));
        return ToastyUtils.tintIcon((Drawable)toastDrawable, tintColor);
    }

    static void setBackground(View view, Drawable drawable) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable);
        } else {
            view.setBackgroundDrawable(drawable);
        }
    }

    static Drawable getDrawable(Context context, int id2) {
        return context.getResources().getDrawable(id2);
    }

    static int getColor(Context context, int color) {
        return context.getResources().getColor(color);
    }
}

