/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ListView;
import com.sdk.douyou.util.LogUtil;
import jxp.android.support.v4.widget.SwipeRefreshLayout;

public class DouYouListViewSwipeRefreshLayout
extends SwipeRefreshLayout {
    private int mTouchSlop;
    private ListView mListView;
    private float downY;
    private float moveY;
    private boolean mLoading;
    private OnLoadListener mLoadListener;
    private OnRefreshDealListener mRefreshDealListener;
    private boolean refreshListenerFlag = false;
    private View root;
    private Context mContext;

    public DouYouListViewSwipeRefreshLayout(Context context) {
        this(context, null);
    }

    public DouYouListViewSwipeRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        LogUtil.debug(" ViewConfiguration.get(context).getScaledTouchSlop() : " + ViewConfiguration.get((Context)context).getScaledTouchSlop());
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.refreshListenerFlag = true;
        this.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                if (DouYouListViewSwipeRefreshLayout.this.mLoading) {
                    DouYouListViewSwipeRefreshLayout.this.setRefreshing(false);
                    if (DouYouListViewSwipeRefreshLayout.this.mRefreshDealListener != null) {
                        DouYouListViewSwipeRefreshLayout.this.mRefreshDealListener.onLoading();
                    }
                } else if (DouYouListViewSwipeRefreshLayout.this.mRefreshDealListener != null) {
                    DouYouListViewSwipeRefreshLayout.this.mRefreshDealListener.onRefresh();
                }
            }
        });
    }

    public void setListView(ListView listView, int resId, int rootId) {
        this.mListView = listView;
        View mFooterView = LayoutInflater.from((Context)this.mContext).inflate(resId, (ViewGroup)this.mListView, false);
        this.root = mFooterView.findViewById(rootId);
        this.root.setVisibility(8);
        this.setLoadingView(mFooterView);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                LogUtil.debug("downY : " + this.downY);
                this.downY = ev.getRawY();
                break;
            }
            case 2: {
                this.moveY = ev.getRawY();
                break;
            }
            case 1: {
                this.moveY = ev.getRawY();
                if (this.isRefreshing() || !this.canLoadMore()) break;
                this.load();
                break;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private void load() {
        if (this.isRefreshing()) {
            if (this.mLoadListener != null) {
                this.mLoadListener.onRefreshing();
            }
        } else {
            if (this.mLoading) {
                return;
            }
            this.mLoading = true;
            this.root.setVisibility(0);
            this.mListView.setSelection(this.mListView.getCount() - 1);
            if (this.mLoadListener != null) {
                this.mLoadListener.onLoad();
            }
        }
    }

    public void openLoadListener() {
        if (this.canLoadMore()) {
            this.load();
        }
    }

    private boolean canLoadMore() {
        return this.isListViewBottom() && this.isPullUp() && !this.mLoading;
    }

    private boolean isListViewBottom() {
        return this.mListView.getChildCount() > 0 && this.mListView.getLastVisiblePosition() == this.mListView.getCount() - 1 && this.mListView.getChildAt(this.mListView.getChildCount() - 2).getBottom() <= this.mListView.getHeight() - this.mListView.getPaddingBottom();
    }

    private boolean isPullUp() {
        LogUtil.debug("downY - moveY" + (this.downY - this.moveY));
        LogUtil.debug("mTouchSlop : " + this.mTouchSlop);
        return this.downY - this.moveY >= (float)this.mTouchSlop;
    }

    public void setOnLoadListener(OnLoadListener loadListener) {
        this.mLoadListener = loadListener;
    }

    public void setLoadingComplete() {
        this.mLoading = false;
        this.root.setVisibility(8);
    }

    private void setLoadingView(View footerView) {
        if (footerView == null || this.mListView.getFooterViewsCount() != 0) {
            return;
        }
        this.mListView.addFooterView(footerView);
    }

    public void setOnRefreshDealListener(OnRefreshDealListener refreshDealListener) {
        this.mRefreshDealListener = refreshDealListener;
    }

    public void setOnRefreshListener(SwipeRefreshLayout.OnRefreshListener listener) {
        if (this.refreshListenerFlag) {
            super.setOnRefreshListener(listener);
            this.refreshListenerFlag = false;
        } else {
            LogUtil.debug("\u8bf7\u4f7f\u7528setOnRefreshDealListener\u65b9\u6cd5");
        }
    }

    public void startRefresh(OnRefreshByHandListener handListener) {
        if (this.mLoading) {
            handListener.onLoading();
        } else if (this.isRefreshing()) {
            handListener.onRefreshing();
        } else {
            this.setRefreshing(true);
            handListener.onRefresh();
        }
    }

    public boolean isLoading() {
        return this.mLoading;
    }

    public void setRefreshingComplete() {
        this.setRefreshing(false);
    }

    public static interface OnRefreshByHandListener {
        public void onLoading();

        public void onRefreshing();

        public void onRefresh();
    }

    public static interface OnRefreshDealListener {
        public void onLoading();

        public void onRefresh();
    }

    public static interface OnLoadListener {
        public void onRefreshing();

        public void onLoad();
    }
}

