/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util.view.clip;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;

public class ClipView
extends View {
    private Paint paint = new Paint();
    private Paint borderPaint = new Paint();
    private float mHorizontalPadding;
    private int clipBorderWidth;
    private int clipRadiusWidth;
    private int clipWidth;
    private ClipType clipType = ClipType.CIRCLE;
    private Xfermode xfermode;

    public ClipView(Context context) {
        this(context, null);
    }

    public ClipView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ClipView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.paint.setAntiAlias(true);
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setColor(-1);
        this.borderPaint.setStrokeWidth((float)this.clipBorderWidth);
        this.borderPaint.setAntiAlias(true);
        this.xfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_OUT);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null);
        canvas.drawColor(Color.parseColor((String)"#a8000000"));
        this.paint.setXfermode(this.xfermode);
        if (this.clipType == ClipType.CIRCLE) {
            canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)this.clipRadiusWidth, this.paint);
            canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)this.clipRadiusWidth, this.borderPaint);
        } else if (this.clipType == ClipType.RECTANGLE) {
            canvas.drawRect(this.mHorizontalPadding, (float)(this.getHeight() / 2 - this.clipWidth / 2), (float)this.getWidth() - this.mHorizontalPadding, (float)(this.getHeight() / 2 + this.clipWidth / 2), this.paint);
            canvas.drawRect(this.mHorizontalPadding, (float)(this.getHeight() / 2 - this.clipWidth / 2), (float)this.getWidth() - this.mHorizontalPadding, (float)(this.getHeight() / 2 + this.clipWidth / 2), this.borderPaint);
        }
        canvas.restore();
    }

    public Rect getClipRect() {
        Rect rect = new Rect();
        rect.left = this.getWidth() / 2 - this.clipRadiusWidth;
        rect.right = this.getWidth() / 2 + this.clipRadiusWidth;
        rect.top = this.getHeight() / 2 - this.clipRadiusWidth;
        rect.bottom = this.getHeight() / 2 + this.clipRadiusWidth;
        return rect;
    }

    public void setClipBorderWidth(int clipBorderWidth) {
        this.clipBorderWidth = clipBorderWidth;
        this.borderPaint.setStrokeWidth((float)clipBorderWidth);
        this.invalidate();
    }

    public void setmHorizontalPadding(float mHorizontalPadding) {
        this.mHorizontalPadding = mHorizontalPadding;
        this.clipRadiusWidth = (int)((float)ClipView.getScreenWidth(this.getContext()) - 2.0f * mHorizontalPadding) / 2;
        this.clipWidth = this.clipRadiusWidth * 2;
    }

    public static int getScreenWidth(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.widthPixels;
    }

    public void setClipType(ClipType clipType) {
        this.clipType = clipType;
    }

    public static enum ClipType {
        CIRCLE,
        RECTANGLE;

    }
}

