/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util.view.xlist;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.Scroller;
import android.widget.TextView;
import com.sdk.douyou.util.ResourceUtil;
import com.sdk.douyou.util.view.xlist.XFooterView;
import com.sdk.douyou.util.view.xlist.XHeaderView;

public class XListView
extends ListView
implements AbsListView.OnScrollListener {
    private static final int SCROLL_BACK_HEADER = 0;
    private static final int SCROLL_BACK_FOOTER = 1;
    private static final int SCROLL_DURATION = 400;
    private static final int PULL_LOAD_MORE_DELTA = 50;
    private static final float OFFSET_RADIO = 1.8f;
    private float mLastY = -1.0f;
    private Scroller mScroller;
    private AbsListView.OnScrollListener mScrollListener;
    private int mScrollBack;
    private IXListViewListener mListener;
    private XHeaderView mHeader;
    private RelativeLayout mHeaderContent;
    private TextView mHeaderTime;
    private int mHeaderHeight;
    private LinearLayout mFooterLayout;
    private XFooterView mFooterView;
    private boolean mIsFooterReady = false;
    private boolean mEnablePullRefresh = true;
    private boolean mPullRefreshing = false;
    private boolean mEnablePullLoad = true;
    private boolean mEnableAutoLoad = false;
    private boolean mPullLoading = false;
    private int mTotalItemCount;

    public XListView(Context context) {
        super(context);
        this.initWithContext(context);
    }

    public XListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initWithContext(context);
    }

    public XListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initWithContext(context);
    }

    private void initWithContext(Context context) {
        this.mScroller = new Scroller(context, (Interpolator)new DecelerateInterpolator());
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.mHeader = new XHeaderView(context);
        this.mHeaderContent = (RelativeLayout)this.mHeader.findViewById(ResourceUtil.getId(context, "header_content"));
        this.mHeaderTime = (TextView)this.mHeader.findViewById(ResourceUtil.getId(context, "header_hint_time"));
        this.addHeaderView((View)this.mHeader);
        this.mFooterView = new XFooterView(context);
        this.mFooterLayout = new LinearLayout(context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        params.gravity = 17;
        this.mFooterLayout.addView((View)this.mFooterView, (ViewGroup.LayoutParams)params);
        ViewTreeObserver observer = this.mHeader.getViewTreeObserver();
        if (null != observer) {
            observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                @TargetApi(value=16)
                public void onGlobalLayout() {
                    XListView.this.mHeaderHeight = XListView.this.mHeaderContent.getHeight();
                    ViewTreeObserver observer = XListView.this.getViewTreeObserver();
                    if (null != observer) {
                        if (Build.VERSION.SDK_INT < 16) {
                            observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            observer.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                    }
                }
            });
        }
    }

    public void setAdapter(ListAdapter adapter) {
        if (!this.mIsFooterReady) {
            this.mIsFooterReady = true;
            this.addFooterView((View)this.mFooterLayout);
        }
        super.setAdapter(adapter);
    }

    public void setPullRefreshEnable(boolean enable) {
        this.mEnablePullRefresh = enable;
        this.mHeaderContent.setVisibility(enable ? 0 : 4);
    }

    public void setPullLoadEnable(boolean enable) {
        this.mEnablePullLoad = enable;
        if (!this.mEnablePullLoad) {
            this.mFooterView.setBottomMargin(0);
            this.mFooterView.hide();
            this.mFooterView.setPadding(0, 0, 0, 0);
            this.mFooterView.setOnClickListener(null);
        } else {
            this.mPullLoading = false;
            this.mFooterView.setPadding(0, 0, 0, 0);
            this.mFooterView.show();
            this.mFooterView.setState(0);
            this.mFooterView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XListView.this.startLoadMore();
                }
            });
        }
    }

    public void setAutoLoadEnable(boolean enable) {
        this.mEnableAutoLoad = enable;
    }

    public void stopRefresh() {
        if (this.mPullRefreshing) {
            this.mPullRefreshing = false;
            this.resetHeaderHeight();
        }
    }

    public void stopLoadMore() {
        if (this.mPullLoading) {
            this.mPullLoading = false;
            this.mFooterView.setState(0);
        }
    }

    public void setRefreshTime(String time) {
        this.mHeaderTime.setText((CharSequence)time);
    }

    public void setXListViewListener(IXListViewListener listener) {
        this.mListener = listener;
    }

    public void autoRefresh() {
        this.mHeader.setVisibleHeight(this.mHeaderHeight);
        if (this.mEnablePullRefresh && !this.mPullRefreshing) {
            if (this.mHeader.getVisibleHeight() > this.mHeaderHeight) {
                this.mHeader.setState(1);
            } else {
                this.mHeader.setState(0);
            }
        }
        this.mPullRefreshing = true;
        this.mHeader.setState(2);
        this.refresh();
    }

    private void invokeOnScrolling() {
        if (this.mScrollListener instanceof OnXScrollListener) {
            OnXScrollListener listener = (OnXScrollListener)this.mScrollListener;
            listener.onXScrolling((View)this);
        }
    }

    private void updateHeaderHeight(float delta) {
        this.mHeader.setVisibleHeight((int)delta + this.mHeader.getVisibleHeight());
        if (this.mEnablePullRefresh && !this.mPullRefreshing) {
            if (this.mHeader.getVisibleHeight() > this.mHeaderHeight) {
                this.mHeader.setState(1);
            } else {
                this.mHeader.setState(0);
            }
        }
        this.setSelection(0);
    }

    private void resetHeaderHeight() {
        int height = this.mHeader.getVisibleHeight();
        if (height == 0) {
            return;
        }
        if (this.mPullRefreshing && height <= this.mHeaderHeight) {
            return;
        }
        int finalHeight = 0;
        if (this.mPullRefreshing && height > this.mHeaderHeight) {
            finalHeight = this.mHeaderHeight;
        }
        this.mScrollBack = 0;
        this.mScroller.startScroll(0, height, 0, finalHeight - height, 400);
        this.invalidate();
    }

    private void updateFooterHeight(float delta) {
        int height = this.mFooterView.getBottomMargin() + (int)delta;
        if (this.mEnablePullLoad && !this.mPullLoading) {
            if (height > 50) {
                this.mFooterView.setState(1);
            } else {
                this.mFooterView.setState(0);
            }
        }
        this.mFooterView.setBottomMargin(height);
    }

    private void resetFooterHeight() {
        int bottomMargin = this.mFooterView.getBottomMargin();
        if (bottomMargin > 0) {
            this.mScrollBack = 1;
            this.mScroller.startScroll(0, bottomMargin, 0, -bottomMargin, 400);
            this.invalidate();
        }
    }

    private void startLoadMore() {
        this.mPullLoading = true;
        this.mFooterView.setState(2);
        this.loadMore();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mLastY == -1.0f) {
            this.mLastY = ev.getRawY();
        }
        switch (ev.getAction()) {
            case 0: {
                this.mLastY = ev.getRawY();
                break;
            }
            case 2: {
                float deltaY = ev.getRawY() - this.mLastY;
                this.mLastY = ev.getRawY();
                if (this.getFirstVisiblePosition() == 0 && (this.mHeader.getVisibleHeight() > 0 || deltaY > 0.0f)) {
                    this.updateHeaderHeight(deltaY / 1.8f);
                    this.invokeOnScrolling();
                    break;
                }
                if (this.getLastVisiblePosition() != this.mTotalItemCount - 1 || this.mFooterView.getBottomMargin() <= 0 && !(deltaY < 0.0f)) break;
                this.updateFooterHeight(-deltaY / 1.8f);
                break;
            }
            default: {
                this.mLastY = -1.0f;
                if (this.getFirstVisiblePosition() == 0) {
                    if (this.mEnablePullRefresh && this.mHeader.getVisibleHeight() > this.mHeaderHeight) {
                        this.mPullRefreshing = true;
                        this.mHeader.setState(2);
                        this.refresh();
                    }
                    this.resetHeaderHeight();
                    break;
                }
                if (this.getLastVisiblePosition() != this.mTotalItemCount - 1) break;
                if (this.mEnablePullLoad && this.mFooterView.getBottomMargin() > 50) {
                    this.startLoadMore();
                }
                this.resetFooterHeight();
            }
        }
        return super.onTouchEvent(ev);
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            if (this.mScrollBack == 0) {
                this.mHeader.setVisibleHeight(this.mScroller.getCurrY());
            } else {
                this.mFooterView.setBottomMargin(this.mScroller.getCurrY());
            }
            this.postInvalidate();
            this.invokeOnScrolling();
        }
        super.computeScroll();
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mScrollListener = l;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(view, scrollState);
        }
        if (scrollState == 0 && this.mEnableAutoLoad && this.getLastVisiblePosition() == this.getCount() - 1) {
            this.startLoadMore();
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        this.mTotalItemCount = totalItemCount;
        if (this.mScrollListener != null) {
            this.mScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }

    private void refresh() {
        if (this.mEnablePullRefresh && null != this.mListener) {
            this.mListener.onRefresh();
        }
    }

    private void loadMore() {
        if (this.mEnablePullLoad && null != this.mListener) {
            this.mListener.onLoadMore();
        }
    }

    public static interface IXListViewListener {
        public void onRefresh();

        public void onLoadMore();
    }

    public static interface OnXScrollListener
    extends AbsListView.OnScrollListener {
        public void onXScrolling(View var1);
    }
}

