/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.fun;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;
import com.bytedance.applog.AppLog;
import com.bytedance.applog.ILogger;
import com.bytedance.applog.IOaidObserver;
import com.bytedance.applog.InitConfig;
import com.bytedance.applog.game.GameReportHelper;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.adapter.DouYouSDKListenerAdapter;
import com.sdk.douyou.bean.OrderInfoBean;
import com.sdk.douyou.bean.RoleInfoBean;
import com.sdk.douyou.data.DouYouDataCollection;
import com.sdk.douyou.listen.DouYouSDKListener;
import com.sdk.douyou.listen.DouyouActivityCallback;
import com.sdk.douyou.util.DouYouSDKTools;
import com.sdk.douyou.util.LogUtil;
import com.sdk.douyou.util.net.BaLeApi;
import com.sdk.douyou.util.net.DouYouPostAsyncTask;
import org.json.JSONException;
import org.json.JSONObject;

public class TouTiaoManagement {
    private Activity activity;
    private String ssid;
    private String did;
    private String iid;
    private String APPID;
    private String APPName;
    private String Channel;
    private static TouTiaoManagement instance;

    public static TouTiaoManagement getInstance() {
        if (instance == null) {
            instance = new TouTiaoManagement();
        }
        return instance;
    }

    public void initSDK(Activity context) {
        this.activity = context;
        this.getParams(context);
        this.init(context);
    }

    private void getParams(Activity context) {
        this.APPID = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_APP_ID");
        this.APPName = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_APP_NAME");
        this.Channel = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_CHANNEL");
        Log.e((String)"DYTouTiao", (String)("APPID: " + this.APPID));
        Log.e((String)"DYTouTiao", (String)("APPName: " + this.APPName));
        Log.e((String)"DYTouTiao", (String)("Channel: " + this.Channel));
    }

    private void init(final Activity context) {
        Log.e((String)"DYTouTiao", (String)"toutiao  sdk-V6.14.3 init: start ");
        final InitConfig config = new InitConfig(this.APPID, this.Channel);
        config.setUriConfig(0);
        config.setLogger(new ILogger(){

            public void log(String msg, Throwable throwable) {
                Log.e((String)"DYTouTiao", (String)("s:" + msg));
            }
        });
        config.setEnablePlay(true);
        config.setAbEnable(true);
        config.setAutoStart(true);
        config.setImeiEnable(false);
        config.setAutoTrackEnabled(true);
        config.setLogEnable(true);
        AppLog.setEncryptAndCompress((boolean)true);
        this.ssid = AppLog.getSsid();
        this.did = AppLog.getDid();
        this.iid = AppLog.getIid();
        BaLeApi.getInstance().channelReport("0", "", DouYou.getInstance().getAdId(), new DouYouPostAsyncTask.HttpGetDataListener(){

            public void getData(String returnData) {
                Log.e((String)"DYTouTiao", (String)"active");
                try {
                    JSONObject objdata = new JSONObject(returnData);
                    int is_report = objdata.optInt("is_report", 0);
                    Log.e((String)"DYTouTiao", (String)("active-is_report: " + is_report));
                    if (is_report == 1) {
                        AppLog.init((Context)context, (InitConfig)config);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            public void Fail(String error) {
                LogUtil.debug((String)error);
            }
        });
        Log.e((String)"DYTouTiao", (String)"toutiao sdk init: end");
        DouYou.getInstance().setSDKListener((DouYouSDKListener)new DouYouSDKListenerAdapter(){

            public void onPayResult(int code, OrderInfoBean params) {
                switch (code) {
                    case 10: {
                        Log.e((String)"DYTouTiao", (String)"pay success");
                        TouTiaoManagement.this.purchase(params, true);
                        Log.e((String)"DYTouTiao", (String)"toutiao pay success");
                    }
                }
            }

            public void onResult(int code, String msg) {
                switch (code) {
                    case 41: {
                        Log.e((String)"DYTouTiao", (String)"extra data");
                        TouTiaoManagement.this.setUpdateLevel(DouYouDataCollection.getInstance().getRoleInfoBean());
                        Log.e((String)"DYTouTiao", (String)"toutiao extra data");
                        break;
                    }
                    case 39: {
                        Log.e((String)"DYTouTiao", (String)"register success");
                        TouTiaoManagement.this.setRegister("wechat", true);
                        Log.e((String)"DYTouTiao", (String)"toutiao register success");
                    }
                }
            }
        });
        DouYou.getInstance().setActivityCallback(new DouyouActivityCallback(){

            public void onCreate(Bundle savedInstanceState) {
            }

            public void onStart() {
            }

            public void onPause() {
                Log.e((String)"DYTouTiao", (String)"onPause: ");
                AppLog.onPause((Context)context);
            }

            public void onResume() {
                Log.e((String)"DYTouTiao", (String)"onResume: ");
                AppLog.onResume((Context)context);
            }

            public void onStop() {
            }

            public void onDestroy() {
            }

            public void onRestart() {
            }

            public void onBackPressed() {
            }

            public void onNewIntent(Intent newIntent) {
            }

            public void onConfigurationChanged(Configuration newConfig) {
            }

            public void onSaveInstanceState(Bundle paramBundle) {
            }

            public void onActivityResult(int requestCode, int resultCode, Intent data) {
            }

            public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
            }

            public void onWindowFocusChanged(boolean paramBoolean) {
            }
        });
    }

    private void setRegister(final String method, final boolean is_success) {
        this.ssid = AppLog.getSsid();
        this.did = AppLog.getDid();
        this.iid = AppLog.getIid();
        BaLeApi.getInstance().channelReport("1", "", DouYou.getInstance().getAdId(), new DouYouPostAsyncTask.HttpGetDataListener(){

            public void getData(String returnData) {
                Log.e((String)"DYTouTiao", (String)"setRegister");
                Log.e((String)"DYTouTiao", (String)("method: " + method));
                try {
                    JSONObject objdata = new JSONObject(returnData);
                    int is_report = objdata.optInt("is_report", 0);
                    Log.e((String)"DYTouTiao", (String)("setRegister-is_report: " + is_report));
                    if (is_report == 1) {
                        GameReportHelper.onEventRegister((String)"wechat", (boolean)is_success);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            public void Fail(String error) {
                LogUtil.debug((String)error);
            }
        });
    }

    private void purchase(final OrderInfoBean params, final boolean is_success) {
        AppLog.setOaidObserver((IOaidObserver)new IOaidObserver(){

            public void onOaidLoaded(IOaidObserver.Oaid oaid) {
                Log.e((String)"DYTouTiao", (String)("\u5934\u6761\u81ea\u5df1\u751f\u6210\u7684oaid : " + oaid.id));
            }
        });
        this.ssid = AppLog.getSsid();
        this.did = AppLog.getDid();
        this.iid = AppLog.getIid();
        BaLeApi.getInstance().channelReport("2", params.getXxx(), DouYou.getInstance().getAdId(), new DouYouPostAsyncTask.HttpGetDataListener(){

            public void getData(String returnData) {
                block5: {
                    Log.e((String)"DYTouTiao", (String)("purchase: " + is_success));
                    Log.e((String)"DYTouTiao", (String)("price: " + Double.valueOf(params.getCpOrderMoney().trim()).intValue() + "\u5143"));
                    try {
                        JSONObject objdata = new JSONObject(returnData);
                        int is_report = objdata.optInt("is_report", 0);
                        String report_money_str = objdata.optString("report_money", "");
                        float report_money = Double.valueOf(report_money_str).floatValue();
                        LogUtil.debug((String)("DYTouTiao- purchase-is_report: " + is_report));
                        LogUtil.debug((String)("DYTouTiao- purchase-report_money: " + (int)report_money));
                        if (is_report == 1) {
                            GameReportHelper.onEventPurchase((String)params.getProductName(), (String)params.getProductName(), (String)params.getProductId(), (int)1, null, (String)"\u00a5", (boolean)is_success, (int)((int)report_money));
                        }
                        if (Double.valueOf(params.getCpOrderMoney().trim()).intValue() != 30) break block5;
                        JSONObject paramsObj = new JSONObject();
                        try {
                            paramsObj.put("origin_event", (Object)"game_addiction");
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        AppLog.onEventV3((String)"game_addiction", (JSONObject)paramsObj);
                        Log.e((String)"DYTouTiao", (String)("game_addiction:" + paramsObj.toString()));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void Fail(String error) {
                LogUtil.debug((String)error);
            }
        });
    }

    private void setUpdateLevel(RoleInfoBean data) {
        Log.e((String)"DYTouTiao", (String)"setUpdateLevel");
        Log.e((String)"DYTouTiao", (String)("dataType: " + data.getType()));
        if (data.getType() == 0) {
            return;
        }
        if (data.getType() == 2) {
            GameReportHelper.onEventCreateGameRole((String)data.getId());
        } else {
            GameReportHelper.onEventUpdateLevel((int)Integer.parseInt(data.getLevel()));
        }
        BaLeApi.getInstance().channelReport("3", "", DouYou.getInstance().getAdId(), new DouYouPostAsyncTask.HttpGetDataListener(){

            public void getData(String returnData) {
            }

            public void Fail(String error) {
                LogUtil.debug((String)error);
            }
        });
    }
}

