/*
 * Decompiled with CFR 0.152.
 */
package com.taptapshare;

import android.net.Uri;
import com.taptapshare.TapTapShare;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class TapTapShareBuilder {
    private JSONObject jsonParams = new JSONObject();
    private ArrayList<Uri> imageUris;

    public ArrayList<Uri> getImageUris() {
        return this.imageUris;
    }

    public String getTapParamsString() {
        if (this.jsonParams == null) {
            return null;
        }
        return this.jsonParams.toString();
    }

    public TapTapShare build() {
        return new TapTapShare(this);
    }

    public TapTapShareBuilder addTitle(String title) {
        try {
            this.jsonParams.put("title", (Object)title);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public TapTapShareBuilder addContents(String contents) {
        try {
            this.jsonParams.put("contents", (Object)contents);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public TapTapShareBuilder addHashtagIds(String hashtag_ids) {
        try {
            this.jsonParams.put("hashtag_ids", (Object)hashtag_ids);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public TapTapShareBuilder addAppId(String app_id) {
        try {
            this.jsonParams.put("app_id", (Object)app_id);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public TapTapShareBuilder addGroupLabelId(String group_label_id) {
        try {
            this.jsonParams.put("group_label_id", (Object)group_label_id);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public TapTapShareBuilder addFooterImageUrls(ArrayList<Uri> footer_image_urls) {
        this.imageUris = footer_image_urls;
        return this;
    }

    public TapTapShareBuilder addFailUrl(String fail_url) {
        try {
            this.jsonParams.put("fail_url", (Object)fail_url);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public String getFailUrl() {
        if (this.jsonParams != null) {
            try {
                return this.jsonParams.getString("fail_url");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getAppId() {
        if (this.jsonParams != null) {
            try {
                return this.jsonParams.getString("app_id");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

