/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.dialog.news.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.bean.CommunityBean;
import com.sdk.douyou.util.LogUtil;
import com.sdk.douyou.util.ResourceUtil;
import com.sdk.douyou.util.net.BaLeApi;
import com.sdk.douyou.util.net.DouYouPostAsyncTask;
import com.sdk.douyou.util.net.ImageDownloaderTask;
import com.sdk.douyou.util.view.ChildClickableLinearLayout;
import com.sdk.douyou.util.view.xlist.XListView;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import jxp.android.support.v4.app.Fragment;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CommunityFragment
extends Fragment {
    private List<CommunityBean> list = new ArrayList<CommunityBean>();
    private int page = 1;
    private Activity activity;
    private XListView douyou_ball_community_lv;
    private CommunityListAdapter communityListAdapter;
    private Handler mHandlerCoupon;
    private ChildClickableLinearLayout dy_ball_coupon_LL;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.getData(0);
        this.activity = this.getActivity();
        View v = LayoutInflater.from((Context)this.getActivity()).inflate(ResourceUtil.getLayoutId((Context)this.getActivity(), "douyou_ball_community"), null);
        this.douyou_ball_community_lv = (XListView)v.findViewById(ResourceUtil.getId((Context)this.getActivity(), "douyou_ball_community_lv"));
        this.douyou_ball_community_lv.setPullRefreshEnable(false);
        this.douyou_ball_community_lv.setPullLoadEnable(false);
        this.douyou_ball_community_lv.setAutoLoadEnable(false);
        this.communityListAdapter = new CommunityListAdapter((Context)this.activity, ResourceUtil.getLayoutId((Context)this.activity, "douyou_ball_community_list"), this.list);
        this.douyou_ball_community_lv.setAdapter((ListAdapter)this.communityListAdapter);
        return v;
    }

    private void getData(int page) {
        BaLeApi.getInstance().community(new DouYouPostAsyncTask.HttpGetDataListener(){

            @Override
            public void getData(String returnData) {
                try {
                    JSONObject community_list = new JSONObject(returnData);
                    JSONArray jsonArray = new JSONArray(community_list.optString("community_list", ""));
                    if (jsonArray.length() > 0) {
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            CommunityBean communityBean = new CommunityBean();
                            JSONObject jsonObject = jsonArray.getJSONObject(i);
                            communityBean.setId(jsonObject.optInt("id", 0));
                            communityBean.setTitle(jsonObject.optString("title", ""));
                            communityBean.setIcon_url(jsonObject.optString("icon_url", ""));
                            communityBean.setJump_url(jsonObject.optString("jump_url", ""));
                            CommunityFragment.this.list.add(communityBean);
                        }
                    }
                    CommunityFragment.this.communityListAdapter.notifyDataSetChanged();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    LogUtil.debug("\u6570\u636e\u89e3\u6790\u5f02\u5e38");
                }
            }

            @Override
            public void Fail(String error) {
                LogUtil.debug(error);
            }
        });
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (!hidden) {
            this.page = 1;
            this.list.clear();
            this.getData(this.page);
        }
    }

    private static class CommunityListAdapter
    extends ArrayAdapter<CommunityBean> {
        private int resourceId;
        private Context mcontext;

        public CommunityListAdapter(Context context, int textViewResourceId, List<CommunityBean> objects) {
            super(context, textViewResourceId, objects);
            this.resourceId = textViewResourceId;
            this.mcontext = context;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder;
            final CommunityBean item = (CommunityBean)this.getItem(position);
            if (convertView == null) {
                viewHolder = new ViewHolder();
                convertView = LayoutInflater.from((Context)this.getContext()).inflate(this.resourceId, null);
                viewHolder.douyou_ball_community_icon = (ImageView)convertView.findViewById(ResourceUtil.getId(this.mcontext, "douyou_ball_community_icon"));
                viewHolder.douyou_ball_community_title = (TextView)convertView.findViewById(ResourceUtil.getId(this.mcontext, "douyou_ball_community_title"));
                viewHolder.douyou_ball_community_btn = (TextView)convertView.findViewById(ResourceUtil.getId(this.mcontext, "douyou_ball_community_btn"));
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            viewHolder.douyou_ball_community_title.setText((CharSequence)item.getTitle());
            if (!TextUtils.isEmpty((CharSequence)item.getJump_url())) {
                viewHolder.douyou_ball_community_btn.setVisibility(0);
                viewHolder.douyou_ball_community_btn.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Intent intent = null;
                        try {
                            intent = Intent.parseUri((String)item.getJump_url(), (int)1);
                        }
                        catch (URISyntaxException e) {
                            throw new RuntimeException(e);
                        }
                        DouYou.getInstance().context.startActivity(intent);
                    }
                });
            }
            new ImageDownloaderTask(viewHolder.douyou_ball_community_icon).execute(new String[]{item.getIcon_url()});
            return convertView;
        }

        class ViewHolder {
            ImageView douyou_ball_community_icon;
            TextView douyou_ball_community_title;
            TextView douyou_ball_community_btn;

            ViewHolder() {
            }
        }
    }
}

