/*
 * Decompiled with CFR 0.152.
 */
package jxp.android.support.v4.provider;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.DocumentsContract;
import android.util.Log;
import java.util.ArrayList;

class DocumentsContractApi21 {
    private static final String TAG = "DocumentFile";

    DocumentsContractApi21() {
    }

    public static Uri createFile(Context context, Uri self, String mimeType, String displayName) {
        return DocumentsContract.createDocument((ContentResolver)context.getContentResolver(), (Uri)self, (String)mimeType, (String)displayName);
    }

    public static Uri createDirectory(Context context, Uri self, String displayName) {
        return DocumentsContractApi21.createFile(context, self, "vnd.android.document/directory", displayName);
    }

    public static Uri prepareTreeUri(Uri treeUri) {
        return DocumentsContract.buildDocumentUriUsingTree((Uri)treeUri, (String)DocumentsContract.getTreeDocumentId((Uri)treeUri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Uri[] listFiles(Context context, Uri self) {
        ContentResolver resolver = context.getContentResolver();
        Uri childrenUri = DocumentsContract.buildChildDocumentsUriUsingTree((Uri)self, (String)DocumentsContract.getDocumentId((Uri)self));
        ArrayList<Uri> results = new ArrayList<Uri>();
        Cursor c = null;
        try {
            c = resolver.query(childrenUri, new String[]{"document_id"}, null, null, null);
            while (c.moveToNext()) {
                String documentId = c.getString(0);
                Uri documentUri = DocumentsContract.buildDocumentUriUsingTree((Uri)self, (String)documentId);
                results.add(documentUri);
            }
        }
        catch (Exception e) {
            try {
                Log.w((String)TAG, (String)("Failed query: " + e));
            }
            catch (Throwable throwable) {
                DocumentsContractApi21.closeQuietly(c);
                throw throwable;
            }
            DocumentsContractApi21.closeQuietly((AutoCloseable)c);
        }
        DocumentsContractApi21.closeQuietly((AutoCloseable)c);
        return results.toArray(new Uri[results.size()]);
    }

    public static Uri renameTo(Context context, Uri self, String displayName) {
        return DocumentsContract.renameDocument((ContentResolver)context.getContentResolver(), (Uri)self, (String)displayName);
    }

    private static void closeQuietly(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

