/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.log;

import android.text.TextUtils;
import android.util.Log;
import com.tds.common.log.entities.LogConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Logger {
    private static Map<String, Logger> mTagCache = new ConcurrentHashMap<String, Logger>();
    private LogConfig logConfig;
    private String tag;

    public static void init(LogConfig logConfig) {
        Logger.getLogger(logConfig);
    }

    public static Logger getLogger(LogConfig logConfig) {
        if (logConfig.sdkName.isEmpty()) {
            throw new IllegalArgumentException("topic name empty");
        }
        String name = "";
        if (!TextUtils.isEmpty((CharSequence)logConfig.sdkName)) {
            name = name + logConfig.sdkName;
        }
        if (mTagCache.containsKey(name)) {
            return mTagCache.get(name);
        }
        Logger logger = new Logger(name);
        logger.logConfig = logConfig;
        mTagCache.put(logConfig.sdkName, logger);
        return logger;
    }

    public static Logger get(String sdkName) {
        return Logger.getLogger(new LogConfig.Builder().withTopic(sdkName).build(null));
    }

    public static Logger getCommonLogger() {
        return Logger.getLogger(new LogConfig.Builder().withTopic("common_log").withSdkVersionCode(31605001).withSdkVersionName("3.16.5").build(null));
    }

    private Logger(String tag) {
        this.tag = "TDS-" + tag;
    }

    public void v(String msg) {
        this.v("", msg);
    }

    public void v(String customTag, String msg) {
        Log.v((String)this.getCombinationTag(customTag), (String)msg);
        this.logInfo(customTag, msg);
    }

    public void v(String msg, Throwable tr) {
        this.v("", msg, tr);
    }

    public void v(String customTag, String msg, Throwable tr) {
        Log.v((String)this.getCombinationTag(customTag), (String)msg, (Throwable)tr);
        this.logInfo(customTag, msg);
    }

    public void d(String msg) {
        this.d("", msg);
    }

    public void d(String customTag, String msg) {
        Log.d((String)this.getCombinationTag(customTag), (String)msg);
        this.logInfo(customTag, msg);
    }

    public void d(String msg, Throwable tr) {
        this.d("", msg, tr);
    }

    public void d(String customTag, String msg, Throwable tr) {
        Log.d((String)this.getCombinationTag(customTag), (String)msg, (Throwable)tr);
        this.logInfo(customTag, msg);
    }

    public void i(String msg) {
        this.i("", msg);
    }

    public void i(String customTag, String msg) {
        Log.i((String)this.getCombinationTag(customTag), (String)msg);
        this.logInfo(customTag, msg);
    }

    public void i(String msg, Throwable tr) {
        this.i("", msg, tr);
    }

    public void i(String customTag, String msg, Throwable tr) {
        Log.i((String)this.getCombinationTag(customTag), (String)msg, (Throwable)tr);
        this.logInfo(customTag, msg);
    }

    public void w(String msg) {
        this.w("", msg);
    }

    public void w(String customTag, String msg) {
        Log.w((String)this.getCombinationTag(customTag), (String)msg);
    }

    public void w(Throwable tr) {
        this.w("", tr);
    }

    public void w(String customTag, Throwable tr) {
        Log.w((String)this.getCombinationTag(customTag), (Throwable)tr);
    }

    public void e(String msg) {
        this.e("", msg);
    }

    public void e(String customTag, String msg) {
        Log.e((String)this.getCombinationTag(customTag), (String)msg);
    }

    public void e(Throwable tr) {
        this.e("", tr);
    }

    public void e(String msg, Throwable tr) {
        this.e("", msg, tr);
    }

    public void e(String customTag, String msg, Throwable tr) {
        Log.e((String)this.getCombinationTag(customTag), (String)msg, (Throwable)tr);
    }

    public void logInfo(String tag, String logMessage) {
    }

    private String getCombinationTag(String customTag) {
        if (!TextUtils.isEmpty((CharSequence)customTag)) {
            return this.tag + "-" + customTag;
        }
        return this.tag;
    }
}

