/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.net;

import android.text.TextUtils;
import com.tds.common.localize.LocalizeManager;
import com.tds.common.net.PlatformXUA;
import com.tds.common.utils.DeviceUtils;
import com.tds.common.utils.GUIDHelper;
import java.util.HashMap;
import java.util.Map;

public class XUAParams {
    private final String platform;
    private final String osVersion;
    private final String sdkName;
    private final int sdkVersionCode;
    private final String sdkVersionName;
    private final String lang;
    private final String deviceId;
    private TapDBDataObserver tapDBDataObserver;

    public XUAParams(Builder builder) {
        this.platform = builder.platform;
        this.osVersion = builder.osVersion;
        this.sdkName = builder.sdkName;
        this.sdkVersionCode = builder.sdkVersionCode;
        this.sdkVersionName = builder.sdkVersionName;
        this.lang = builder.lang;
        this.deviceId = builder.deviceId;
    }

    public void setTapDBDataObserver(TapDBDataObserver observer) {
        this.tapDBDataObserver = observer;
    }

    public static XUAParams getCommonXUAParams(String sdkName, int sdkVersionCode, String sdkVersionName) {
        Builder builder = new Builder().headersPlatform(DeviceUtils.getPlatform()).headersOSVersion(DeviceUtils.getOSVersion()).headersDeviceId(GUIDHelper.INSTANCE.getUID()).headersLang(LocalizeManager.getPreferredLanguageString()).headersSdkName(sdkName).headersSdkVersionCode(sdkVersionCode).headersSdkVersionName(sdkVersionName);
        return builder.build();
    }

    public String getXUAValue() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)this.platform)) {
            headerMap.put("Platform", this.platform);
        }
        if (!TextUtils.isEmpty((CharSequence)this.osVersion)) {
            headerMap.put("OS-Version", this.osVersion);
        }
        if (!TextUtils.isEmpty((CharSequence)this.sdkName)) {
            headerMap.put("SDK-Name", this.sdkName);
        }
        if (this.sdkVersionCode != Integer.MIN_VALUE) {
            headerMap.put("SDK-Version-Code", String.valueOf(this.sdkVersionCode));
        }
        if (!TextUtils.isEmpty((CharSequence)this.sdkVersionName)) {
            headerMap.put("SDK-Version-Name", this.sdkVersionName);
        }
        headerMap.put("Lang", LocalizeManager.getPreferredLanguageString());
        String tapDBDeviceId = "";
        if (this.tapDBDataObserver != null) {
            tapDBDeviceId = this.tapDBDataObserver.getTapDBDeviceId();
        }
        if (!TextUtils.isEmpty((CharSequence)tapDBDeviceId)) {
            headerMap.put("Device-ID", tapDBDeviceId);
        } else if (!TextUtils.isEmpty((CharSequence)this.deviceId)) {
            headerMap.put("Device-ID", this.deviceId);
        }
        Map<String, String> platformXua = PlatformXUA.getInstance().xuaMap;
        if (platformXua != null && platformXua.size() > 0) {
            headerMap.putAll(platformXua);
        }
        StringBuilder xuaStringBuilder = new StringBuilder();
        for (Map.Entry entry : headerMap.entrySet()) {
            if (xuaStringBuilder.length() != 0) {
                xuaStringBuilder.append("&");
            }
            xuaStringBuilder.append((String)entry.getKey());
            xuaStringBuilder.append("=");
            xuaStringBuilder.append((String)entry.getValue());
        }
        return xuaStringBuilder.toString();
    }

    public static final class Builder {
        private String platform;
        private String osVersion;
        private String sdkName;
        private int sdkVersionCode = Integer.MIN_VALUE;
        private String sdkVersionName;
        private String lang;
        private String deviceId;

        public Builder headersPlatform(String platform) {
            this.platform = platform;
            return this;
        }

        public Builder headersOSVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public Builder headersSdkName(String sdkName) {
            this.sdkName = sdkName;
            return this;
        }

        public Builder headersSdkVersionCode(int sdkVersionCode) {
            this.sdkVersionCode = sdkVersionCode;
            return this;
        }

        public Builder headersSdkVersionName(String sdkVersionName) {
            this.sdkVersionName = sdkVersionName;
            return this;
        }

        public Builder headersLang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder headersDeviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public XUAParams build() {
            return new XUAParams(this);
        }
    }

    public static interface TapDBDataObserver {
        public String getTapDBDeviceId();
    }
}

