/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.net.json;

import com.tds.common.net.json.TypeRef;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtil {
    public static <T> T parse(JSONObject jsonObject, Class<T> clazz) throws JSONException {
        try {
            return JsonUtil.parseObject(jsonObject, clazz);
        }
        catch (Exception e) {
            if (e instanceof JSONException) {
                throw (JSONException)((Object)e);
            }
            throw (JSONException)new JSONException(jsonObject.toString()).initCause((Throwable)e);
        }
    }

    public static <T> T parse(String json, Class<T> clazz) throws JSONException {
        try {
            return JsonUtil.parseInternal(json, clazz);
        }
        catch (Exception e) {
            if (e instanceof JSONException) {
                throw (JSONException)((Object)e);
            }
            throw (JSONException)new JSONException(json).initCause((Throwable)e);
        }
    }

    private static <T> T parseInternal(String json, Class<T> clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, JSONException, InvocationTargetException {
        if (clazz.isArray()) {
            return JsonUtil.parseArray(json, clazz);
        }
        if (clazz.isPrimitive()) {
            return JsonUtil.parsePrimitive(json, clazz);
        }
        if (clazz == String.class) {
            return (T)JsonUtil.parseString(json);
        }
        return JsonUtil.parseObject(json, clazz);
    }

    public static <T> T parse(String json, TypeRef<T> typeRef) throws JSONException {
        try {
            return JsonUtil.parseInternal(json, typeRef);
        }
        catch (Exception e) {
            if (e instanceof JSONException) {
                throw (JSONException)((Object)e);
            }
            throw (JSONException)new JSONException(json).initCause((Throwable)e);
        }
    }

    private static <T> T parseInternal(String json, TypeRef<T> typeRef) throws NoSuchMethodException, JSONException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class rawType = (Class)typeRef.type.getRawType();
        Type[] genericTypes = typeRef.type.getActualTypeArguments();
        Class[] constructorTypes = new Class[genericTypes.length + 1];
        constructorTypes[0] = JSONObject.class;
        for (int i = 1; i < constructorTypes.length; ++i) {
            constructorTypes[i] = Class.class;
        }
        Constructor constructor = rawType.getDeclaredConstructor(constructorTypes);
        constructor.setAccessible(true);
        Object[] constructorParams = new Object[constructorTypes.length];
        constructorParams[0] = new JSONObject(json);
        for (int i = 1; i < constructorParams.length; ++i) {
            constructorParams[i] = genericTypes[i - 1];
        }
        return constructor.newInstance(constructorParams);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> T parseArray(String json, Class<T> clazz) throws JSONException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Class<?> com = clazz.getComponentType();
        JSONArray array = new JSONArray(json);
        int len = array.length();
        Object result = Array.newInstance(com, len);
        if (com.isPrimitive()) {
            if (com == Boolean.TYPE) {
                for (int i = 0; i < len; ++i) {
                    Array.setBoolean(result, i, array.getBoolean(i));
                }
                return (T)result;
            } else if (com == Integer.TYPE) {
                for (int i = 0; i < len; ++i) {
                    Array.setInt(result, i, array.getInt(i));
                }
                return (T)result;
            } else if (com == Long.TYPE) {
                for (int i = 0; i < len; ++i) {
                    Array.setLong(result, i, array.getLong(i));
                }
                return (T)result;
            } else if (com == Float.TYPE) {
                for (int i = 0; i < len; ++i) {
                    Array.setFloat(result, i, (float)array.getDouble(i));
                }
                return (T)result;
            } else {
                if (com != Double.TYPE) throw new UnsupportedOperationException(json + " - " + com.toString());
                for (int i = 0; i < len; ++i) {
                    Array.setDouble(result, i, array.getDouble(i));
                }
            }
            return (T)result;
        } else {
            Constructor<?> constructor = com.getDeclaredConstructor(JSONObject.class);
            constructor.setAccessible(true);
            for (int i = 0; i < len; ++i) {
                Object value = constructor.newInstance(array.getJSONObject(i));
                Array.set(result, i, value);
            }
        }
        return (T)result;
    }

    private static <T> T parsePrimitive(String json, Class<T> clazz) {
        if (clazz == Boolean.TYPE) {
            return (T)Boolean.valueOf(json);
        }
        if (clazz == Integer.TYPE) {
            return (T)Integer.valueOf(json);
        }
        if (clazz == Long.TYPE) {
            return (T)Long.valueOf(json);
        }
        if (clazz == Float.TYPE) {
            return (T)Float.valueOf(json);
        }
        if (clazz == Double.TYPE) {
            return (T)Double.valueOf(json);
        }
        throw new UnsupportedOperationException(json + " - " + clazz.toString());
    }

    private static String parseString(String json) {
        json = json.trim();
        return json.substring(1, json.length() - 1);
    }

    private static <T> T parseObject(String json, Class<T> clazz) throws NoSuchMethodException, JSONException, IllegalAccessException, InvocationTargetException, InstantiationException {
        JSONObject jsonObject = new JSONObject(json);
        return JsonUtil.parseObject(jsonObject, clazz);
    }

    private static <T> T parseObject(JSONObject jsonObject, Class<T> clazz) throws NoSuchMethodException, JSONException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> constructor = clazz.getDeclaredConstructor(JSONObject.class);
        constructor.setAccessible(true);
        return constructor.newInstance(jsonObject);
    }

    public static Map<String, Object> toMap(JSONObject jsonObj) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = jsonObj.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List<Object> value = jsonObj.get(key);
            if (value instanceof JSONArray) {
                value = JsonUtil.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JsonUtil.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    public static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = JsonUtil.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JsonUtil.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }
}

