/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.oauth;

import com.tds.common.annotation.Keep;
import com.tds.common.net.util.HostReplaceUtil;

@Keep
public enum RegionType {
    CN{

        @Override
        public String profileUrl() {
            return this.getOpenApiHost() + "account/profile/v1?client_id=%s";
        }

        @Override
        public String testQualificationUrl() {
            return this.getOpenApiHost() + "test/user-status/v1?client_id=%s";
        }

        @Override
        public String tokenUrl() {
            return this.getWebHost() + "oauth2/v1/token";
        }

        @Override
        public String authorizeUrl() {
            return this.getWebHost() + "oauth2/v1/authorize";
        }

        @Override
        public String targetActionName() {
            return "com.taptap.sdk.action";
        }

        @Override
        public String getOpenApiHost() {
            return HostReplaceUtil.getInstance().getReplacedHost("https://openapi.taptap.com/");
        }

        @Override
        public String getWebHost() {
            return HostReplaceUtil.getInstance().getReplacedHost("https://www.taptap.com/");
        }
    }
    ,
    IO{

        @Override
        public String profileUrl() {
            return this.getOpenApiHost() + "account/profile/v1?client_id=%s";
        }

        @Override
        public String testQualificationUrl() {
            return this.getOpenApiHost() + "test/user-status/v1?client_id=%s";
        }

        @Override
        public String tokenUrl() {
            return this.getWebHost() + "oauth2/v1/token";
        }

        @Override
        public String authorizeUrl() {
            return this.getWebHost() + "oauth2/v1/authorize";
        }

        @Override
        public String targetActionName() {
            return "com.taptap.global.sdk.action";
        }

        @Override
        public String getOpenApiHost() {
            return HostReplaceUtil.getInstance().getReplacedHost("https://openapi.tap.io/");
        }

        @Override
        public String getWebHost() {
            return HostReplaceUtil.getInstance().getReplacedHost("https://www.tap.io/");
        }
    };


    public abstract String profileUrl();

    public abstract String testQualificationUrl();

    public abstract String tokenUrl();

    public abstract String authorizeUrl();

    public abstract String targetActionName();

    public abstract String getOpenApiHost();

    public abstract String getWebHost();
}

