/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.oauth.models;

import android.app.Activity;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.tds.common.TapCommon;
import com.tds.common.annotation.Keep;
import com.tds.common.utils.GUIDHelper;
import java.util.UUID;

@Keep
public class AuthorizeRequest
implements Parcelable {
    private static final int LOGIN_SESSION_CODE = 10;
    public static final String TAG_GAME = "GAME";
    private final String state;
    private final String[] permissions;
    private int requestCode = -1;
    private String versionCode;
    private String info;
    private String loginVersion = "0";
    private String responseType = "code";
    private String redirectUri;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String clientId;
    private String codeVerifier;
    public static final Parcelable.Creator<AuthorizeRequest> CREATOR = new Parcelable.Creator<AuthorizeRequest>(){

        public AuthorizeRequest createFromParcel(Parcel source) {
            return new AuthorizeRequest(source);
        }

        public AuthorizeRequest[] newArray(int size) {
            return new AuthorizeRequest[size];
        }
    };

    public String getState() {
        return this.state;
    }

    public String getVersionCode() {
        return this.versionCode;
    }

    public void setVersionCode(String versionCode) {
        this.versionCode = versionCode;
    }

    public int getRequestCode() {
        if (this.requestCode == -1) {
            this.requestCode = 10;
        }
        return this.requestCode;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getLoginVersion() {
        return this.loginVersion;
    }

    public void setLoginVersion(String loginVersion) {
        this.loginVersion = loginVersion;
    }

    public String[] getPermissions() {
        return this.permissions;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public void setCodeVerifier(String codeVerifier) {
        this.codeVerifier = codeVerifier;
    }

    public AuthorizeRequest(String ... permissions) {
        this.permissions = permissions;
        this.state = UUID.randomUUID().toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.state);
        dest.writeStringArray(this.permissions);
        dest.writeInt(this.requestCode);
        dest.writeString(this.versionCode);
        dest.writeString(this.info);
        dest.writeString(this.loginVersion);
        dest.writeString(this.responseType);
        dest.writeString(this.redirectUri);
        dest.writeString(this.codeChallenge);
        dest.writeString(this.codeChallengeMethod);
    }

    protected AuthorizeRequest(Parcel in) {
        this.state = in.readString();
        this.permissions = in.createStringArray();
        this.requestCode = in.readInt();
        this.versionCode = in.readString();
        this.info = in.readString();
        this.loginVersion = in.readString();
        this.responseType = in.readString();
        this.redirectUri = in.readString();
        this.codeChallenge = in.readString();
        this.codeChallengeMethod = in.readString();
    }

    public static String generateInfo(Activity activity, String source) {
        String orientation = "horizontal";
        String clientId = TapCommon.getTapConfig().clientId;
        try {
            if (activity.getResources().getConfiguration().orientation == 1) {
                orientation = "vertical";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (TextUtils.equals((CharSequence)source, (CharSequence)TAG_GAME)) {
            return "client_id=" + clientId + "&uuid=" + GUIDHelper.INSTANCE.getUID() + "&name=TapLoginAndroid&orientation=" + orientation + "&version=" + "3.16.5";
        }
        return "biz_source=" + source + "&client_id=" + clientId + "&uuid=" + GUIDHelper.INSTANCE.getUID() + "&name=TapLoginAndroid&orientation=" + orientation + "&version=" + "3.16.5";
    }

    public static String generateSDKInfo(Activity activity, String clientId) {
        String orientation = "horizontal";
        try {
            if (activity.getResources().getConfiguration().orientation == 1) {
                orientation = "vertical";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "client_id=" + clientId + "&uuid=" + GUIDHelper.INSTANCE.getUID() + "&name=TapSDK&orientation=" + orientation + "&version=" + "3.16.5" + "&version_code=" + 31605001;
    }
}

